/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LnrpcHopHint {
    public static final String SERIALIZED_NAME_NODE_ID = "node_id";
    @SerializedName(value="node_id")
    private String nodeId;
    public static final String SERIALIZED_NAME_CHAN_ID = "chan_id";
    @SerializedName(value="chan_id")
    private String chanId;
    public static final String SERIALIZED_NAME_FEE_BASE_MSAT = "fee_base_msat";
    @SerializedName(value="fee_base_msat")
    private Long feeBaseMsat;
    public static final String SERIALIZED_NAME_FEE_PROPORTIONAL_MILLIONTHS = "fee_proportional_millionths";
    @SerializedName(value="fee_proportional_millionths")
    private Long feeProportionalMillionths;
    public static final String SERIALIZED_NAME_CLTV_EXPIRY_DELTA = "cltv_expiry_delta";
    @SerializedName(value="cltv_expiry_delta")
    private Long cltvExpiryDelta;

    public LnrpcHopHint nodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The public key of the node at the start of the channel.")
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public LnrpcHopHint chanId(String chanId) {
        this.chanId = chanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of the channel.")
    public String getChanId() {
        return this.chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public LnrpcHopHint feeBaseMsat(Long feeBaseMsat) {
        this.feeBaseMsat = feeBaseMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The base fee of the channel denominated in millisatoshis.")
    public Long getFeeBaseMsat() {
        return this.feeBaseMsat;
    }

    public void setFeeBaseMsat(Long feeBaseMsat) {
        this.feeBaseMsat = feeBaseMsat;
    }

    public LnrpcHopHint feeProportionalMillionths(Long feeProportionalMillionths) {
        this.feeProportionalMillionths = feeProportionalMillionths;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee rate of the channel for sending one satoshi across it denominated in millionths of a satoshi.")
    public Long getFeeProportionalMillionths() {
        return this.feeProportionalMillionths;
    }

    public void setFeeProportionalMillionths(Long feeProportionalMillionths) {
        this.feeProportionalMillionths = feeProportionalMillionths;
    }

    public LnrpcHopHint cltvExpiryDelta(Long cltvExpiryDelta) {
        this.cltvExpiryDelta = cltvExpiryDelta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time-lock delta of the channel.")
    public Long getCltvExpiryDelta() {
        return this.cltvExpiryDelta;
    }

    public void setCltvExpiryDelta(Long cltvExpiryDelta) {
        this.cltvExpiryDelta = cltvExpiryDelta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcHopHint lnrpcHopHint = (LnrpcHopHint)o;
        return Objects.equals(this.nodeId, lnrpcHopHint.nodeId) && Objects.equals(this.chanId, lnrpcHopHint.chanId) && Objects.equals(this.feeBaseMsat, lnrpcHopHint.feeBaseMsat) && Objects.equals(this.feeProportionalMillionths, lnrpcHopHint.feeProportionalMillionths) && Objects.equals(this.cltvExpiryDelta, lnrpcHopHint.cltvExpiryDelta);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.chanId, this.feeBaseMsat, this.feeProportionalMillionths, this.cltvExpiryDelta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcHopHint {\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    chanId: ").append(this.toIndentedString(this.chanId)).append("\n");
        sb.append("    feeBaseMsat: ").append(this.toIndentedString(this.feeBaseMsat)).append("\n");
        sb.append("    feeProportionalMillionths: ").append(this.toIndentedString(this.feeProportionalMillionths)).append("\n");
        sb.append("    cltvExpiryDelta: ").append(this.toIndentedString(this.cltvExpiryDelta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

