/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcAMPRecord;
import net.osslabz.lnd.dto.LnrpcMPPRecord;

public class LnrpcHop {
    public static final String SERIALIZED_NAME_CHAN_ID = "chan_id";
    @SerializedName(value="chan_id")
    private String chanId;
    public static final String SERIALIZED_NAME_CHAN_CAPACITY = "chan_capacity";
    @SerializedName(value="chan_capacity")
    private String chanCapacity;
    public static final String SERIALIZED_NAME_AMT_TO_FORWARD = "amt_to_forward";
    @SerializedName(value="amt_to_forward")
    private String amtToForward;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private String fee;
    public static final String SERIALIZED_NAME_EXPIRY = "expiry";
    @SerializedName(value="expiry")
    private Long expiry;
    public static final String SERIALIZED_NAME_AMT_TO_FORWARD_MSAT = "amt_to_forward_msat";
    @SerializedName(value="amt_to_forward_msat")
    private String amtToForwardMsat;
    public static final String SERIALIZED_NAME_FEE_MSAT = "fee_msat";
    @SerializedName(value="fee_msat")
    private String feeMsat;
    public static final String SERIALIZED_NAME_PUB_KEY = "pub_key";
    @SerializedName(value="pub_key")
    private String pubKey;
    public static final String SERIALIZED_NAME_TLV_PAYLOAD = "tlv_payload";
    @SerializedName(value="tlv_payload")
    private Boolean tlvPayload;
    public static final String SERIALIZED_NAME_MPP_RECORD = "mpp_record";
    @SerializedName(value="mpp_record")
    private LnrpcMPPRecord mppRecord;
    public static final String SERIALIZED_NAME_AMP_RECORD = "amp_record";
    @SerializedName(value="amp_record")
    private LnrpcAMPRecord ampRecord;
    public static final String SERIALIZED_NAME_CUSTOM_RECORDS = "custom_records";
    @SerializedName(value="custom_records")
    private Map<String, byte[]> customRecords = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private byte[] metadata;

    public LnrpcHop chanId(String chanId) {
        this.chanId = chanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique channel ID for the channel. The first 3 bytes are the block height, the next 3 the index within the block, and the last 2 bytes are the output index for the channel.")
    public String getChanId() {
        return this.chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public LnrpcHop chanCapacity(String chanCapacity) {
        this.chanCapacity = chanCapacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getChanCapacity() {
        return this.chanCapacity;
    }

    public void setChanCapacity(String chanCapacity) {
        this.chanCapacity = chanCapacity;
    }

    public LnrpcHop amtToForward(String amtToForward) {
        this.amtToForward = amtToForward;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAmtToForward() {
        return this.amtToForward;
    }

    public void setAmtToForward(String amtToForward) {
        this.amtToForward = amtToForward;
    }

    public LnrpcHop fee(String fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getFee() {
        return this.fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public LnrpcHop expiry(Long expiry) {
        this.expiry = expiry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    public LnrpcHop amtToForwardMsat(String amtToForwardMsat) {
        this.amtToForwardMsat = amtToForwardMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAmtToForwardMsat() {
        return this.amtToForwardMsat;
    }

    public void setAmtToForwardMsat(String amtToForwardMsat) {
        this.amtToForwardMsat = amtToForwardMsat;
    }

    public LnrpcHop feeMsat(String feeMsat) {
        this.feeMsat = feeMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getFeeMsat() {
        return this.feeMsat;
    }

    public void setFeeMsat(String feeMsat) {
        this.feeMsat = feeMsat;
    }

    public LnrpcHop pubKey(String pubKey) {
        this.pubKey = pubKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional public key of the hop. If the public key is given, the payment can be executed without relying on a copy of the channel graph.")
    public String getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = pubKey;
    }

    public LnrpcHop tlvPayload(Boolean tlvPayload) {
        this.tlvPayload = tlvPayload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to true, then this hop will be encoded using the new variable length TLV format. Note that if any custom tlv_records below are specified, then this field MUST be set to true for them to be encoded properly.")
    public Boolean getTlvPayload() {
        return this.tlvPayload;
    }

    public void setTlvPayload(Boolean tlvPayload) {
        this.tlvPayload = tlvPayload;
    }

    public LnrpcHop mppRecord(LnrpcMPPRecord mppRecord) {
        this.mppRecord = mppRecord;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcMPPRecord getMppRecord() {
        return this.mppRecord;
    }

    public void setMppRecord(LnrpcMPPRecord mppRecord) {
        this.mppRecord = mppRecord;
    }

    public LnrpcHop ampRecord(LnrpcAMPRecord ampRecord) {
        this.ampRecord = ampRecord;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcAMPRecord getAmpRecord() {
        return this.ampRecord;
    }

    public void setAmpRecord(LnrpcAMPRecord ampRecord) {
        this.ampRecord = ampRecord;
    }

    public LnrpcHop customRecords(Map<String, byte[]> customRecords) {
        this.customRecords = customRecords;
        return this;
    }

    public LnrpcHop putCustomRecordsItem(String key, byte[] customRecordsItem) {
        if (this.customRecords == null) {
            this.customRecords = new HashMap<String, byte[]>();
        }
        this.customRecords.put(key, customRecordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional set of key-value TLV records. This is useful within the context of the SendToRoute call as it allows callers to specify arbitrary K-V pairs to drop off at each hop within the onion.")
    public Map<String, byte[]> getCustomRecords() {
        return this.customRecords;
    }

    public void setCustomRecords(Map<String, byte[]> customRecords) {
        this.customRecords = customRecords;
    }

    public LnrpcHop metadata(byte[] metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment metadata to send along with the payment to the payee.")
    public byte[] getMetadata() {
        return this.metadata;
    }

    public void setMetadata(byte[] metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcHop lnrpcHop = (LnrpcHop)o;
        return Objects.equals(this.chanId, lnrpcHop.chanId) && Objects.equals(this.chanCapacity, lnrpcHop.chanCapacity) && Objects.equals(this.amtToForward, lnrpcHop.amtToForward) && Objects.equals(this.fee, lnrpcHop.fee) && Objects.equals(this.expiry, lnrpcHop.expiry) && Objects.equals(this.amtToForwardMsat, lnrpcHop.amtToForwardMsat) && Objects.equals(this.feeMsat, lnrpcHop.feeMsat) && Objects.equals(this.pubKey, lnrpcHop.pubKey) && Objects.equals(this.tlvPayload, lnrpcHop.tlvPayload) && Objects.equals(this.mppRecord, lnrpcHop.mppRecord) && Objects.equals(this.ampRecord, lnrpcHop.ampRecord) && Objects.equals(this.customRecords, lnrpcHop.customRecords) && Arrays.equals(this.metadata, lnrpcHop.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.chanId, this.chanCapacity, this.amtToForward, this.fee, this.expiry, this.amtToForwardMsat, this.feeMsat, this.pubKey, this.tlvPayload, this.mppRecord, this.ampRecord, this.customRecords, Arrays.hashCode(this.metadata));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcHop {\n");
        sb.append("    chanId: ").append(this.toIndentedString(this.chanId)).append("\n");
        sb.append("    chanCapacity: ").append(this.toIndentedString(this.chanCapacity)).append("\n");
        sb.append("    amtToForward: ").append(this.toIndentedString(this.amtToForward)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    expiry: ").append(this.toIndentedString(this.expiry)).append("\n");
        sb.append("    amtToForwardMsat: ").append(this.toIndentedString(this.amtToForwardMsat)).append("\n");
        sb.append("    feeMsat: ").append(this.toIndentedString(this.feeMsat)).append("\n");
        sb.append("    pubKey: ").append(this.toIndentedString(this.pubKey)).append("\n");
        sb.append("    tlvPayload: ").append(this.toIndentedString(this.tlvPayload)).append("\n");
        sb.append("    mppRecord: ").append(this.toIndentedString(this.mppRecord)).append("\n");
        sb.append("    ampRecord: ").append(this.toIndentedString(this.ampRecord)).append("\n");
        sb.append("    customRecords: ").append(this.toIndentedString(this.customRecords)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

