/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import net.osslabz.lnd.dto.HTLCAttemptHTLCStatus;
import net.osslabz.lnd.dto.LnrpcFailure;
import net.osslabz.lnd.dto.LnrpcRoute;

public class LnrpcHTLCAttempt {
    public static final String SERIALIZED_NAME_ATTEMPT_ID = "attempt_id";
    @SerializedName(value="attempt_id")
    private String attemptId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private HTLCAttemptHTLCStatus status = HTLCAttemptHTLCStatus.IN_FLIGHT;
    public static final String SERIALIZED_NAME_ROUTE = "route";
    @SerializedName(value="route")
    private LnrpcRoute route;
    public static final String SERIALIZED_NAME_ATTEMPT_TIME_NS = "attempt_time_ns";
    @SerializedName(value="attempt_time_ns")
    private String attemptTimeNs;
    public static final String SERIALIZED_NAME_RESOLVE_TIME_NS = "resolve_time_ns";
    @SerializedName(value="resolve_time_ns")
    private String resolveTimeNs;
    public static final String SERIALIZED_NAME_FAILURE = "failure";
    @SerializedName(value="failure")
    private LnrpcFailure failure;
    public static final String SERIALIZED_NAME_PREIMAGE = "preimage";
    @SerializedName(value="preimage")
    private byte[] preimage;

    public LnrpcHTLCAttempt attemptId(String attemptId) {
        this.attemptId = attemptId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique ID that is used for this attempt.")
    public String getAttemptId() {
        return this.attemptId;
    }

    public void setAttemptId(String attemptId) {
        this.attemptId = attemptId;
    }

    public LnrpcHTLCAttempt status(HTLCAttemptHTLCStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HTLCAttemptHTLCStatus getStatus() {
        return this.status;
    }

    public void setStatus(HTLCAttemptHTLCStatus status) {
        this.status = status;
    }

    public LnrpcHTLCAttempt route(LnrpcRoute route) {
        this.route = route;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcRoute getRoute() {
        return this.route;
    }

    public void setRoute(LnrpcRoute route) {
        this.route = route;
    }

    public LnrpcHTLCAttempt attemptTimeNs(String attemptTimeNs) {
        this.attemptTimeNs = attemptTimeNs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time in UNIX nanoseconds at which this HTLC was sent.")
    public String getAttemptTimeNs() {
        return this.attemptTimeNs;
    }

    public void setAttemptTimeNs(String attemptTimeNs) {
        this.attemptTimeNs = attemptTimeNs;
    }

    public LnrpcHTLCAttempt resolveTimeNs(String resolveTimeNs) {
        this.resolveTimeNs = resolveTimeNs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time in UNIX nanoseconds at which this HTLC was settled or failed. This value will not be set if the HTLC is still IN_FLIGHT.")
    public String getResolveTimeNs() {
        return this.resolveTimeNs;
    }

    public void setResolveTimeNs(String resolveTimeNs) {
        this.resolveTimeNs = resolveTimeNs;
    }

    public LnrpcHTLCAttempt failure(LnrpcFailure failure) {
        this.failure = failure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcFailure getFailure() {
        return this.failure;
    }

    public void setFailure(LnrpcFailure failure) {
        this.failure = failure;
    }

    public LnrpcHTLCAttempt preimage(byte[] preimage) {
        this.preimage = preimage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The preimage that was used to settle the HTLC.")
    public byte[] getPreimage() {
        return this.preimage;
    }

    public void setPreimage(byte[] preimage) {
        this.preimage = preimage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcHTLCAttempt lnrpcHTLCAttempt = (LnrpcHTLCAttempt)o;
        return Objects.equals(this.attemptId, lnrpcHTLCAttempt.attemptId) && Objects.equals((Object)this.status, (Object)lnrpcHTLCAttempt.status) && Objects.equals(this.route, lnrpcHTLCAttempt.route) && Objects.equals(this.attemptTimeNs, lnrpcHTLCAttempt.attemptTimeNs) && Objects.equals(this.resolveTimeNs, lnrpcHTLCAttempt.resolveTimeNs) && Objects.equals(this.failure, lnrpcHTLCAttempt.failure) && Arrays.equals(this.preimage, lnrpcHTLCAttempt.preimage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attemptId, this.status, this.route, this.attemptTimeNs, this.resolveTimeNs, this.failure, Arrays.hashCode(this.preimage)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcHTLCAttempt {\n");
        sb.append("    attemptId: ").append(this.toIndentedString(this.attemptId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    route: ").append(this.toIndentedString(this.route)).append("\n");
        sb.append("    attemptTimeNs: ").append(this.toIndentedString(this.attemptTimeNs)).append("\n");
        sb.append("    resolveTimeNs: ").append(this.toIndentedString(this.resolveTimeNs)).append("\n");
        sb.append("    failure: ").append(this.toIndentedString(this.failure)).append("\n");
        sb.append("    preimage: ").append(this.toIndentedString(this.preimage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

