/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcChain;
import net.osslabz.lnd.dto.LnrpcFeature;

public class LnrpcGetInfoResponse {
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_COMMIT_HASH = "commit_hash";
    @SerializedName(value="commit_hash")
    private String commitHash;
    public static final String SERIALIZED_NAME_IDENTITY_PUBKEY = "identity_pubkey";
    @SerializedName(value="identity_pubkey")
    private String identityPubkey;
    public static final String SERIALIZED_NAME_ALIAS = "alias";
    @SerializedName(value="alias")
    private String alias;
    public static final String SERIALIZED_NAME_COLOR = "color";
    @SerializedName(value="color")
    private String color;
    public static final String SERIALIZED_NAME_NUM_PENDING_CHANNELS = "num_pending_channels";
    @SerializedName(value="num_pending_channels")
    private Long numPendingChannels;
    public static final String SERIALIZED_NAME_NUM_ACTIVE_CHANNELS = "num_active_channels";
    @SerializedName(value="num_active_channels")
    private Long numActiveChannels;
    public static final String SERIALIZED_NAME_NUM_INACTIVE_CHANNELS = "num_inactive_channels";
    @SerializedName(value="num_inactive_channels")
    private Long numInactiveChannels;
    public static final String SERIALIZED_NAME_NUM_PEERS = "num_peers";
    @SerializedName(value="num_peers")
    private Long numPeers;
    public static final String SERIALIZED_NAME_BLOCK_HEIGHT = "block_height";
    @SerializedName(value="block_height")
    private Long blockHeight;
    public static final String SERIALIZED_NAME_BLOCK_HASH = "block_hash";
    @SerializedName(value="block_hash")
    private String blockHash;
    public static final String SERIALIZED_NAME_BEST_HEADER_TIMESTAMP = "best_header_timestamp";
    @SerializedName(value="best_header_timestamp")
    private String bestHeaderTimestamp;
    public static final String SERIALIZED_NAME_SYNCED_TO_CHAIN = "synced_to_chain";
    @SerializedName(value="synced_to_chain")
    private Boolean syncedToChain;
    public static final String SERIALIZED_NAME_SYNCED_TO_GRAPH = "synced_to_graph";
    @SerializedName(value="synced_to_graph")
    private Boolean syncedToGraph;
    public static final String SERIALIZED_NAME_TESTNET = "testnet";
    @SerializedName(value="testnet")
    private Boolean testnet;
    public static final String SERIALIZED_NAME_CHAINS = "chains";
    @SerializedName(value="chains")
    private List<LnrpcChain> chains = null;
    public static final String SERIALIZED_NAME_URIS = "uris";
    @SerializedName(value="uris")
    private List<String> uris = null;
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private Map<String, LnrpcFeature> features = null;
    public static final String SERIALIZED_NAME_REQUIRE_HTLC_INTERCEPTOR = "require_htlc_interceptor";
    @SerializedName(value="require_htlc_interceptor")
    private Boolean requireHtlcInterceptor;
    public static final String SERIALIZED_NAME_STORE_FINAL_HTLC_RESOLUTIONS = "store_final_htlc_resolutions";
    @SerializedName(value="store_final_htlc_resolutions")
    private Boolean storeFinalHtlcResolutions;

    public LnrpcGetInfoResponse version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version of the LND software that the node is running.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public LnrpcGetInfoResponse commitHash(String commitHash) {
        this.commitHash = commitHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The SHA1 commit hash that the daemon is compiled with.")
    public String getCommitHash() {
        return this.commitHash;
    }

    public void setCommitHash(String commitHash) {
        this.commitHash = commitHash;
    }

    public LnrpcGetInfoResponse identityPubkey(String identityPubkey) {
        this.identityPubkey = identityPubkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity pubkey of the current node.")
    public String getIdentityPubkey() {
        return this.identityPubkey;
    }

    public void setIdentityPubkey(String identityPubkey) {
        this.identityPubkey = identityPubkey;
    }

    public LnrpcGetInfoResponse alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public LnrpcGetInfoResponse color(String color) {
        this.color = color;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public LnrpcGetInfoResponse numPendingChannels(Long numPendingChannels) {
        this.numPendingChannels = numPendingChannels;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getNumPendingChannels() {
        return this.numPendingChannels;
    }

    public void setNumPendingChannels(Long numPendingChannels) {
        this.numPendingChannels = numPendingChannels;
    }

    public LnrpcGetInfoResponse numActiveChannels(Long numActiveChannels) {
        this.numActiveChannels = numActiveChannels;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getNumActiveChannels() {
        return this.numActiveChannels;
    }

    public void setNumActiveChannels(Long numActiveChannels) {
        this.numActiveChannels = numActiveChannels;
    }

    public LnrpcGetInfoResponse numInactiveChannels(Long numInactiveChannels) {
        this.numInactiveChannels = numInactiveChannels;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getNumInactiveChannels() {
        return this.numInactiveChannels;
    }

    public void setNumInactiveChannels(Long numInactiveChannels) {
        this.numInactiveChannels = numInactiveChannels;
    }

    public LnrpcGetInfoResponse numPeers(Long numPeers) {
        this.numPeers = numPeers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getNumPeers() {
        return this.numPeers;
    }

    public void setNumPeers(Long numPeers) {
        this.numPeers = numPeers;
    }

    public LnrpcGetInfoResponse blockHeight(Long blockHeight) {
        this.blockHeight = blockHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(Long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public LnrpcGetInfoResponse blockHash(String blockHash) {
        this.blockHash = blockHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public LnrpcGetInfoResponse bestHeaderTimestamp(String bestHeaderTimestamp) {
        this.bestHeaderTimestamp = bestHeaderTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBestHeaderTimestamp() {
        return this.bestHeaderTimestamp;
    }

    public void setBestHeaderTimestamp(String bestHeaderTimestamp) {
        this.bestHeaderTimestamp = bestHeaderTimestamp;
    }

    public LnrpcGetInfoResponse syncedToChain(Boolean syncedToChain) {
        this.syncedToChain = syncedToChain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getSyncedToChain() {
        return this.syncedToChain;
    }

    public void setSyncedToChain(Boolean syncedToChain) {
        this.syncedToChain = syncedToChain;
    }

    public LnrpcGetInfoResponse syncedToGraph(Boolean syncedToGraph) {
        this.syncedToGraph = syncedToGraph;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether we consider ourselves synced with the public channel graph.")
    public Boolean getSyncedToGraph() {
        return this.syncedToGraph;
    }

    public void setSyncedToGraph(Boolean syncedToGraph) {
        this.syncedToGraph = syncedToGraph;
    }

    public LnrpcGetInfoResponse testnet(Boolean testnet) {
        this.testnet = testnet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getTestnet() {
        return this.testnet;
    }

    public void setTestnet(Boolean testnet) {
        this.testnet = testnet;
    }

    public LnrpcGetInfoResponse chains(List<LnrpcChain> chains) {
        this.chains = chains;
        return this;
    }

    public LnrpcGetInfoResponse addChainsItem(LnrpcChain chainsItem) {
        if (this.chains == null) {
            this.chains = new ArrayList<LnrpcChain>();
        }
        this.chains.add(chainsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<LnrpcChain> getChains() {
        return this.chains;
    }

    public void setChains(List<LnrpcChain> chains) {
        this.chains = chains;
    }

    public LnrpcGetInfoResponse uris(List<String> uris) {
        this.uris = uris;
        return this;
    }

    public LnrpcGetInfoResponse addUrisItem(String urisItem) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.add(urisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URIs of the current node.")
    public List<String> getUris() {
        return this.uris;
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    public LnrpcGetInfoResponse features(Map<String, LnrpcFeature> features) {
        this.features = features;
        return this;
    }

    public LnrpcGetInfoResponse putFeaturesItem(String key, LnrpcFeature featuresItem) {
        if (this.features == null) {
            this.features = new HashMap<String, LnrpcFeature>();
        }
        this.features.put(key, featuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Features that our node has advertised in our init message, node announcements and invoices.")
    public Map<String, LnrpcFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, LnrpcFeature> features) {
        this.features = features;
    }

    public LnrpcGetInfoResponse requireHtlcInterceptor(Boolean requireHtlcInterceptor) {
        this.requireHtlcInterceptor = requireHtlcInterceptor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the HTLC interceptor API is in always-on mode.")
    public Boolean getRequireHtlcInterceptor() {
        return this.requireHtlcInterceptor;
    }

    public void setRequireHtlcInterceptor(Boolean requireHtlcInterceptor) {
        this.requireHtlcInterceptor = requireHtlcInterceptor;
    }

    public LnrpcGetInfoResponse storeFinalHtlcResolutions(Boolean storeFinalHtlcResolutions) {
        this.storeFinalHtlcResolutions = storeFinalHtlcResolutions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether final htlc resolutions are stored on disk.")
    public Boolean getStoreFinalHtlcResolutions() {
        return this.storeFinalHtlcResolutions;
    }

    public void setStoreFinalHtlcResolutions(Boolean storeFinalHtlcResolutions) {
        this.storeFinalHtlcResolutions = storeFinalHtlcResolutions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcGetInfoResponse lnrpcGetInfoResponse = (LnrpcGetInfoResponse)o;
        return Objects.equals(this.version, lnrpcGetInfoResponse.version) && Objects.equals(this.commitHash, lnrpcGetInfoResponse.commitHash) && Objects.equals(this.identityPubkey, lnrpcGetInfoResponse.identityPubkey) && Objects.equals(this.alias, lnrpcGetInfoResponse.alias) && Objects.equals(this.color, lnrpcGetInfoResponse.color) && Objects.equals(this.numPendingChannels, lnrpcGetInfoResponse.numPendingChannels) && Objects.equals(this.numActiveChannels, lnrpcGetInfoResponse.numActiveChannels) && Objects.equals(this.numInactiveChannels, lnrpcGetInfoResponse.numInactiveChannels) && Objects.equals(this.numPeers, lnrpcGetInfoResponse.numPeers) && Objects.equals(this.blockHeight, lnrpcGetInfoResponse.blockHeight) && Objects.equals(this.blockHash, lnrpcGetInfoResponse.blockHash) && Objects.equals(this.bestHeaderTimestamp, lnrpcGetInfoResponse.bestHeaderTimestamp) && Objects.equals(this.syncedToChain, lnrpcGetInfoResponse.syncedToChain) && Objects.equals(this.syncedToGraph, lnrpcGetInfoResponse.syncedToGraph) && Objects.equals(this.testnet, lnrpcGetInfoResponse.testnet) && Objects.equals(this.chains, lnrpcGetInfoResponse.chains) && Objects.equals(this.uris, lnrpcGetInfoResponse.uris) && Objects.equals(this.features, lnrpcGetInfoResponse.features) && Objects.equals(this.requireHtlcInterceptor, lnrpcGetInfoResponse.requireHtlcInterceptor) && Objects.equals(this.storeFinalHtlcResolutions, lnrpcGetInfoResponse.storeFinalHtlcResolutions);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.commitHash, this.identityPubkey, this.alias, this.color, this.numPendingChannels, this.numActiveChannels, this.numInactiveChannels, this.numPeers, this.blockHeight, this.blockHash, this.bestHeaderTimestamp, this.syncedToChain, this.syncedToGraph, this.testnet, this.chains, this.uris, this.features, this.requireHtlcInterceptor, this.storeFinalHtlcResolutions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcGetInfoResponse {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    commitHash: ").append(this.toIndentedString(this.commitHash)).append("\n");
        sb.append("    identityPubkey: ").append(this.toIndentedString(this.identityPubkey)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    numPendingChannels: ").append(this.toIndentedString(this.numPendingChannels)).append("\n");
        sb.append("    numActiveChannels: ").append(this.toIndentedString(this.numActiveChannels)).append("\n");
        sb.append("    numInactiveChannels: ").append(this.toIndentedString(this.numInactiveChannels)).append("\n");
        sb.append("    numPeers: ").append(this.toIndentedString(this.numPeers)).append("\n");
        sb.append("    blockHeight: ").append(this.toIndentedString(this.blockHeight)).append("\n");
        sb.append("    blockHash: ").append(this.toIndentedString(this.blockHash)).append("\n");
        sb.append("    bestHeaderTimestamp: ").append(this.toIndentedString(this.bestHeaderTimestamp)).append("\n");
        sb.append("    syncedToChain: ").append(this.toIndentedString(this.syncedToChain)).append("\n");
        sb.append("    syncedToGraph: ").append(this.toIndentedString(this.syncedToGraph)).append("\n");
        sb.append("    testnet: ").append(this.toIndentedString(this.testnet)).append("\n");
        sb.append("    chains: ").append(this.toIndentedString(this.chains)).append("\n");
        sb.append("    uris: ").append(this.toIndentedString(this.uris)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    requireHtlcInterceptor: ").append(this.toIndentedString(this.requireHtlcInterceptor)).append("\n");
        sb.append("    storeFinalHtlcResolutions: ").append(this.toIndentedString(this.storeFinalHtlcResolutions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

