/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcFundingPsbtVerify {
    public static final String SERIALIZED_NAME_FUNDED_PSBT = "funded_psbt";
    @SerializedName(value="funded_psbt")
    private byte[] fundedPsbt;
    public static final String SERIALIZED_NAME_PENDING_CHAN_ID = "pending_chan_id";
    @SerializedName(value="pending_chan_id")
    private byte[] pendingChanId;
    public static final String SERIALIZED_NAME_SKIP_FINALIZE = "skip_finalize";
    @SerializedName(value="skip_finalize")
    private Boolean skipFinalize;

    public LnrpcFundingPsbtVerify fundedPsbt(byte[] fundedPsbt) {
        this.fundedPsbt = fundedPsbt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The funded but not yet signed PSBT that sends the exact channel capacity amount to the PK script returned in the open channel message in a previous step.")
    public byte[] getFundedPsbt() {
        return this.fundedPsbt;
    }

    public void setFundedPsbt(byte[] fundedPsbt) {
        this.fundedPsbt = fundedPsbt;
    }

    public LnrpcFundingPsbtVerify pendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pending channel ID of the channel to get the PSBT for.")
    public byte[] getPendingChanId() {
        return this.pendingChanId;
    }

    public void setPendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
    }

    public LnrpcFundingPsbtVerify skipFinalize(Boolean skipFinalize) {
        this.skipFinalize = skipFinalize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can only be used if the no_publish flag was set to true in the OpenChannel call meaning that the caller is solely responsible for publishing the final funding transaction. If skip_finalize is set to true then lnd will not wait for a FundingPsbtFinalize state step and instead assumes that a transaction with the same TXID as the passed in PSBT will eventually confirm. IT IS ABSOLUTELY IMPERATIVE that the TXID of the transaction that is eventually published does have the _same TXID_ as the verified PSBT. That means no inputs or outputs can change, only signatures can be added. If the TXID changes between this call and the publish step then the channel will never be created and the funds will be in limbo.")
    public Boolean getSkipFinalize() {
        return this.skipFinalize;
    }

    public void setSkipFinalize(Boolean skipFinalize) {
        this.skipFinalize = skipFinalize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcFundingPsbtVerify lnrpcFundingPsbtVerify = (LnrpcFundingPsbtVerify)o;
        return Arrays.equals(this.fundedPsbt, lnrpcFundingPsbtVerify.fundedPsbt) && Arrays.equals(this.pendingChanId, lnrpcFundingPsbtVerify.pendingChanId) && Objects.equals(this.skipFinalize, lnrpcFundingPsbtVerify.skipFinalize);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.fundedPsbt), Arrays.hashCode(this.pendingChanId), this.skipFinalize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcFundingPsbtVerify {\n");
        sb.append("    fundedPsbt: ").append(this.toIndentedString(this.fundedPsbt)).append("\n");
        sb.append("    pendingChanId: ").append(this.toIndentedString(this.pendingChanId)).append("\n");
        sb.append("    skipFinalize: ").append(this.toIndentedString(this.skipFinalize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

