/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcFundingPsbtFinalize {
    public static final String SERIALIZED_NAME_SIGNED_PSBT = "signed_psbt";
    @SerializedName(value="signed_psbt")
    private byte[] signedPsbt;
    public static final String SERIALIZED_NAME_PENDING_CHAN_ID = "pending_chan_id";
    @SerializedName(value="pending_chan_id")
    private byte[] pendingChanId;
    public static final String SERIALIZED_NAME_FINAL_RAW_TX = "final_raw_tx";
    @SerializedName(value="final_raw_tx")
    private byte[] finalRawTx;

    public LnrpcFundingPsbtFinalize signedPsbt(byte[] signedPsbt) {
        this.signedPsbt = signedPsbt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The funded PSBT that contains all witness data to send the exact channel capacity amount to the PK script returned in the open channel message in a previous step. Cannot be set at the same time as final_raw_tx.")
    public byte[] getSignedPsbt() {
        return this.signedPsbt;
    }

    public void setSignedPsbt(byte[] signedPsbt) {
        this.signedPsbt = signedPsbt;
    }

    public LnrpcFundingPsbtFinalize pendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pending channel ID of the channel to get the PSBT for.")
    public byte[] getPendingChanId() {
        return this.pendingChanId;
    }

    public void setPendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
    }

    public LnrpcFundingPsbtFinalize finalRawTx(byte[] finalRawTx) {
        this.finalRawTx = finalRawTx;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="As an alternative to the signed PSBT with all witness data, the final raw wire format transaction can also be specified directly. Cannot be set at the same time as signed_psbt.")
    public byte[] getFinalRawTx() {
        return this.finalRawTx;
    }

    public void setFinalRawTx(byte[] finalRawTx) {
        this.finalRawTx = finalRawTx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcFundingPsbtFinalize lnrpcFundingPsbtFinalize = (LnrpcFundingPsbtFinalize)o;
        return Arrays.equals(this.signedPsbt, lnrpcFundingPsbtFinalize.signedPsbt) && Arrays.equals(this.pendingChanId, lnrpcFundingPsbtFinalize.pendingChanId) && Arrays.equals(this.finalRawTx, lnrpcFundingPsbtFinalize.finalRawTx);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.signedPsbt), Arrays.hashCode(this.pendingChanId), Arrays.hashCode(this.finalRawTx));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcFundingPsbtFinalize {\n");
        sb.append("    signedPsbt: ").append(this.toIndentedString(this.signedPsbt)).append("\n");
        sb.append("    pendingChanId: ").append(this.toIndentedString(this.pendingChanId)).append("\n");
        sb.append("    finalRawTx: ").append(this.toIndentedString(this.finalRawTx)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

