/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LnrpcForwardingHistoryRequest {
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private String startTime;
    public static final String SERIALIZED_NAME_END_TIME = "end_time";
    @SerializedName(value="end_time")
    private String endTime;
    public static final String SERIALIZED_NAME_INDEX_OFFSET = "index_offset";
    @SerializedName(value="index_offset")
    private Long indexOffset;
    public static final String SERIALIZED_NAME_NUM_MAX_EVENTS = "num_max_events";
    @SerializedName(value="num_max_events")
    private Long numMaxEvents;
    public static final String SERIALIZED_NAME_PEER_ALIAS_LOOKUP = "peer_alias_lookup";
    @SerializedName(value="peer_alias_lookup")
    private Boolean peerAliasLookup;

    public LnrpcForwardingHistoryRequest startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Start time is the starting point of the forwarding history request. All records beyond this point will be included, respecting the end time, and the index offset.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public LnrpcForwardingHistoryRequest endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="End time is the end point of the forwarding history request. The response will carry at most 50k records between the start time and the end time. The index offset can be used to implement pagination.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public LnrpcForwardingHistoryRequest indexOffset(Long indexOffset) {
        this.indexOffset = indexOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index offset is the offset in the time series to start at. As each response can only contain 50k records, callers can use this to skip around within a packed time series.")
    public Long getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(Long indexOffset) {
        this.indexOffset = indexOffset;
    }

    public LnrpcForwardingHistoryRequest numMaxEvents(Long numMaxEvents) {
        this.numMaxEvents = numMaxEvents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The max number of events to return in the response to this query.")
    public Long getNumMaxEvents() {
        return this.numMaxEvents;
    }

    public void setNumMaxEvents(Long numMaxEvents) {
        this.numMaxEvents = numMaxEvents;
    }

    public LnrpcForwardingHistoryRequest peerAliasLookup(Boolean peerAliasLookup) {
        this.peerAliasLookup = peerAliasLookup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Informs the server if the peer alias should be looked up for each forwarding event.")
    public Boolean getPeerAliasLookup() {
        return this.peerAliasLookup;
    }

    public void setPeerAliasLookup(Boolean peerAliasLookup) {
        this.peerAliasLookup = peerAliasLookup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcForwardingHistoryRequest lnrpcForwardingHistoryRequest = (LnrpcForwardingHistoryRequest)o;
        return Objects.equals(this.startTime, lnrpcForwardingHistoryRequest.startTime) && Objects.equals(this.endTime, lnrpcForwardingHistoryRequest.endTime) && Objects.equals(this.indexOffset, lnrpcForwardingHistoryRequest.indexOffset) && Objects.equals(this.numMaxEvents, lnrpcForwardingHistoryRequest.numMaxEvents) && Objects.equals(this.peerAliasLookup, lnrpcForwardingHistoryRequest.peerAliasLookup);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.indexOffset, this.numMaxEvents, this.peerAliasLookup);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcForwardingHistoryRequest {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    indexOffset: ").append(this.toIndentedString(this.indexOffset)).append("\n");
        sb.append("    numMaxEvents: ").append(this.toIndentedString(this.numMaxEvents)).append("\n");
        sb.append("    peerAliasLookup: ").append(this.toIndentedString(this.peerAliasLookup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

