/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LnrpcForwardingEvent {
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private String timestamp;
    public static final String SERIALIZED_NAME_CHAN_ID_IN = "chan_id_in";
    @SerializedName(value="chan_id_in")
    private String chanIdIn;
    public static final String SERIALIZED_NAME_CHAN_ID_OUT = "chan_id_out";
    @SerializedName(value="chan_id_out")
    private String chanIdOut;
    public static final String SERIALIZED_NAME_AMT_IN = "amt_in";
    @SerializedName(value="amt_in")
    private String amtIn;
    public static final String SERIALIZED_NAME_AMT_OUT = "amt_out";
    @SerializedName(value="amt_out")
    private String amtOut;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private String fee;
    public static final String SERIALIZED_NAME_FEE_MSAT = "fee_msat";
    @SerializedName(value="fee_msat")
    private String feeMsat;
    public static final String SERIALIZED_NAME_AMT_IN_MSAT = "amt_in_msat";
    @SerializedName(value="amt_in_msat")
    private String amtInMsat;
    public static final String SERIALIZED_NAME_AMT_OUT_MSAT = "amt_out_msat";
    @SerializedName(value="amt_out_msat")
    private String amtOutMsat;
    public static final String SERIALIZED_NAME_TIMESTAMP_NS = "timestamp_ns";
    @SerializedName(value="timestamp_ns")
    private String timestampNs;
    public static final String SERIALIZED_NAME_PEER_ALIAS_IN = "peer_alias_in";
    @SerializedName(value="peer_alias_in")
    private String peerAliasIn;
    public static final String SERIALIZED_NAME_PEER_ALIAS_OUT = "peer_alias_out";
    @SerializedName(value="peer_alias_out")
    private String peerAliasOut;

    public LnrpcForwardingEvent timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp is the time (unix epoch offset) that this circuit was completed. Deprecated by timestamp_ns.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public LnrpcForwardingEvent chanIdIn(String chanIdIn) {
        this.chanIdIn = chanIdIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The incoming channel ID that carried the HTLC that created the circuit.")
    public String getChanIdIn() {
        return this.chanIdIn;
    }

    public void setChanIdIn(String chanIdIn) {
        this.chanIdIn = chanIdIn;
    }

    public LnrpcForwardingEvent chanIdOut(String chanIdOut) {
        this.chanIdOut = chanIdOut;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The outgoing channel ID that carried the preimage that completed the circuit.")
    public String getChanIdOut() {
        return this.chanIdOut;
    }

    public void setChanIdOut(String chanIdOut) {
        this.chanIdOut = chanIdOut;
    }

    public LnrpcForwardingEvent amtIn(String amtIn) {
        this.amtIn = amtIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount (in satoshis) of the incoming HTLC that created half the circuit.")
    public String getAmtIn() {
        return this.amtIn;
    }

    public void setAmtIn(String amtIn) {
        this.amtIn = amtIn;
    }

    public LnrpcForwardingEvent amtOut(String amtOut) {
        this.amtOut = amtOut;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount (in satoshis) of the outgoing HTLC that created the second half of the circuit.")
    public String getAmtOut() {
        return this.amtOut;
    }

    public void setAmtOut(String amtOut) {
        this.amtOut = amtOut;
    }

    public LnrpcForwardingEvent fee(String fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total fee (in satoshis) that this payment circuit carried.")
    public String getFee() {
        return this.fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public LnrpcForwardingEvent feeMsat(String feeMsat) {
        this.feeMsat = feeMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total fee (in milli-satoshis) that this payment circuit carried.")
    public String getFeeMsat() {
        return this.feeMsat;
    }

    public void setFeeMsat(String feeMsat) {
        this.feeMsat = feeMsat;
    }

    public LnrpcForwardingEvent amtInMsat(String amtInMsat) {
        this.amtInMsat = amtInMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount (in milli-satoshis) of the incoming HTLC that created half the circuit.")
    public String getAmtInMsat() {
        return this.amtInMsat;
    }

    public void setAmtInMsat(String amtInMsat) {
        this.amtInMsat = amtInMsat;
    }

    public LnrpcForwardingEvent amtOutMsat(String amtOutMsat) {
        this.amtOutMsat = amtOutMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount (in milli-satoshis) of the outgoing HTLC that created the second half of the circuit.")
    public String getAmtOutMsat() {
        return this.amtOutMsat;
    }

    public void setAmtOutMsat(String amtOutMsat) {
        this.amtOutMsat = amtOutMsat;
    }

    public LnrpcForwardingEvent timestampNs(String timestampNs) {
        this.timestampNs = timestampNs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of nanoseconds elapsed since January 1, 1970 UTC when this circuit was completed.")
    public String getTimestampNs() {
        return this.timestampNs;
    }

    public void setTimestampNs(String timestampNs) {
        this.timestampNs = timestampNs;
    }

    public LnrpcForwardingEvent peerAliasIn(String peerAliasIn) {
        this.peerAliasIn = peerAliasIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The peer alias of the incoming channel.")
    public String getPeerAliasIn() {
        return this.peerAliasIn;
    }

    public void setPeerAliasIn(String peerAliasIn) {
        this.peerAliasIn = peerAliasIn;
    }

    public LnrpcForwardingEvent peerAliasOut(String peerAliasOut) {
        this.peerAliasOut = peerAliasOut;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The peer alias of the outgoing channel.")
    public String getPeerAliasOut() {
        return this.peerAliasOut;
    }

    public void setPeerAliasOut(String peerAliasOut) {
        this.peerAliasOut = peerAliasOut;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcForwardingEvent lnrpcForwardingEvent = (LnrpcForwardingEvent)o;
        return Objects.equals(this.timestamp, lnrpcForwardingEvent.timestamp) && Objects.equals(this.chanIdIn, lnrpcForwardingEvent.chanIdIn) && Objects.equals(this.chanIdOut, lnrpcForwardingEvent.chanIdOut) && Objects.equals(this.amtIn, lnrpcForwardingEvent.amtIn) && Objects.equals(this.amtOut, lnrpcForwardingEvent.amtOut) && Objects.equals(this.fee, lnrpcForwardingEvent.fee) && Objects.equals(this.feeMsat, lnrpcForwardingEvent.feeMsat) && Objects.equals(this.amtInMsat, lnrpcForwardingEvent.amtInMsat) && Objects.equals(this.amtOutMsat, lnrpcForwardingEvent.amtOutMsat) && Objects.equals(this.timestampNs, lnrpcForwardingEvent.timestampNs) && Objects.equals(this.peerAliasIn, lnrpcForwardingEvent.peerAliasIn) && Objects.equals(this.peerAliasOut, lnrpcForwardingEvent.peerAliasOut);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.chanIdIn, this.chanIdOut, this.amtIn, this.amtOut, this.fee, this.feeMsat, this.amtInMsat, this.amtOutMsat, this.timestampNs, this.peerAliasIn, this.peerAliasOut);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcForwardingEvent {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    chanIdIn: ").append(this.toIndentedString(this.chanIdIn)).append("\n");
        sb.append("    chanIdOut: ").append(this.toIndentedString(this.chanIdOut)).append("\n");
        sb.append("    amtIn: ").append(this.toIndentedString(this.amtIn)).append("\n");
        sb.append("    amtOut: ").append(this.toIndentedString(this.amtOut)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    feeMsat: ").append(this.toIndentedString(this.feeMsat)).append("\n");
        sb.append("    amtInMsat: ").append(this.toIndentedString(this.amtInMsat)).append("\n");
        sb.append("    amtOutMsat: ").append(this.toIndentedString(this.amtOutMsat)).append("\n");
        sb.append("    timestampNs: ").append(this.toIndentedString(this.timestampNs)).append("\n");
        sb.append("    peerAliasIn: ").append(this.toIndentedString(this.peerAliasIn)).append("\n");
        sb.append("    peerAliasOut: ").append(this.toIndentedString(this.peerAliasOut)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

