/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import net.osslabz.lnd.dto.FailureFailureCode;
import net.osslabz.lnd.dto.LnrpcChannelUpdate;

public class LnrpcFailure {
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private FailureFailureCode code = FailureFailureCode.RESERVED;
    public static final String SERIALIZED_NAME_CHANNEL_UPDATE = "channel_update";
    @SerializedName(value="channel_update")
    private LnrpcChannelUpdate channelUpdate;
    public static final String SERIALIZED_NAME_HTLC_MSAT = "htlc_msat";
    @SerializedName(value="htlc_msat")
    private String htlcMsat;
    public static final String SERIALIZED_NAME_ONION_SHA256 = "onion_sha_256";
    @SerializedName(value="onion_sha_256")
    private byte[] onionSha256;
    public static final String SERIALIZED_NAME_CLTV_EXPIRY = "cltv_expiry";
    @SerializedName(value="cltv_expiry")
    private Long cltvExpiry;
    public static final String SERIALIZED_NAME_FLAGS = "flags";
    @SerializedName(value="flags")
    private Long flags;
    public static final String SERIALIZED_NAME_FAILURE_SOURCE_INDEX = "failure_source_index";
    @SerializedName(value="failure_source_index")
    private Long failureSourceIndex;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Long height;

    public LnrpcFailure code(FailureFailureCode code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FailureFailureCode getCode() {
        return this.code;
    }

    public void setCode(FailureFailureCode code) {
        this.code = code;
    }

    public LnrpcFailure channelUpdate(LnrpcChannelUpdate channelUpdate) {
        this.channelUpdate = channelUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcChannelUpdate getChannelUpdate() {
        return this.channelUpdate;
    }

    public void setChannelUpdate(LnrpcChannelUpdate channelUpdate) {
        this.channelUpdate = channelUpdate;
    }

    public LnrpcFailure htlcMsat(String htlcMsat) {
        this.htlcMsat = htlcMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A failure type-dependent htlc value.")
    public String getHtlcMsat() {
        return this.htlcMsat;
    }

    public void setHtlcMsat(String htlcMsat) {
        this.htlcMsat = htlcMsat;
    }

    public LnrpcFailure onionSha256(byte[] onionSha256) {
        this.onionSha256 = onionSha256;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sha256 sum of the onion payload.")
    public byte[] getOnionSha256() {
        return this.onionSha256;
    }

    public void setOnionSha256(byte[] onionSha256) {
        this.onionSha256 = onionSha256;
    }

    public LnrpcFailure cltvExpiry(Long cltvExpiry) {
        this.cltvExpiry = cltvExpiry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A failure type-dependent cltv expiry value.")
    public Long getCltvExpiry() {
        return this.cltvExpiry;
    }

    public void setCltvExpiry(Long cltvExpiry) {
        this.cltvExpiry = cltvExpiry;
    }

    public LnrpcFailure flags(Long flags) {
        this.flags = flags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A failure type-dependent flags value.")
    public Long getFlags() {
        return this.flags;
    }

    public void setFlags(Long flags) {
        this.flags = flags;
    }

    public LnrpcFailure failureSourceIndex(Long failureSourceIndex) {
        this.failureSourceIndex = failureSourceIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The position in the path of the intermediate or final node that generated the failure message. Position zero is the sender node.")
    public Long getFailureSourceIndex() {
        return this.failureSourceIndex;
    }

    public void setFailureSourceIndex(Long failureSourceIndex) {
        this.failureSourceIndex = failureSourceIndex;
    }

    public LnrpcFailure height(Long height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A failure type-dependent block height.")
    public Long getHeight() {
        return this.height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcFailure lnrpcFailure = (LnrpcFailure)o;
        return Objects.equals((Object)this.code, (Object)lnrpcFailure.code) && Objects.equals(this.channelUpdate, lnrpcFailure.channelUpdate) && Objects.equals(this.htlcMsat, lnrpcFailure.htlcMsat) && Arrays.equals(this.onionSha256, lnrpcFailure.onionSha256) && Objects.equals(this.cltvExpiry, lnrpcFailure.cltvExpiry) && Objects.equals(this.flags, lnrpcFailure.flags) && Objects.equals(this.failureSourceIndex, lnrpcFailure.failureSourceIndex) && Objects.equals(this.height, lnrpcFailure.height);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.channelUpdate, this.htlcMsat, Arrays.hashCode(this.onionSha256), this.cltvExpiry, this.flags, this.failureSourceIndex, this.height});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcFailure {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    channelUpdate: ").append(this.toIndentedString(this.channelUpdate)).append("\n");
        sb.append("    htlcMsat: ").append(this.toIndentedString(this.htlcMsat)).append("\n");
        sb.append("    onionSha256: ").append(this.toIndentedString(this.onionSha256)).append("\n");
        sb.append("    cltvExpiry: ").append(this.toIndentedString(this.cltvExpiry)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    failureSourceIndex: ").append(this.toIndentedString(this.failureSourceIndex)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

