/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcChannelUpdate {
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private byte[] signature;
    public static final String SERIALIZED_NAME_CHAIN_HASH = "chain_hash";
    @SerializedName(value="chain_hash")
    private byte[] chainHash;
    public static final String SERIALIZED_NAME_CHAN_ID = "chan_id";
    @SerializedName(value="chan_id")
    private String chanId;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Long timestamp;
    public static final String SERIALIZED_NAME_MESSAGE_FLAGS = "message_flags";
    @SerializedName(value="message_flags")
    private Long messageFlags;
    public static final String SERIALIZED_NAME_CHANNEL_FLAGS = "channel_flags";
    @SerializedName(value="channel_flags")
    private Long channelFlags;
    public static final String SERIALIZED_NAME_TIME_LOCK_DELTA = "time_lock_delta";
    @SerializedName(value="time_lock_delta")
    private Long timeLockDelta;
    public static final String SERIALIZED_NAME_HTLC_MINIMUM_MSAT = "htlc_minimum_msat";
    @SerializedName(value="htlc_minimum_msat")
    private String htlcMinimumMsat;
    public static final String SERIALIZED_NAME_BASE_FEE = "base_fee";
    @SerializedName(value="base_fee")
    private Long baseFee;
    public static final String SERIALIZED_NAME_FEE_RATE = "fee_rate";
    @SerializedName(value="fee_rate")
    private Long feeRate;
    public static final String SERIALIZED_NAME_HTLC_MAXIMUM_MSAT = "htlc_maximum_msat";
    @SerializedName(value="htlc_maximum_msat")
    private String htlcMaximumMsat;
    public static final String SERIALIZED_NAME_EXTRA_OPAQUE_DATA = "extra_opaque_data";
    @SerializedName(value="extra_opaque_data")
    private byte[] extraOpaqueData;

    public LnrpcChannelUpdate signature(byte[] signature) {
        this.signature = signature;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The signature that validates the announced data and proves the ownership of node id.")
    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public LnrpcChannelUpdate chainHash(byte[] chainHash) {
        this.chainHash = chainHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target chain that this channel was opened within. This value should be the genesis hash of the target chain. Along with the short channel ID, this uniquely identifies the channel globally in a blockchain.")
    public byte[] getChainHash() {
        return this.chainHash;
    }

    public void setChainHash(byte[] chainHash) {
        this.chainHash = chainHash;
    }

    public LnrpcChannelUpdate chanId(String chanId) {
        this.chanId = chanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique description of the funding transaction.")
    public String getChanId() {
        return this.chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public LnrpcChannelUpdate timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A timestamp that allows ordering in the case of multiple announcements. We should ignore the message if timestamp is not greater than the last-received.")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public LnrpcChannelUpdate messageFlags(Long messageFlags) {
        this.messageFlags = messageFlags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bitfield that describes whether optional fields are present in this update. Currently, the least-significant bit must be set to 1 if the optional field MaxHtlc is present.")
    public Long getMessageFlags() {
        return this.messageFlags;
    }

    public void setMessageFlags(Long messageFlags) {
        this.messageFlags = messageFlags;
    }

    public LnrpcChannelUpdate channelFlags(Long channelFlags) {
        this.channelFlags = channelFlags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bitfield that describes additional meta-data concerning how the update is to be interpreted. Currently, the least-significant bit must be set to 0 if the creating node corresponds to the first node in the previously sent channel announcement and 1 otherwise. If the second bit is set, then the channel is set to be disabled.")
    public Long getChannelFlags() {
        return this.channelFlags;
    }

    public void setChannelFlags(Long channelFlags) {
        this.channelFlags = channelFlags;
    }

    public LnrpcChannelUpdate timeLockDelta(Long timeLockDelta) {
        this.timeLockDelta = timeLockDelta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum number of blocks this node requires to be added to the expiry of HTLCs. This is a security parameter determined by the node operator. This value represents the required gap between the time locks of the incoming and outgoing HTLC's set to this node.")
    public Long getTimeLockDelta() {
        return this.timeLockDelta;
    }

    public void setTimeLockDelta(Long timeLockDelta) {
        this.timeLockDelta = timeLockDelta;
    }

    public LnrpcChannelUpdate htlcMinimumMsat(String htlcMinimumMsat) {
        this.htlcMinimumMsat = htlcMinimumMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum HTLC value which will be accepted.")
    public String getHtlcMinimumMsat() {
        return this.htlcMinimumMsat;
    }

    public void setHtlcMinimumMsat(String htlcMinimumMsat) {
        this.htlcMinimumMsat = htlcMinimumMsat;
    }

    public LnrpcChannelUpdate baseFee(Long baseFee) {
        this.baseFee = baseFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The base fee that must be used for incoming HTLC's to this particular channel. This value will be tacked onto the required for a payment independent of the size of the payment.")
    public Long getBaseFee() {
        return this.baseFee;
    }

    public void setBaseFee(Long baseFee) {
        this.baseFee = baseFee;
    }

    public LnrpcChannelUpdate feeRate(Long feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee rate that will be charged per millionth of a satoshi.")
    public Long getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(Long feeRate) {
        this.feeRate = feeRate;
    }

    public LnrpcChannelUpdate htlcMaximumMsat(String htlcMaximumMsat) {
        this.htlcMaximumMsat = htlcMaximumMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum HTLC value which will be accepted.")
    public String getHtlcMaximumMsat() {
        return this.htlcMaximumMsat;
    }

    public void setHtlcMaximumMsat(String htlcMaximumMsat) {
        this.htlcMaximumMsat = htlcMaximumMsat;
    }

    public LnrpcChannelUpdate extraOpaqueData(byte[] extraOpaqueData) {
        this.extraOpaqueData = extraOpaqueData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The set of data that was appended to this message, some of which we may not actually know how to iterate or parse. By holding onto this data, we ensure that we're able to properly validate the set of signatures that cover these new fields, and ensure we're able to make upgrades to the network in a forwards compatible manner.")
    public byte[] getExtraOpaqueData() {
        return this.extraOpaqueData;
    }

    public void setExtraOpaqueData(byte[] extraOpaqueData) {
        this.extraOpaqueData = extraOpaqueData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelUpdate lnrpcChannelUpdate = (LnrpcChannelUpdate)o;
        return Arrays.equals(this.signature, lnrpcChannelUpdate.signature) && Arrays.equals(this.chainHash, lnrpcChannelUpdate.chainHash) && Objects.equals(this.chanId, lnrpcChannelUpdate.chanId) && Objects.equals(this.timestamp, lnrpcChannelUpdate.timestamp) && Objects.equals(this.messageFlags, lnrpcChannelUpdate.messageFlags) && Objects.equals(this.channelFlags, lnrpcChannelUpdate.channelFlags) && Objects.equals(this.timeLockDelta, lnrpcChannelUpdate.timeLockDelta) && Objects.equals(this.htlcMinimumMsat, lnrpcChannelUpdate.htlcMinimumMsat) && Objects.equals(this.baseFee, lnrpcChannelUpdate.baseFee) && Objects.equals(this.feeRate, lnrpcChannelUpdate.feeRate) && Objects.equals(this.htlcMaximumMsat, lnrpcChannelUpdate.htlcMaximumMsat) && Arrays.equals(this.extraOpaqueData, lnrpcChannelUpdate.extraOpaqueData);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.signature), Arrays.hashCode(this.chainHash), this.chanId, this.timestamp, this.messageFlags, this.channelFlags, this.timeLockDelta, this.htlcMinimumMsat, this.baseFee, this.feeRate, this.htlcMaximumMsat, Arrays.hashCode(this.extraOpaqueData));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelUpdate {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    chainHash: ").append(this.toIndentedString(this.chainHash)).append("\n");
        sb.append("    chanId: ").append(this.toIndentedString(this.chanId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    messageFlags: ").append(this.toIndentedString(this.messageFlags)).append("\n");
        sb.append("    channelFlags: ").append(this.toIndentedString(this.channelFlags)).append("\n");
        sb.append("    timeLockDelta: ").append(this.toIndentedString(this.timeLockDelta)).append("\n");
        sb.append("    htlcMinimumMsat: ").append(this.toIndentedString(this.htlcMinimumMsat)).append("\n");
        sb.append("    baseFee: ").append(this.toIndentedString(this.baseFee)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("    htlcMaximumMsat: ").append(this.toIndentedString(this.htlcMaximumMsat)).append("\n");
        sb.append("    extraOpaqueData: ").append(this.toIndentedString(this.extraOpaqueData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

