/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcChannelPoint {
    public static final String SERIALIZED_NAME_FUNDING_TXID_BYTES = "funding_txid_bytes";
    @SerializedName(value="funding_txid_bytes")
    private byte[] fundingTxidBytes;
    public static final String SERIALIZED_NAME_FUNDING_TXID_STR = "funding_txid_str";
    @SerializedName(value="funding_txid_str")
    private String fundingTxidStr;
    public static final String SERIALIZED_NAME_OUTPUT_INDEX = "output_index";
    @SerializedName(value="output_index")
    private Long outputIndex;

    public LnrpcChannelPoint fundingTxidBytes(byte[] fundingTxidBytes) {
        this.fundingTxidBytes = fundingTxidBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Txid of the funding transaction. When using REST, this field must be encoded as base64.")
    public byte[] getFundingTxidBytes() {
        return this.fundingTxidBytes;
    }

    public void setFundingTxidBytes(byte[] fundingTxidBytes) {
        this.fundingTxidBytes = fundingTxidBytes;
    }

    public LnrpcChannelPoint fundingTxidStr(String fundingTxidStr) {
        this.fundingTxidStr = fundingTxidStr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hex-encoded string representing the byte-reversed hash of the funding transaction.")
    public String getFundingTxidStr() {
        return this.fundingTxidStr;
    }

    public void setFundingTxidStr(String fundingTxidStr) {
        this.fundingTxidStr = fundingTxidStr;
    }

    public LnrpcChannelPoint outputIndex(Long outputIndex) {
        this.outputIndex = outputIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputIndex(Long outputIndex) {
        this.outputIndex = outputIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelPoint lnrpcChannelPoint = (LnrpcChannelPoint)o;
        return Arrays.equals(this.fundingTxidBytes, lnrpcChannelPoint.fundingTxidBytes) && Objects.equals(this.fundingTxidStr, lnrpcChannelPoint.fundingTxidStr) && Objects.equals(this.outputIndex, lnrpcChannelPoint.outputIndex);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.fundingTxidBytes), this.fundingTxidStr, this.outputIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelPoint {\n");
        sb.append("    fundingTxidBytes: ").append(this.toIndentedString(this.fundingTxidBytes)).append("\n");
        sb.append("    fundingTxidStr: ").append(this.toIndentedString(this.fundingTxidStr)).append("\n");
        sb.append("    outputIndex: ").append(this.toIndentedString(this.outputIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

