/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcChannelEdge;
import net.osslabz.lnd.dto.LnrpcLightningNode;

@ApiModel(description="Returns a new instance of the directed channel graph.")
public class LnrpcChannelGraph {
    public static final String SERIALIZED_NAME_NODES = "nodes";
    @SerializedName(value="nodes")
    private List<LnrpcLightningNode> nodes = null;
    public static final String SERIALIZED_NAME_EDGES = "edges";
    @SerializedName(value="edges")
    private List<LnrpcChannelEdge> edges = null;

    public LnrpcChannelGraph nodes(List<LnrpcLightningNode> nodes) {
        this.nodes = nodes;
        return this;
    }

    public LnrpcChannelGraph addNodesItem(LnrpcLightningNode nodesItem) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<LnrpcLightningNode>();
        }
        this.nodes.add(nodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<LnrpcLightningNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<LnrpcLightningNode> nodes) {
        this.nodes = nodes;
    }

    public LnrpcChannelGraph edges(List<LnrpcChannelEdge> edges) {
        this.edges = edges;
        return this;
    }

    public LnrpcChannelGraph addEdgesItem(LnrpcChannelEdge edgesItem) {
        if (this.edges == null) {
            this.edges = new ArrayList<LnrpcChannelEdge>();
        }
        this.edges.add(edgesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<LnrpcChannelEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<LnrpcChannelEdge> edges) {
        this.edges = edges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelGraph lnrpcChannelGraph = (LnrpcChannelGraph)o;
        return Objects.equals(this.nodes, lnrpcChannelGraph.nodes) && Objects.equals(this.edges, lnrpcChannelGraph.edges);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.edges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelGraph {\n");
        sb.append("    nodes: ").append(this.toIndentedString(this.nodes)).append("\n");
        sb.append("    edges: ").append(this.toIndentedString(this.edges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

