/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LnrpcChannelFeeReport {
    public static final String SERIALIZED_NAME_CHAN_ID = "chan_id";
    @SerializedName(value="chan_id")
    private String chanId;
    public static final String SERIALIZED_NAME_CHANNEL_POINT = "channel_point";
    @SerializedName(value="channel_point")
    private String channelPoint;
    public static final String SERIALIZED_NAME_BASE_FEE_MSAT = "base_fee_msat";
    @SerializedName(value="base_fee_msat")
    private String baseFeeMsat;
    public static final String SERIALIZED_NAME_FEE_PER_MIL = "fee_per_mil";
    @SerializedName(value="fee_per_mil")
    private String feePerMil;
    public static final String SERIALIZED_NAME_FEE_RATE = "fee_rate";
    @SerializedName(value="fee_rate")
    private Double feeRate;

    public LnrpcChannelFeeReport chanId(String chanId) {
        this.chanId = chanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The short channel id that this fee report belongs to.")
    public String getChanId() {
        return this.chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public LnrpcChannelFeeReport channelPoint(String channelPoint) {
        this.channelPoint = channelPoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The channel that this fee report belongs to.")
    public String getChannelPoint() {
        return this.channelPoint;
    }

    public void setChannelPoint(String channelPoint) {
        this.channelPoint = channelPoint;
    }

    public LnrpcChannelFeeReport baseFeeMsat(String baseFeeMsat) {
        this.baseFeeMsat = baseFeeMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The base fee charged regardless of the number of milli-satoshis sent.")
    public String getBaseFeeMsat() {
        return this.baseFeeMsat;
    }

    public void setBaseFeeMsat(String baseFeeMsat) {
        this.baseFeeMsat = baseFeeMsat;
    }

    public LnrpcChannelFeeReport feePerMil(String feePerMil) {
        this.feePerMil = feePerMil;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount charged per milli-satoshis transferred expressed in millionths of a satoshi.")
    public String getFeePerMil() {
        return this.feePerMil;
    }

    public void setFeePerMil(String feePerMil) {
        this.feePerMil = feePerMil;
    }

    public LnrpcChannelFeeReport feeRate(Double feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The effective fee rate in milli-satoshis. Computed by dividing the fee_per_mil value by 1 million.")
    public Double getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(Double feeRate) {
        this.feeRate = feeRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelFeeReport lnrpcChannelFeeReport = (LnrpcChannelFeeReport)o;
        return Objects.equals(this.chanId, lnrpcChannelFeeReport.chanId) && Objects.equals(this.channelPoint, lnrpcChannelFeeReport.channelPoint) && Objects.equals(this.baseFeeMsat, lnrpcChannelFeeReport.baseFeeMsat) && Objects.equals(this.feePerMil, lnrpcChannelFeeReport.feePerMil) && Objects.equals(this.feeRate, lnrpcChannelFeeReport.feeRate);
    }

    public int hashCode() {
        return Objects.hash(this.chanId, this.channelPoint, this.baseFeeMsat, this.feePerMil, this.feeRate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelFeeReport {\n");
        sb.append("    chanId: ").append(this.toIndentedString(this.chanId)).append("\n");
        sb.append("    channelPoint: ").append(this.toIndentedString(this.channelPoint)).append("\n");
        sb.append("    baseFeeMsat: ").append(this.toIndentedString(this.baseFeeMsat)).append("\n");
        sb.append("    feePerMil: ").append(this.toIndentedString(this.feePerMil)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

