/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcRoutingPolicy;

@ApiModel(description="A fully authenticated channel along with all its unique attributes. Once an authenticated channel announcement has been processed on the network, then an instance of ChannelEdgeInfo encapsulating the channels attributes is stored. The other portions relevant to routing policy of a channel are stored within a ChannelEdgePolicy for each direction of the channel.")
public class LnrpcChannelEdge {
    public static final String SERIALIZED_NAME_CHANNEL_ID = "channel_id";
    @SerializedName(value="channel_id")
    private String channelId;
    public static final String SERIALIZED_NAME_CHAN_POINT = "chan_point";
    @SerializedName(value="chan_point")
    private String chanPoint;
    public static final String SERIALIZED_NAME_LAST_UPDATE = "last_update";
    @SerializedName(value="last_update")
    private Long lastUpdate;
    public static final String SERIALIZED_NAME_NODE1_PUB = "node1_pub";
    @SerializedName(value="node1_pub")
    private String node1Pub;
    public static final String SERIALIZED_NAME_NODE2_PUB = "node2_pub";
    @SerializedName(value="node2_pub")
    private String node2Pub;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private String capacity;
    public static final String SERIALIZED_NAME_NODE1_POLICY = "node1_policy";
    @SerializedName(value="node1_policy")
    private LnrpcRoutingPolicy node1Policy;
    public static final String SERIALIZED_NAME_NODE2_POLICY = "node2_policy";
    @SerializedName(value="node2_policy")
    private LnrpcRoutingPolicy node2Policy;
    public static final String SERIALIZED_NAME_CUSTOM_RECORDS = "custom_records";
    @SerializedName(value="custom_records")
    private Map<String, byte[]> customRecords = null;

    public LnrpcChannelEdge channelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique channel ID for the channel. The first 3 bytes are the block height, the next 3 the index within the block, and the last 2 bytes are the output index for the channel.")
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public LnrpcChannelEdge chanPoint(String chanPoint) {
        this.chanPoint = chanPoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getChanPoint() {
        return this.chanPoint;
    }

    public void setChanPoint(String chanPoint) {
        this.chanPoint = chanPoint;
    }

    public LnrpcChannelEdge lastUpdate(Long lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public LnrpcChannelEdge node1Pub(String node1Pub) {
        this.node1Pub = node1Pub;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getNode1Pub() {
        return this.node1Pub;
    }

    public void setNode1Pub(String node1Pub) {
        this.node1Pub = node1Pub;
    }

    public LnrpcChannelEdge node2Pub(String node2Pub) {
        this.node2Pub = node2Pub;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getNode2Pub() {
        return this.node2Pub;
    }

    public void setNode2Pub(String node2Pub) {
        this.node2Pub = node2Pub;
    }

    public LnrpcChannelEdge capacity(String capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public LnrpcChannelEdge node1Policy(LnrpcRoutingPolicy node1Policy) {
        this.node1Policy = node1Policy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcRoutingPolicy getNode1Policy() {
        return this.node1Policy;
    }

    public void setNode1Policy(LnrpcRoutingPolicy node1Policy) {
        this.node1Policy = node1Policy;
    }

    public LnrpcChannelEdge node2Policy(LnrpcRoutingPolicy node2Policy) {
        this.node2Policy = node2Policy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcRoutingPolicy getNode2Policy() {
        return this.node2Policy;
    }

    public void setNode2Policy(LnrpcRoutingPolicy node2Policy) {
        this.node2Policy = node2Policy;
    }

    public LnrpcChannelEdge customRecords(Map<String, byte[]> customRecords) {
        this.customRecords = customRecords;
        return this;
    }

    public LnrpcChannelEdge putCustomRecordsItem(String key, byte[] customRecordsItem) {
        if (this.customRecords == null) {
            this.customRecords = new HashMap<String, byte[]>();
        }
        this.customRecords.put(key, customRecordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom channel announcement tlv records.")
    public Map<String, byte[]> getCustomRecords() {
        return this.customRecords;
    }

    public void setCustomRecords(Map<String, byte[]> customRecords) {
        this.customRecords = customRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelEdge lnrpcChannelEdge = (LnrpcChannelEdge)o;
        return Objects.equals(this.channelId, lnrpcChannelEdge.channelId) && Objects.equals(this.chanPoint, lnrpcChannelEdge.chanPoint) && Objects.equals(this.lastUpdate, lnrpcChannelEdge.lastUpdate) && Objects.equals(this.node1Pub, lnrpcChannelEdge.node1Pub) && Objects.equals(this.node2Pub, lnrpcChannelEdge.node2Pub) && Objects.equals(this.capacity, lnrpcChannelEdge.capacity) && Objects.equals(this.node1Policy, lnrpcChannelEdge.node1Policy) && Objects.equals(this.node2Policy, lnrpcChannelEdge.node2Policy) && Objects.equals(this.customRecords, lnrpcChannelEdge.customRecords);
    }

    public int hashCode() {
        return Objects.hash(this.channelId, this.chanPoint, this.lastUpdate, this.node1Pub, this.node2Pub, this.capacity, this.node1Policy, this.node2Policy, this.customRecords);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelEdge {\n");
        sb.append("    channelId: ").append(this.toIndentedString(this.channelId)).append("\n");
        sb.append("    chanPoint: ").append(this.toIndentedString(this.chanPoint)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    node1Pub: ").append(this.toIndentedString(this.node1Pub)).append("\n");
        sb.append("    node2Pub: ").append(this.toIndentedString(this.node2Pub)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    node1Policy: ").append(this.toIndentedString(this.node1Policy)).append("\n");
        sb.append("    node2Policy: ").append(this.toIndentedString(this.node2Policy)).append("\n");
        sb.append("    customRecords: ").append(this.toIndentedString(this.customRecords)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

