/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LnrpcChannelConstraints {
    public static final String SERIALIZED_NAME_CSV_DELAY = "csv_delay";
    @SerializedName(value="csv_delay")
    private Long csvDelay;
    public static final String SERIALIZED_NAME_CHAN_RESERVE_SAT = "chan_reserve_sat";
    @SerializedName(value="chan_reserve_sat")
    private String chanReserveSat;
    public static final String SERIALIZED_NAME_DUST_LIMIT_SAT = "dust_limit_sat";
    @SerializedName(value="dust_limit_sat")
    private String dustLimitSat;
    public static final String SERIALIZED_NAME_MAX_PENDING_AMT_MSAT = "max_pending_amt_msat";
    @SerializedName(value="max_pending_amt_msat")
    private String maxPendingAmtMsat;
    public static final String SERIALIZED_NAME_MIN_HTLC_MSAT = "min_htlc_msat";
    @SerializedName(value="min_htlc_msat")
    private String minHtlcMsat;
    public static final String SERIALIZED_NAME_MAX_ACCEPTED_HTLCS = "max_accepted_htlcs";
    @SerializedName(value="max_accepted_htlcs")
    private Long maxAcceptedHtlcs;

    public LnrpcChannelConstraints csvDelay(Long csvDelay) {
        this.csvDelay = csvDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The CSV delay expressed in relative blocks. If the channel is force closed, we will need to wait for this many blocks before we can regain our funds.")
    public Long getCsvDelay() {
        return this.csvDelay;
    }

    public void setCsvDelay(Long csvDelay) {
        this.csvDelay = csvDelay;
    }

    public LnrpcChannelConstraints chanReserveSat(String chanReserveSat) {
        this.chanReserveSat = chanReserveSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum satoshis this node is required to reserve in its balance.")
    public String getChanReserveSat() {
        return this.chanReserveSat;
    }

    public void setChanReserveSat(String chanReserveSat) {
        this.chanReserveSat = chanReserveSat;
    }

    public LnrpcChannelConstraints dustLimitSat(String dustLimitSat) {
        this.dustLimitSat = dustLimitSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The dust limit (in satoshis) of the initiator's commitment tx.")
    public String getDustLimitSat() {
        return this.dustLimitSat;
    }

    public void setDustLimitSat(String dustLimitSat) {
        this.dustLimitSat = dustLimitSat;
    }

    public LnrpcChannelConstraints maxPendingAmtMsat(String maxPendingAmtMsat) {
        this.maxPendingAmtMsat = maxPendingAmtMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum amount of coins in millisatoshis that can be pending in this channel.")
    public String getMaxPendingAmtMsat() {
        return this.maxPendingAmtMsat;
    }

    public void setMaxPendingAmtMsat(String maxPendingAmtMsat) {
        this.maxPendingAmtMsat = maxPendingAmtMsat;
    }

    public LnrpcChannelConstraints minHtlcMsat(String minHtlcMsat) {
        this.minHtlcMsat = minHtlcMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The smallest HTLC in millisatoshis that the initiator will accept.")
    public String getMinHtlcMsat() {
        return this.minHtlcMsat;
    }

    public void setMinHtlcMsat(String minHtlcMsat) {
        this.minHtlcMsat = minHtlcMsat;
    }

    public LnrpcChannelConstraints maxAcceptedHtlcs(Long maxAcceptedHtlcs) {
        this.maxAcceptedHtlcs = maxAcceptedHtlcs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of incoming HTLC's that the initiator will accept.")
    public Long getMaxAcceptedHtlcs() {
        return this.maxAcceptedHtlcs;
    }

    public void setMaxAcceptedHtlcs(Long maxAcceptedHtlcs) {
        this.maxAcceptedHtlcs = maxAcceptedHtlcs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelConstraints lnrpcChannelConstraints = (LnrpcChannelConstraints)o;
        return Objects.equals(this.csvDelay, lnrpcChannelConstraints.csvDelay) && Objects.equals(this.chanReserveSat, lnrpcChannelConstraints.chanReserveSat) && Objects.equals(this.dustLimitSat, lnrpcChannelConstraints.dustLimitSat) && Objects.equals(this.maxPendingAmtMsat, lnrpcChannelConstraints.maxPendingAmtMsat) && Objects.equals(this.minHtlcMsat, lnrpcChannelConstraints.minHtlcMsat) && Objects.equals(this.maxAcceptedHtlcs, lnrpcChannelConstraints.maxAcceptedHtlcs);
    }

    public int hashCode() {
        return Objects.hash(this.csvDelay, this.chanReserveSat, this.dustLimitSat, this.maxPendingAmtMsat, this.minHtlcMsat, this.maxAcceptedHtlcs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelConstraints {\n");
        sb.append("    csvDelay: ").append(this.toIndentedString(this.csvDelay)).append("\n");
        sb.append("    chanReserveSat: ").append(this.toIndentedString(this.chanReserveSat)).append("\n");
        sb.append("    dustLimitSat: ").append(this.toIndentedString(this.dustLimitSat)).append("\n");
        sb.append("    maxPendingAmtMsat: ").append(this.toIndentedString(this.maxPendingAmtMsat)).append("\n");
        sb.append("    minHtlcMsat: ").append(this.toIndentedString(this.minHtlcMsat)).append("\n");
        sb.append("    maxAcceptedHtlcs: ").append(this.toIndentedString(this.maxAcceptedHtlcs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

