/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.ChannelCloseSummaryClosureType;
import net.osslabz.lnd.dto.LnrpcInitiator;
import net.osslabz.lnd.dto.LnrpcResolution;

public class LnrpcChannelCloseSummary {
    public static final String SERIALIZED_NAME_CHANNEL_POINT = "channel_point";
    @SerializedName(value="channel_point")
    private String channelPoint;
    public static final String SERIALIZED_NAME_CHAN_ID = "chan_id";
    @SerializedName(value="chan_id")
    private String chanId;
    public static final String SERIALIZED_NAME_CHAIN_HASH = "chain_hash";
    @SerializedName(value="chain_hash")
    private String chainHash;
    public static final String SERIALIZED_NAME_CLOSING_TX_HASH = "closing_tx_hash";
    @SerializedName(value="closing_tx_hash")
    private String closingTxHash;
    public static final String SERIALIZED_NAME_REMOTE_PUBKEY = "remote_pubkey";
    @SerializedName(value="remote_pubkey")
    private String remotePubkey;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private String capacity;
    public static final String SERIALIZED_NAME_CLOSE_HEIGHT = "close_height";
    @SerializedName(value="close_height")
    private Long closeHeight;
    public static final String SERIALIZED_NAME_SETTLED_BALANCE = "settled_balance";
    @SerializedName(value="settled_balance")
    private String settledBalance;
    public static final String SERIALIZED_NAME_TIME_LOCKED_BALANCE = "time_locked_balance";
    @SerializedName(value="time_locked_balance")
    private String timeLockedBalance;
    public static final String SERIALIZED_NAME_CLOSE_TYPE = "close_type";
    @SerializedName(value="close_type")
    private ChannelCloseSummaryClosureType closeType = ChannelCloseSummaryClosureType.COOPERATIVE_CLOSE;
    public static final String SERIALIZED_NAME_OPEN_INITIATOR = "open_initiator";
    @SerializedName(value="open_initiator")
    private LnrpcInitiator openInitiator = LnrpcInitiator.UNKNOWN;
    public static final String SERIALIZED_NAME_CLOSE_INITIATOR = "close_initiator";
    @SerializedName(value="close_initiator")
    private LnrpcInitiator closeInitiator = LnrpcInitiator.UNKNOWN;
    public static final String SERIALIZED_NAME_RESOLUTIONS = "resolutions";
    @SerializedName(value="resolutions")
    private List<LnrpcResolution> resolutions = null;
    public static final String SERIALIZED_NAME_ALIAS_SCIDS = "alias_scids";
    @SerializedName(value="alias_scids")
    private List<String> aliasScids = null;
    public static final String SERIALIZED_NAME_ZERO_CONF_CONFIRMED_SCID = "zero_conf_confirmed_scid";
    @SerializedName(value="zero_conf_confirmed_scid")
    private String zeroConfConfirmedScid;

    public LnrpcChannelCloseSummary channelPoint(String channelPoint) {
        this.channelPoint = channelPoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The outpoint (txid:index) of the funding transaction.")
    public String getChannelPoint() {
        return this.channelPoint;
    }

    public void setChannelPoint(String channelPoint) {
        this.channelPoint = channelPoint;
    }

    public LnrpcChannelCloseSummary chanId(String chanId) {
        this.chanId = chanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique channel ID for the channel.")
    public String getChanId() {
        return this.chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public LnrpcChannelCloseSummary chainHash(String chainHash) {
        this.chainHash = chainHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hash of the genesis block that this channel resides within.")
    public String getChainHash() {
        return this.chainHash;
    }

    public void setChainHash(String chainHash) {
        this.chainHash = chainHash;
    }

    public LnrpcChannelCloseSummary closingTxHash(String closingTxHash) {
        this.closingTxHash = closingTxHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The txid of the transaction which ultimately closed this channel.")
    public String getClosingTxHash() {
        return this.closingTxHash;
    }

    public void setClosingTxHash(String closingTxHash) {
        this.closingTxHash = closingTxHash;
    }

    public LnrpcChannelCloseSummary remotePubkey(String remotePubkey) {
        this.remotePubkey = remotePubkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Public key of the remote peer that we formerly had a channel with.")
    public String getRemotePubkey() {
        return this.remotePubkey;
    }

    public void setRemotePubkey(String remotePubkey) {
        this.remotePubkey = remotePubkey;
    }

    public LnrpcChannelCloseSummary capacity(String capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total capacity of the channel.")
    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public LnrpcChannelCloseSummary closeHeight(Long closeHeight) {
        this.closeHeight = closeHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height at which the funding transaction was spent.")
    public Long getCloseHeight() {
        return this.closeHeight;
    }

    public void setCloseHeight(Long closeHeight) {
        this.closeHeight = closeHeight;
    }

    public LnrpcChannelCloseSummary settledBalance(String settledBalance) {
        this.settledBalance = settledBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getSettledBalance() {
        return this.settledBalance;
    }

    public void setSettledBalance(String settledBalance) {
        this.settledBalance = settledBalance;
    }

    public LnrpcChannelCloseSummary timeLockedBalance(String timeLockedBalance) {
        this.timeLockedBalance = timeLockedBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getTimeLockedBalance() {
        return this.timeLockedBalance;
    }

    public void setTimeLockedBalance(String timeLockedBalance) {
        this.timeLockedBalance = timeLockedBalance;
    }

    public LnrpcChannelCloseSummary closeType(ChannelCloseSummaryClosureType closeType) {
        this.closeType = closeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ChannelCloseSummaryClosureType getCloseType() {
        return this.closeType;
    }

    public void setCloseType(ChannelCloseSummaryClosureType closeType) {
        this.closeType = closeType;
    }

    public LnrpcChannelCloseSummary openInitiator(LnrpcInitiator openInitiator) {
        this.openInitiator = openInitiator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcInitiator getOpenInitiator() {
        return this.openInitiator;
    }

    public void setOpenInitiator(LnrpcInitiator openInitiator) {
        this.openInitiator = openInitiator;
    }

    public LnrpcChannelCloseSummary closeInitiator(LnrpcInitiator closeInitiator) {
        this.closeInitiator = closeInitiator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcInitiator getCloseInitiator() {
        return this.closeInitiator;
    }

    public void setCloseInitiator(LnrpcInitiator closeInitiator) {
        this.closeInitiator = closeInitiator;
    }

    public LnrpcChannelCloseSummary resolutions(List<LnrpcResolution> resolutions) {
        this.resolutions = resolutions;
        return this;
    }

    public LnrpcChannelCloseSummary addResolutionsItem(LnrpcResolution resolutionsItem) {
        if (this.resolutions == null) {
            this.resolutions = new ArrayList<LnrpcResolution>();
        }
        this.resolutions.add(resolutionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<LnrpcResolution> getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(List<LnrpcResolution> resolutions) {
        this.resolutions = resolutions;
    }

    public LnrpcChannelCloseSummary aliasScids(List<String> aliasScids) {
        this.aliasScids = aliasScids;
        return this;
    }

    public LnrpcChannelCloseSummary addAliasScidsItem(String aliasScidsItem) {
        if (this.aliasScids == null) {
            this.aliasScids = new ArrayList<String>();
        }
        this.aliasScids.add(aliasScidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This lists out the set of alias short channel ids that existed for the closed channel. This may be empty.")
    public List<String> getAliasScids() {
        return this.aliasScids;
    }

    public void setAliasScids(List<String> aliasScids) {
        this.aliasScids = aliasScids;
    }

    public LnrpcChannelCloseSummary zeroConfConfirmedScid(String zeroConfConfirmedScid) {
        this.zeroConfConfirmedScid = zeroConfConfirmedScid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The confirmed SCID for a zero-conf channel.")
    public String getZeroConfConfirmedScid() {
        return this.zeroConfConfirmedScid;
    }

    public void setZeroConfConfirmedScid(String zeroConfConfirmedScid) {
        this.zeroConfConfirmedScid = zeroConfConfirmedScid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelCloseSummary lnrpcChannelCloseSummary = (LnrpcChannelCloseSummary)o;
        return Objects.equals(this.channelPoint, lnrpcChannelCloseSummary.channelPoint) && Objects.equals(this.chanId, lnrpcChannelCloseSummary.chanId) && Objects.equals(this.chainHash, lnrpcChannelCloseSummary.chainHash) && Objects.equals(this.closingTxHash, lnrpcChannelCloseSummary.closingTxHash) && Objects.equals(this.remotePubkey, lnrpcChannelCloseSummary.remotePubkey) && Objects.equals(this.capacity, lnrpcChannelCloseSummary.capacity) && Objects.equals(this.closeHeight, lnrpcChannelCloseSummary.closeHeight) && Objects.equals(this.settledBalance, lnrpcChannelCloseSummary.settledBalance) && Objects.equals(this.timeLockedBalance, lnrpcChannelCloseSummary.timeLockedBalance) && Objects.equals((Object)this.closeType, (Object)lnrpcChannelCloseSummary.closeType) && Objects.equals((Object)this.openInitiator, (Object)lnrpcChannelCloseSummary.openInitiator) && Objects.equals((Object)this.closeInitiator, (Object)lnrpcChannelCloseSummary.closeInitiator) && Objects.equals(this.resolutions, lnrpcChannelCloseSummary.resolutions) && Objects.equals(this.aliasScids, lnrpcChannelCloseSummary.aliasScids) && Objects.equals(this.zeroConfConfirmedScid, lnrpcChannelCloseSummary.zeroConfConfirmedScid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channelPoint, this.chanId, this.chainHash, this.closingTxHash, this.remotePubkey, this.capacity, this.closeHeight, this.settledBalance, this.timeLockedBalance, this.closeType, this.openInitiator, this.closeInitiator, this.resolutions, this.aliasScids, this.zeroConfConfirmedScid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelCloseSummary {\n");
        sb.append("    channelPoint: ").append(this.toIndentedString(this.channelPoint)).append("\n");
        sb.append("    chanId: ").append(this.toIndentedString(this.chanId)).append("\n");
        sb.append("    chainHash: ").append(this.toIndentedString(this.chainHash)).append("\n");
        sb.append("    closingTxHash: ").append(this.toIndentedString(this.closingTxHash)).append("\n");
        sb.append("    remotePubkey: ").append(this.toIndentedString(this.remotePubkey)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    closeHeight: ").append(this.toIndentedString(this.closeHeight)).append("\n");
        sb.append("    settledBalance: ").append(this.toIndentedString(this.settledBalance)).append("\n");
        sb.append("    timeLockedBalance: ").append(this.toIndentedString(this.timeLockedBalance)).append("\n");
        sb.append("    closeType: ").append(this.toIndentedString((Object)this.closeType)).append("\n");
        sb.append("    openInitiator: ").append(this.toIndentedString((Object)this.openInitiator)).append("\n");
        sb.append("    closeInitiator: ").append(this.toIndentedString((Object)this.closeInitiator)).append("\n");
        sb.append("    resolutions: ").append(this.toIndentedString(this.resolutions)).append("\n");
        sb.append("    aliasScids: ").append(this.toIndentedString(this.aliasScids)).append("\n");
        sb.append("    zeroConfConfirmedScid: ").append(this.toIndentedString(this.zeroConfConfirmedScid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

