/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcChannelAcceptResponse {
    public static final String SERIALIZED_NAME_ACCEPT = "accept";
    @SerializedName(value="accept")
    private Boolean accept;
    public static final String SERIALIZED_NAME_PENDING_CHAN_ID = "pending_chan_id";
    @SerializedName(value="pending_chan_id")
    private byte[] pendingChanId;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private String error;
    public static final String SERIALIZED_NAME_UPFRONT_SHUTDOWN = "upfront_shutdown";
    @SerializedName(value="upfront_shutdown")
    private String upfrontShutdown;
    public static final String SERIALIZED_NAME_CSV_DELAY = "csv_delay";
    @SerializedName(value="csv_delay")
    private Long csvDelay;
    public static final String SERIALIZED_NAME_RESERVE_SAT = "reserve_sat";
    @SerializedName(value="reserve_sat")
    private String reserveSat;
    public static final String SERIALIZED_NAME_IN_FLIGHT_MAX_MSAT = "in_flight_max_msat";
    @SerializedName(value="in_flight_max_msat")
    private String inFlightMaxMsat;
    public static final String SERIALIZED_NAME_MAX_HTLC_COUNT = "max_htlc_count";
    @SerializedName(value="max_htlc_count")
    private Long maxHtlcCount;
    public static final String SERIALIZED_NAME_MIN_HTLC_IN = "min_htlc_in";
    @SerializedName(value="min_htlc_in")
    private String minHtlcIn;
    public static final String SERIALIZED_NAME_MIN_ACCEPT_DEPTH = "min_accept_depth";
    @SerializedName(value="min_accept_depth")
    private Long minAcceptDepth;
    public static final String SERIALIZED_NAME_ZERO_CONF = "zero_conf";
    @SerializedName(value="zero_conf")
    private Boolean zeroConf;

    public LnrpcChannelAcceptResponse accept(Boolean accept) {
        this.accept = accept;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the client accepts the channel.")
    public Boolean getAccept() {
        return this.accept;
    }

    public void setAccept(Boolean accept) {
        this.accept = accept;
    }

    public LnrpcChannelAcceptResponse pendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pending channel id to which this response applies.")
    public byte[] getPendingChanId() {
        return this.pendingChanId;
    }

    public void setPendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
    }

    public LnrpcChannelAcceptResponse error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional error to send the initiating party to indicate why the channel was rejected. This field *should not* contain sensitive information, it will be sent to the initiating party. This field should only be set if accept is false, the channel will be rejected if an error is set with accept=true because the meaning of this response is ambiguous. Limited to 500 characters.")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public LnrpcChannelAcceptResponse upfrontShutdown(String upfrontShutdown) {
        this.upfrontShutdown = upfrontShutdown;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The upfront shutdown address to use if the initiating peer supports option upfront shutdown script (see ListPeers for the features supported). Note that the channel open will fail if this value is set for a peer that does not support this feature bit.")
    public String getUpfrontShutdown() {
        return this.upfrontShutdown;
    }

    public void setUpfrontShutdown(String upfrontShutdown) {
        this.upfrontShutdown = upfrontShutdown;
    }

    public LnrpcChannelAcceptResponse csvDelay(Long csvDelay) {
        this.csvDelay = csvDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The csv delay (in blocks) that we require for the remote party.")
    public Long getCsvDelay() {
        return this.csvDelay;
    }

    public void setCsvDelay(Long csvDelay) {
        this.csvDelay = csvDelay;
    }

    public LnrpcChannelAcceptResponse reserveSat(String reserveSat) {
        this.reserveSat = reserveSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reserve amount in satoshis that we require the remote peer to adhere to. We require that the remote peer always have some reserve amount allocated to them so that there is always a disincentive to broadcast old state (if they hold 0 sats on their side of the channel, there is nothing to lose).")
    public String getReserveSat() {
        return this.reserveSat;
    }

    public void setReserveSat(String reserveSat) {
        this.reserveSat = reserveSat;
    }

    public LnrpcChannelAcceptResponse inFlightMaxMsat(String inFlightMaxMsat) {
        this.inFlightMaxMsat = inFlightMaxMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum amount of funds in millisatoshis that we allow the remote peer to have in outstanding htlcs.")
    public String getInFlightMaxMsat() {
        return this.inFlightMaxMsat;
    }

    public void setInFlightMaxMsat(String inFlightMaxMsat) {
        this.inFlightMaxMsat = inFlightMaxMsat;
    }

    public LnrpcChannelAcceptResponse maxHtlcCount(Long maxHtlcCount) {
        this.maxHtlcCount = maxHtlcCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of htlcs that the remote peer can offer us.")
    public Long getMaxHtlcCount() {
        return this.maxHtlcCount;
    }

    public void setMaxHtlcCount(Long maxHtlcCount) {
        this.maxHtlcCount = maxHtlcCount;
    }

    public LnrpcChannelAcceptResponse minHtlcIn(String minHtlcIn) {
        this.minHtlcIn = minHtlcIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum value in millisatoshis for incoming htlcs on the channel.")
    public String getMinHtlcIn() {
        return this.minHtlcIn;
    }

    public void setMinHtlcIn(String minHtlcIn) {
        this.minHtlcIn = minHtlcIn;
    }

    public LnrpcChannelAcceptResponse minAcceptDepth(Long minAcceptDepth) {
        this.minAcceptDepth = minAcceptDepth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of confirmations we require before we consider the channel open.")
    public Long getMinAcceptDepth() {
        return this.minAcceptDepth;
    }

    public void setMinAcceptDepth(Long minAcceptDepth) {
        this.minAcceptDepth = minAcceptDepth;
    }

    public LnrpcChannelAcceptResponse zeroConf(Boolean zeroConf) {
        this.zeroConf = zeroConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the responder wants this to be a zero-conf channel. This will fail if either side does not have the scid-alias feature bit set. The minimum depth field must be zero if this is true.")
    public Boolean getZeroConf() {
        return this.zeroConf;
    }

    public void setZeroConf(Boolean zeroConf) {
        this.zeroConf = zeroConf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelAcceptResponse lnrpcChannelAcceptResponse = (LnrpcChannelAcceptResponse)o;
        return Objects.equals(this.accept, lnrpcChannelAcceptResponse.accept) && Arrays.equals(this.pendingChanId, lnrpcChannelAcceptResponse.pendingChanId) && Objects.equals(this.error, lnrpcChannelAcceptResponse.error) && Objects.equals(this.upfrontShutdown, lnrpcChannelAcceptResponse.upfrontShutdown) && Objects.equals(this.csvDelay, lnrpcChannelAcceptResponse.csvDelay) && Objects.equals(this.reserveSat, lnrpcChannelAcceptResponse.reserveSat) && Objects.equals(this.inFlightMaxMsat, lnrpcChannelAcceptResponse.inFlightMaxMsat) && Objects.equals(this.maxHtlcCount, lnrpcChannelAcceptResponse.maxHtlcCount) && Objects.equals(this.minHtlcIn, lnrpcChannelAcceptResponse.minHtlcIn) && Objects.equals(this.minAcceptDepth, lnrpcChannelAcceptResponse.minAcceptDepth) && Objects.equals(this.zeroConf, lnrpcChannelAcceptResponse.zeroConf);
    }

    public int hashCode() {
        return Objects.hash(this.accept, Arrays.hashCode(this.pendingChanId), this.error, this.upfrontShutdown, this.csvDelay, this.reserveSat, this.inFlightMaxMsat, this.maxHtlcCount, this.minHtlcIn, this.minAcceptDepth, this.zeroConf);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelAcceptResponse {\n");
        sb.append("    accept: ").append(this.toIndentedString(this.accept)).append("\n");
        sb.append("    pendingChanId: ").append(this.toIndentedString(this.pendingChanId)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    upfrontShutdown: ").append(this.toIndentedString(this.upfrontShutdown)).append("\n");
        sb.append("    csvDelay: ").append(this.toIndentedString(this.csvDelay)).append("\n");
        sb.append("    reserveSat: ").append(this.toIndentedString(this.reserveSat)).append("\n");
        sb.append("    inFlightMaxMsat: ").append(this.toIndentedString(this.inFlightMaxMsat)).append("\n");
        sb.append("    maxHtlcCount: ").append(this.toIndentedString(this.maxHtlcCount)).append("\n");
        sb.append("    minHtlcIn: ").append(this.toIndentedString(this.minHtlcIn)).append("\n");
        sb.append("    minAcceptDepth: ").append(this.toIndentedString(this.minAcceptDepth)).append("\n");
        sb.append("    zeroConf: ").append(this.toIndentedString(this.zeroConf)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

