/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcCommitmentType;

public class LnrpcChannelAcceptRequest {
    public static final String SERIALIZED_NAME_NODE_PUBKEY = "node_pubkey";
    @SerializedName(value="node_pubkey")
    private byte[] nodePubkey;
    public static final String SERIALIZED_NAME_CHAIN_HASH = "chain_hash";
    @SerializedName(value="chain_hash")
    private byte[] chainHash;
    public static final String SERIALIZED_NAME_PENDING_CHAN_ID = "pending_chan_id";
    @SerializedName(value="pending_chan_id")
    private byte[] pendingChanId;
    public static final String SERIALIZED_NAME_FUNDING_AMT = "funding_amt";
    @SerializedName(value="funding_amt")
    private String fundingAmt;
    public static final String SERIALIZED_NAME_PUSH_AMT = "push_amt";
    @SerializedName(value="push_amt")
    private String pushAmt;
    public static final String SERIALIZED_NAME_DUST_LIMIT = "dust_limit";
    @SerializedName(value="dust_limit")
    private String dustLimit;
    public static final String SERIALIZED_NAME_MAX_VALUE_IN_FLIGHT = "max_value_in_flight";
    @SerializedName(value="max_value_in_flight")
    private String maxValueInFlight;
    public static final String SERIALIZED_NAME_CHANNEL_RESERVE = "channel_reserve";
    @SerializedName(value="channel_reserve")
    private String channelReserve;
    public static final String SERIALIZED_NAME_MIN_HTLC = "min_htlc";
    @SerializedName(value="min_htlc")
    private String minHtlc;
    public static final String SERIALIZED_NAME_FEE_PER_KW = "fee_per_kw";
    @SerializedName(value="fee_per_kw")
    private String feePerKw;
    public static final String SERIALIZED_NAME_CSV_DELAY = "csv_delay";
    @SerializedName(value="csv_delay")
    private Long csvDelay;
    public static final String SERIALIZED_NAME_MAX_ACCEPTED_HTLCS = "max_accepted_htlcs";
    @SerializedName(value="max_accepted_htlcs")
    private Long maxAcceptedHtlcs;
    public static final String SERIALIZED_NAME_CHANNEL_FLAGS = "channel_flags";
    @SerializedName(value="channel_flags")
    private Long channelFlags;
    public static final String SERIALIZED_NAME_COMMITMENT_TYPE = "commitment_type";
    @SerializedName(value="commitment_type")
    private LnrpcCommitmentType commitmentType = LnrpcCommitmentType.UNKNOWN_COMMITMENT_TYPE;
    public static final String SERIALIZED_NAME_WANTS_ZERO_CONF = "wants_zero_conf";
    @SerializedName(value="wants_zero_conf")
    private Boolean wantsZeroConf;
    public static final String SERIALIZED_NAME_WANTS_SCID_ALIAS = "wants_scid_alias";
    @SerializedName(value="wants_scid_alias")
    private Boolean wantsScidAlias;

    public LnrpcChannelAcceptRequest nodePubkey(byte[] nodePubkey) {
        this.nodePubkey = nodePubkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pubkey of the node that wishes to open an inbound channel.")
    public byte[] getNodePubkey() {
        return this.nodePubkey;
    }

    public void setNodePubkey(byte[] nodePubkey) {
        this.nodePubkey = nodePubkey;
    }

    public LnrpcChannelAcceptRequest chainHash(byte[] chainHash) {
        this.chainHash = chainHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hash of the genesis block that the proposed channel resides in.")
    public byte[] getChainHash() {
        return this.chainHash;
    }

    public void setChainHash(byte[] chainHash) {
        this.chainHash = chainHash;
    }

    public LnrpcChannelAcceptRequest pendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pending channel id.")
    public byte[] getPendingChanId() {
        return this.pendingChanId;
    }

    public void setPendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
    }

    public LnrpcChannelAcceptRequest fundingAmt(String fundingAmt) {
        this.fundingAmt = fundingAmt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The funding amount in satoshis that initiator wishes to use in the channel.")
    public String getFundingAmt() {
        return this.fundingAmt;
    }

    public void setFundingAmt(String fundingAmt) {
        this.fundingAmt = fundingAmt;
    }

    public LnrpcChannelAcceptRequest pushAmt(String pushAmt) {
        this.pushAmt = pushAmt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The push amount of the proposed channel in millisatoshis.")
    public String getPushAmt() {
        return this.pushAmt;
    }

    public void setPushAmt(String pushAmt) {
        this.pushAmt = pushAmt;
    }

    public LnrpcChannelAcceptRequest dustLimit(String dustLimit) {
        this.dustLimit = dustLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The dust limit of the initiator's commitment tx.")
    public String getDustLimit() {
        return this.dustLimit;
    }

    public void setDustLimit(String dustLimit) {
        this.dustLimit = dustLimit;
    }

    public LnrpcChannelAcceptRequest maxValueInFlight(String maxValueInFlight) {
        this.maxValueInFlight = maxValueInFlight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum amount of coins in millisatoshis that can be pending in this channel.")
    public String getMaxValueInFlight() {
        return this.maxValueInFlight;
    }

    public void setMaxValueInFlight(String maxValueInFlight) {
        this.maxValueInFlight = maxValueInFlight;
    }

    public LnrpcChannelAcceptRequest channelReserve(String channelReserve) {
        this.channelReserve = channelReserve;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum amount of satoshis the initiator requires us to have at all times.")
    public String getChannelReserve() {
        return this.channelReserve;
    }

    public void setChannelReserve(String channelReserve) {
        this.channelReserve = channelReserve;
    }

    public LnrpcChannelAcceptRequest minHtlc(String minHtlc) {
        this.minHtlc = minHtlc;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The smallest HTLC in millisatoshis that the initiator will accept.")
    public String getMinHtlc() {
        return this.minHtlc;
    }

    public void setMinHtlc(String minHtlc) {
        this.minHtlc = minHtlc;
    }

    public LnrpcChannelAcceptRequest feePerKw(String feePerKw) {
        this.feePerKw = feePerKw;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The initial fee rate that the initiator suggests for both commitment transactions.")
    public String getFeePerKw() {
        return this.feePerKw;
    }

    public void setFeePerKw(String feePerKw) {
        this.feePerKw = feePerKw;
    }

    public LnrpcChannelAcceptRequest csvDelay(Long csvDelay) {
        this.csvDelay = csvDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of blocks to use for the relative time lock in the pay-to-self output of both commitment transactions.")
    public Long getCsvDelay() {
        return this.csvDelay;
    }

    public void setCsvDelay(Long csvDelay) {
        this.csvDelay = csvDelay;
    }

    public LnrpcChannelAcceptRequest maxAcceptedHtlcs(Long maxAcceptedHtlcs) {
        this.maxAcceptedHtlcs = maxAcceptedHtlcs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of incoming HTLC's that the initiator will accept.")
    public Long getMaxAcceptedHtlcs() {
        return this.maxAcceptedHtlcs;
    }

    public void setMaxAcceptedHtlcs(Long maxAcceptedHtlcs) {
        this.maxAcceptedHtlcs = maxAcceptedHtlcs;
    }

    public LnrpcChannelAcceptRequest channelFlags(Long channelFlags) {
        this.channelFlags = channelFlags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A bit-field which the initiator uses to specify proposed channel behavior.")
    public Long getChannelFlags() {
        return this.channelFlags;
    }

    public void setChannelFlags(Long channelFlags) {
        this.channelFlags = channelFlags;
    }

    public LnrpcChannelAcceptRequest commitmentType(LnrpcCommitmentType commitmentType) {
        this.commitmentType = commitmentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcCommitmentType getCommitmentType() {
        return this.commitmentType;
    }

    public void setCommitmentType(LnrpcCommitmentType commitmentType) {
        this.commitmentType = commitmentType;
    }

    public LnrpcChannelAcceptRequest wantsZeroConf(Boolean wantsZeroConf) {
        this.wantsZeroConf = wantsZeroConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the initiator wants to open a zero-conf channel via the channel type.")
    public Boolean getWantsZeroConf() {
        return this.wantsZeroConf;
    }

    public void setWantsZeroConf(Boolean wantsZeroConf) {
        this.wantsZeroConf = wantsZeroConf;
    }

    public LnrpcChannelAcceptRequest wantsScidAlias(Boolean wantsScidAlias) {
        this.wantsScidAlias = wantsScidAlias;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the initiator wants to use the scid-alias channel type. This is separate from the feature bit.")
    public Boolean getWantsScidAlias() {
        return this.wantsScidAlias;
    }

    public void setWantsScidAlias(Boolean wantsScidAlias) {
        this.wantsScidAlias = wantsScidAlias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannelAcceptRequest lnrpcChannelAcceptRequest = (LnrpcChannelAcceptRequest)o;
        return Arrays.equals(this.nodePubkey, lnrpcChannelAcceptRequest.nodePubkey) && Arrays.equals(this.chainHash, lnrpcChannelAcceptRequest.chainHash) && Arrays.equals(this.pendingChanId, lnrpcChannelAcceptRequest.pendingChanId) && Objects.equals(this.fundingAmt, lnrpcChannelAcceptRequest.fundingAmt) && Objects.equals(this.pushAmt, lnrpcChannelAcceptRequest.pushAmt) && Objects.equals(this.dustLimit, lnrpcChannelAcceptRequest.dustLimit) && Objects.equals(this.maxValueInFlight, lnrpcChannelAcceptRequest.maxValueInFlight) && Objects.equals(this.channelReserve, lnrpcChannelAcceptRequest.channelReserve) && Objects.equals(this.minHtlc, lnrpcChannelAcceptRequest.minHtlc) && Objects.equals(this.feePerKw, lnrpcChannelAcceptRequest.feePerKw) && Objects.equals(this.csvDelay, lnrpcChannelAcceptRequest.csvDelay) && Objects.equals(this.maxAcceptedHtlcs, lnrpcChannelAcceptRequest.maxAcceptedHtlcs) && Objects.equals(this.channelFlags, lnrpcChannelAcceptRequest.channelFlags) && Objects.equals((Object)this.commitmentType, (Object)lnrpcChannelAcceptRequest.commitmentType) && Objects.equals(this.wantsZeroConf, lnrpcChannelAcceptRequest.wantsZeroConf) && Objects.equals(this.wantsScidAlias, lnrpcChannelAcceptRequest.wantsScidAlias);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.nodePubkey), Arrays.hashCode(this.chainHash), Arrays.hashCode(this.pendingChanId), this.fundingAmt, this.pushAmt, this.dustLimit, this.maxValueInFlight, this.channelReserve, this.minHtlc, this.feePerKw, this.csvDelay, this.maxAcceptedHtlcs, this.channelFlags, this.commitmentType, this.wantsZeroConf, this.wantsScidAlias});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannelAcceptRequest {\n");
        sb.append("    nodePubkey: ").append(this.toIndentedString(this.nodePubkey)).append("\n");
        sb.append("    chainHash: ").append(this.toIndentedString(this.chainHash)).append("\n");
        sb.append("    pendingChanId: ").append(this.toIndentedString(this.pendingChanId)).append("\n");
        sb.append("    fundingAmt: ").append(this.toIndentedString(this.fundingAmt)).append("\n");
        sb.append("    pushAmt: ").append(this.toIndentedString(this.pushAmt)).append("\n");
        sb.append("    dustLimit: ").append(this.toIndentedString(this.dustLimit)).append("\n");
        sb.append("    maxValueInFlight: ").append(this.toIndentedString(this.maxValueInFlight)).append("\n");
        sb.append("    channelReserve: ").append(this.toIndentedString(this.channelReserve)).append("\n");
        sb.append("    minHtlc: ").append(this.toIndentedString(this.minHtlc)).append("\n");
        sb.append("    feePerKw: ").append(this.toIndentedString(this.feePerKw)).append("\n");
        sb.append("    csvDelay: ").append(this.toIndentedString(this.csvDelay)).append("\n");
        sb.append("    maxAcceptedHtlcs: ").append(this.toIndentedString(this.maxAcceptedHtlcs)).append("\n");
        sb.append("    channelFlags: ").append(this.toIndentedString(this.channelFlags)).append("\n");
        sb.append("    commitmentType: ").append(this.toIndentedString((Object)this.commitmentType)).append("\n");
        sb.append("    wantsZeroConf: ").append(this.toIndentedString(this.wantsZeroConf)).append("\n");
        sb.append("    wantsScidAlias: ").append(this.toIndentedString(this.wantsScidAlias)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

