/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcChannelConstraints;
import net.osslabz.lnd.dto.LnrpcCommitmentType;
import net.osslabz.lnd.dto.LnrpcHTLC;

public class LnrpcChannel {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_REMOTE_PUBKEY = "remote_pubkey";
    @SerializedName(value="remote_pubkey")
    private String remotePubkey;
    public static final String SERIALIZED_NAME_CHANNEL_POINT = "channel_point";
    @SerializedName(value="channel_point")
    private String channelPoint;
    public static final String SERIALIZED_NAME_CHAN_ID = "chan_id";
    @SerializedName(value="chan_id")
    private String chanId;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private String capacity;
    public static final String SERIALIZED_NAME_LOCAL_BALANCE = "local_balance";
    @SerializedName(value="local_balance")
    private String localBalance;
    public static final String SERIALIZED_NAME_REMOTE_BALANCE = "remote_balance";
    @SerializedName(value="remote_balance")
    private String remoteBalance;
    public static final String SERIALIZED_NAME_COMMIT_FEE = "commit_fee";
    @SerializedName(value="commit_fee")
    private String commitFee;
    public static final String SERIALIZED_NAME_COMMIT_WEIGHT = "commit_weight";
    @SerializedName(value="commit_weight")
    private String commitWeight;
    public static final String SERIALIZED_NAME_FEE_PER_KW = "fee_per_kw";
    @SerializedName(value="fee_per_kw")
    private String feePerKw;
    public static final String SERIALIZED_NAME_UNSETTLED_BALANCE = "unsettled_balance";
    @SerializedName(value="unsettled_balance")
    private String unsettledBalance;
    public static final String SERIALIZED_NAME_TOTAL_SATOSHIS_SENT = "total_satoshis_sent";
    @SerializedName(value="total_satoshis_sent")
    private String totalSatoshisSent;
    public static final String SERIALIZED_NAME_TOTAL_SATOSHIS_RECEIVED = "total_satoshis_received";
    @SerializedName(value="total_satoshis_received")
    private String totalSatoshisReceived;
    public static final String SERIALIZED_NAME_NUM_UPDATES = "num_updates";
    @SerializedName(value="num_updates")
    private String numUpdates;
    public static final String SERIALIZED_NAME_PENDING_HTLCS = "pending_htlcs";
    @SerializedName(value="pending_htlcs")
    private List<LnrpcHTLC> pendingHtlcs = null;
    public static final String SERIALIZED_NAME_CSV_DELAY = "csv_delay";
    @SerializedName(value="csv_delay")
    private Long csvDelay;
    public static final String SERIALIZED_NAME_PRIVATE = "private";
    @SerializedName(value="private")
    private Boolean _private;
    public static final String SERIALIZED_NAME_INITIATOR = "initiator";
    @SerializedName(value="initiator")
    private Boolean initiator;
    public static final String SERIALIZED_NAME_CHAN_STATUS_FLAGS = "chan_status_flags";
    @SerializedName(value="chan_status_flags")
    private String chanStatusFlags;
    public static final String SERIALIZED_NAME_LOCAL_CHAN_RESERVE_SAT = "local_chan_reserve_sat";
    @SerializedName(value="local_chan_reserve_sat")
    private String localChanReserveSat;
    public static final String SERIALIZED_NAME_REMOTE_CHAN_RESERVE_SAT = "remote_chan_reserve_sat";
    @SerializedName(value="remote_chan_reserve_sat")
    private String remoteChanReserveSat;
    public static final String SERIALIZED_NAME_STATIC_REMOTE_KEY = "static_remote_key";
    @SerializedName(value="static_remote_key")
    private Boolean staticRemoteKey;
    public static final String SERIALIZED_NAME_COMMITMENT_TYPE = "commitment_type";
    @SerializedName(value="commitment_type")
    private LnrpcCommitmentType commitmentType = LnrpcCommitmentType.UNKNOWN_COMMITMENT_TYPE;
    public static final String SERIALIZED_NAME_LIFETIME = "lifetime";
    @SerializedName(value="lifetime")
    private String lifetime;
    public static final String SERIALIZED_NAME_UPTIME = "uptime";
    @SerializedName(value="uptime")
    private String uptime;
    public static final String SERIALIZED_NAME_CLOSE_ADDRESS = "close_address";
    @SerializedName(value="close_address")
    private String closeAddress;
    public static final String SERIALIZED_NAME_PUSH_AMOUNT_SAT = "push_amount_sat";
    @SerializedName(value="push_amount_sat")
    private String pushAmountSat;
    public static final String SERIALIZED_NAME_THAW_HEIGHT = "thaw_height";
    @SerializedName(value="thaw_height")
    private Long thawHeight;
    public static final String SERIALIZED_NAME_LOCAL_CONSTRAINTS = "local_constraints";
    @SerializedName(value="local_constraints")
    private LnrpcChannelConstraints localConstraints;
    public static final String SERIALIZED_NAME_REMOTE_CONSTRAINTS = "remote_constraints";
    @SerializedName(value="remote_constraints")
    private LnrpcChannelConstraints remoteConstraints;
    public static final String SERIALIZED_NAME_ALIAS_SCIDS = "alias_scids";
    @SerializedName(value="alias_scids")
    private List<String> aliasScids = null;
    public static final String SERIALIZED_NAME_ZERO_CONF = "zero_conf";
    @SerializedName(value="zero_conf")
    private Boolean zeroConf;
    public static final String SERIALIZED_NAME_ZERO_CONF_CONFIRMED_SCID = "zero_conf_confirmed_scid";
    @SerializedName(value="zero_conf_confirmed_scid")
    private String zeroConfConfirmedScid;
    public static final String SERIALIZED_NAME_PEER_ALIAS = "peer_alias";
    @SerializedName(value="peer_alias")
    private String peerAlias;

    public LnrpcChannel active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public LnrpcChannel remotePubkey(String remotePubkey) {
        this.remotePubkey = remotePubkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getRemotePubkey() {
        return this.remotePubkey;
    }

    public void setRemotePubkey(String remotePubkey) {
        this.remotePubkey = remotePubkey;
    }

    public LnrpcChannel channelPoint(String channelPoint) {
        this.channelPoint = channelPoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The outpoint (txid:index) of the funding transaction. With this value, Bob will be able to generate a signature for Alice's version of the commitment transaction.")
    public String getChannelPoint() {
        return this.channelPoint;
    }

    public void setChannelPoint(String channelPoint) {
        this.channelPoint = channelPoint;
    }

    public LnrpcChannel chanId(String chanId) {
        this.chanId = chanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique channel ID for the channel. The first 3 bytes are the block height, the next 3 the index within the block, and the last 2 bytes are the output index for the channel.")
    public String getChanId() {
        return this.chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public LnrpcChannel capacity(String capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public LnrpcChannel localBalance(String localBalance) {
        this.localBalance = localBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getLocalBalance() {
        return this.localBalance;
    }

    public void setLocalBalance(String localBalance) {
        this.localBalance = localBalance;
    }

    public LnrpcChannel remoteBalance(String remoteBalance) {
        this.remoteBalance = remoteBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getRemoteBalance() {
        return this.remoteBalance;
    }

    public void setRemoteBalance(String remoteBalance) {
        this.remoteBalance = remoteBalance;
    }

    public LnrpcChannel commitFee(String commitFee) {
        this.commitFee = commitFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount calculated to be paid in fees for the current set of commitment transactions. The fee amount is persisted with the channel in order to allow the fee amount to be removed and recalculated with each channel state update, including updates that happen after a system restart.")
    public String getCommitFee() {
        return this.commitFee;
    }

    public void setCommitFee(String commitFee) {
        this.commitFee = commitFee;
    }

    public LnrpcChannel commitWeight(String commitWeight) {
        this.commitWeight = commitWeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCommitWeight() {
        return this.commitWeight;
    }

    public void setCommitWeight(String commitWeight) {
        this.commitWeight = commitWeight;
    }

    public LnrpcChannel feePerKw(String feePerKw) {
        this.feePerKw = feePerKw;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The required number of satoshis per kilo-weight that the requester will pay at all times, for both the funding transaction and commitment transaction. This value can later be updated once the channel is open.")
    public String getFeePerKw() {
        return this.feePerKw;
    }

    public void setFeePerKw(String feePerKw) {
        this.feePerKw = feePerKw;
    }

    public LnrpcChannel unsettledBalance(String unsettledBalance) {
        this.unsettledBalance = unsettledBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getUnsettledBalance() {
        return this.unsettledBalance;
    }

    public void setUnsettledBalance(String unsettledBalance) {
        this.unsettledBalance = unsettledBalance;
    }

    public LnrpcChannel totalSatoshisSent(String totalSatoshisSent) {
        this.totalSatoshisSent = totalSatoshisSent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of satoshis we've sent within this channel.")
    public String getTotalSatoshisSent() {
        return this.totalSatoshisSent;
    }

    public void setTotalSatoshisSent(String totalSatoshisSent) {
        this.totalSatoshisSent = totalSatoshisSent;
    }

    public LnrpcChannel totalSatoshisReceived(String totalSatoshisReceived) {
        this.totalSatoshisReceived = totalSatoshisReceived;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of satoshis we've received within this channel.")
    public String getTotalSatoshisReceived() {
        return this.totalSatoshisReceived;
    }

    public void setTotalSatoshisReceived(String totalSatoshisReceived) {
        this.totalSatoshisReceived = totalSatoshisReceived;
    }

    public LnrpcChannel numUpdates(String numUpdates) {
        this.numUpdates = numUpdates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of updates conducted within this channel.")
    public String getNumUpdates() {
        return this.numUpdates;
    }

    public void setNumUpdates(String numUpdates) {
        this.numUpdates = numUpdates;
    }

    public LnrpcChannel pendingHtlcs(List<LnrpcHTLC> pendingHtlcs) {
        this.pendingHtlcs = pendingHtlcs;
        return this;
    }

    public LnrpcChannel addPendingHtlcsItem(LnrpcHTLC pendingHtlcsItem) {
        if (this.pendingHtlcs == null) {
            this.pendingHtlcs = new ArrayList<LnrpcHTLC>();
        }
        this.pendingHtlcs.add(pendingHtlcsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of active, uncleared HTLCs currently pending within the channel.")
    public List<LnrpcHTLC> getPendingHtlcs() {
        return this.pendingHtlcs;
    }

    public void setPendingHtlcs(List<LnrpcHTLC> pendingHtlcs) {
        this.pendingHtlcs = pendingHtlcs;
    }

    public LnrpcChannel csvDelay(Long csvDelay) {
        this.csvDelay = csvDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. The CSV delay expressed in relative blocks. If the channel is force closed, we will need to wait for this many blocks before we can regain our funds.")
    public Long getCsvDelay() {
        return this.csvDelay;
    }

    public void setCsvDelay(Long csvDelay) {
        this.csvDelay = csvDelay;
    }

    public LnrpcChannel _private(Boolean _private) {
        this._private = _private;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this channel is advertised to the network or not.")
    public Boolean getPrivate() {
        return this._private;
    }

    public void setPrivate(Boolean _private) {
        this._private = _private;
    }

    public LnrpcChannel initiator(Boolean initiator) {
        this.initiator = initiator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if we were the ones that created the channel.")
    public Boolean getInitiator() {
        return this.initiator;
    }

    public void setInitiator(Boolean initiator) {
        this.initiator = initiator;
    }

    public LnrpcChannel chanStatusFlags(String chanStatusFlags) {
        this.chanStatusFlags = chanStatusFlags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A set of flags showing the current state of the channel.")
    public String getChanStatusFlags() {
        return this.chanStatusFlags;
    }

    public void setChanStatusFlags(String chanStatusFlags) {
        this.chanStatusFlags = chanStatusFlags;
    }

    public LnrpcChannel localChanReserveSat(String localChanReserveSat) {
        this.localChanReserveSat = localChanReserveSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. The minimum satoshis this node is required to reserve in its balance.")
    public String getLocalChanReserveSat() {
        return this.localChanReserveSat;
    }

    public void setLocalChanReserveSat(String localChanReserveSat) {
        this.localChanReserveSat = localChanReserveSat;
    }

    public LnrpcChannel remoteChanReserveSat(String remoteChanReserveSat) {
        this.remoteChanReserveSat = remoteChanReserveSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. The minimum satoshis the other node is required to reserve in its balance.")
    public String getRemoteChanReserveSat() {
        return this.remoteChanReserveSat;
    }

    public void setRemoteChanReserveSat(String remoteChanReserveSat) {
        this.remoteChanReserveSat = remoteChanReserveSat;
    }

    public LnrpcChannel staticRemoteKey(Boolean staticRemoteKey) {
        this.staticRemoteKey = staticRemoteKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. Use commitment_type.")
    public Boolean getStaticRemoteKey() {
        return this.staticRemoteKey;
    }

    public void setStaticRemoteKey(Boolean staticRemoteKey) {
        this.staticRemoteKey = staticRemoteKey;
    }

    public LnrpcChannel commitmentType(LnrpcCommitmentType commitmentType) {
        this.commitmentType = commitmentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcCommitmentType getCommitmentType() {
        return this.commitmentType;
    }

    public void setCommitmentType(LnrpcCommitmentType commitmentType) {
        this.commitmentType = commitmentType;
    }

    public LnrpcChannel lifetime(String lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of seconds that the channel has been monitored by the channel scoring system. Scores are currently not persisted, so this value may be less than the lifetime of the channel [EXPERIMENTAL].")
    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    public LnrpcChannel uptime(String uptime) {
        this.uptime = uptime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of seconds that the remote peer has been observed as being online by the channel scoring system over the lifetime of the channel [EXPERIMENTAL].")
    public String getUptime() {
        return this.uptime;
    }

    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    public LnrpcChannel closeAddress(String closeAddress) {
        this.closeAddress = closeAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Close address is the address that we will enforce payout to on cooperative close if the channel was opened utilizing option upfront shutdown. This value can be set on channel open by setting close_address in an open channel request. If this value is not set, you can still choose a payout address by cooperatively closing with the delivery_address field set.")
    public String getCloseAddress() {
        return this.closeAddress;
    }

    public void setCloseAddress(String closeAddress) {
        this.closeAddress = closeAddress;
    }

    public LnrpcChannel pushAmountSat(String pushAmountSat) {
        this.pushAmountSat = pushAmountSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount that the initiator of the channel optionally pushed to the remote party on channel open. This amount will be zero if the channel initiator did not push any funds to the remote peer. If the initiator field is true, we pushed this amount to our peer, if it is false, the remote peer pushed this amount to us.")
    public String getPushAmountSat() {
        return this.pushAmountSat;
    }

    public void setPushAmountSat(String pushAmountSat) {
        this.pushAmountSat = pushAmountSat;
    }

    public LnrpcChannel thawHeight(Long thawHeight) {
        this.thawHeight = thawHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This uint32 indicates if this channel is to be considered 'frozen'. A frozen channel doest not allow a cooperative channel close by the initiator. The thaw_height is the height that this restriction stops applying to the channel. This field is optional, not setting it or using a value of zero will mean the channel has no additional restrictions. The height can be interpreted in two ways: as a relative height if the value is less than 500,000, or as an absolute height otherwise.")
    public Long getThawHeight() {
        return this.thawHeight;
    }

    public void setThawHeight(Long thawHeight) {
        this.thawHeight = thawHeight;
    }

    public LnrpcChannel localConstraints(LnrpcChannelConstraints localConstraints) {
        this.localConstraints = localConstraints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcChannelConstraints getLocalConstraints() {
        return this.localConstraints;
    }

    public void setLocalConstraints(LnrpcChannelConstraints localConstraints) {
        this.localConstraints = localConstraints;
    }

    public LnrpcChannel remoteConstraints(LnrpcChannelConstraints remoteConstraints) {
        this.remoteConstraints = remoteConstraints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcChannelConstraints getRemoteConstraints() {
        return this.remoteConstraints;
    }

    public void setRemoteConstraints(LnrpcChannelConstraints remoteConstraints) {
        this.remoteConstraints = remoteConstraints;
    }

    public LnrpcChannel aliasScids(List<String> aliasScids) {
        this.aliasScids = aliasScids;
        return this;
    }

    public LnrpcChannel addAliasScidsItem(String aliasScidsItem) {
        if (this.aliasScids == null) {
            this.aliasScids = new ArrayList<String>();
        }
        this.aliasScids.add(aliasScidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This lists out the set of alias short channel ids that exist for a channel. This may be empty.")
    public List<String> getAliasScids() {
        return this.aliasScids;
    }

    public void setAliasScids(List<String> aliasScids) {
        this.aliasScids = aliasScids;
    }

    public LnrpcChannel zeroConf(Boolean zeroConf) {
        this.zeroConf = zeroConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not this is a zero-conf channel.")
    public Boolean getZeroConf() {
        return this.zeroConf;
    }

    public void setZeroConf(Boolean zeroConf) {
        this.zeroConf = zeroConf;
    }

    public LnrpcChannel zeroConfConfirmedScid(String zeroConfConfirmedScid) {
        this.zeroConfConfirmedScid = zeroConfConfirmedScid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This is the confirmed / on-chain zero-conf SCID.")
    public String getZeroConfConfirmedScid() {
        return this.zeroConfConfirmedScid;
    }

    public void setZeroConfConfirmedScid(String zeroConfConfirmedScid) {
        this.zeroConfConfirmedScid = zeroConfConfirmedScid;
    }

    public LnrpcChannel peerAlias(String peerAlias) {
        this.peerAlias = peerAlias;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The configured alias name of our peer.")
    public String getPeerAlias() {
        return this.peerAlias;
    }

    public void setPeerAlias(String peerAlias) {
        this.peerAlias = peerAlias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChannel lnrpcChannel = (LnrpcChannel)o;
        return Objects.equals(this.active, lnrpcChannel.active) && Objects.equals(this.remotePubkey, lnrpcChannel.remotePubkey) && Objects.equals(this.channelPoint, lnrpcChannel.channelPoint) && Objects.equals(this.chanId, lnrpcChannel.chanId) && Objects.equals(this.capacity, lnrpcChannel.capacity) && Objects.equals(this.localBalance, lnrpcChannel.localBalance) && Objects.equals(this.remoteBalance, lnrpcChannel.remoteBalance) && Objects.equals(this.commitFee, lnrpcChannel.commitFee) && Objects.equals(this.commitWeight, lnrpcChannel.commitWeight) && Objects.equals(this.feePerKw, lnrpcChannel.feePerKw) && Objects.equals(this.unsettledBalance, lnrpcChannel.unsettledBalance) && Objects.equals(this.totalSatoshisSent, lnrpcChannel.totalSatoshisSent) && Objects.equals(this.totalSatoshisReceived, lnrpcChannel.totalSatoshisReceived) && Objects.equals(this.numUpdates, lnrpcChannel.numUpdates) && Objects.equals(this.pendingHtlcs, lnrpcChannel.pendingHtlcs) && Objects.equals(this.csvDelay, lnrpcChannel.csvDelay) && Objects.equals(this._private, lnrpcChannel._private) && Objects.equals(this.initiator, lnrpcChannel.initiator) && Objects.equals(this.chanStatusFlags, lnrpcChannel.chanStatusFlags) && Objects.equals(this.localChanReserveSat, lnrpcChannel.localChanReserveSat) && Objects.equals(this.remoteChanReserveSat, lnrpcChannel.remoteChanReserveSat) && Objects.equals(this.staticRemoteKey, lnrpcChannel.staticRemoteKey) && Objects.equals((Object)this.commitmentType, (Object)lnrpcChannel.commitmentType) && Objects.equals(this.lifetime, lnrpcChannel.lifetime) && Objects.equals(this.uptime, lnrpcChannel.uptime) && Objects.equals(this.closeAddress, lnrpcChannel.closeAddress) && Objects.equals(this.pushAmountSat, lnrpcChannel.pushAmountSat) && Objects.equals(this.thawHeight, lnrpcChannel.thawHeight) && Objects.equals(this.localConstraints, lnrpcChannel.localConstraints) && Objects.equals(this.remoteConstraints, lnrpcChannel.remoteConstraints) && Objects.equals(this.aliasScids, lnrpcChannel.aliasScids) && Objects.equals(this.zeroConf, lnrpcChannel.zeroConf) && Objects.equals(this.zeroConfConfirmedScid, lnrpcChannel.zeroConfConfirmedScid) && Objects.equals(this.peerAlias, lnrpcChannel.peerAlias);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.active, this.remotePubkey, this.channelPoint, this.chanId, this.capacity, this.localBalance, this.remoteBalance, this.commitFee, this.commitWeight, this.feePerKw, this.unsettledBalance, this.totalSatoshisSent, this.totalSatoshisReceived, this.numUpdates, this.pendingHtlcs, this.csvDelay, this._private, this.initiator, this.chanStatusFlags, this.localChanReserveSat, this.remoteChanReserveSat, this.staticRemoteKey, this.commitmentType, this.lifetime, this.uptime, this.closeAddress, this.pushAmountSat, this.thawHeight, this.localConstraints, this.remoteConstraints, this.aliasScids, this.zeroConf, this.zeroConfConfirmedScid, this.peerAlias});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChannel {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    remotePubkey: ").append(this.toIndentedString(this.remotePubkey)).append("\n");
        sb.append("    channelPoint: ").append(this.toIndentedString(this.channelPoint)).append("\n");
        sb.append("    chanId: ").append(this.toIndentedString(this.chanId)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    localBalance: ").append(this.toIndentedString(this.localBalance)).append("\n");
        sb.append("    remoteBalance: ").append(this.toIndentedString(this.remoteBalance)).append("\n");
        sb.append("    commitFee: ").append(this.toIndentedString(this.commitFee)).append("\n");
        sb.append("    commitWeight: ").append(this.toIndentedString(this.commitWeight)).append("\n");
        sb.append("    feePerKw: ").append(this.toIndentedString(this.feePerKw)).append("\n");
        sb.append("    unsettledBalance: ").append(this.toIndentedString(this.unsettledBalance)).append("\n");
        sb.append("    totalSatoshisSent: ").append(this.toIndentedString(this.totalSatoshisSent)).append("\n");
        sb.append("    totalSatoshisReceived: ").append(this.toIndentedString(this.totalSatoshisReceived)).append("\n");
        sb.append("    numUpdates: ").append(this.toIndentedString(this.numUpdates)).append("\n");
        sb.append("    pendingHtlcs: ").append(this.toIndentedString(this.pendingHtlcs)).append("\n");
        sb.append("    csvDelay: ").append(this.toIndentedString(this.csvDelay)).append("\n");
        sb.append("    _private: ").append(this.toIndentedString(this._private)).append("\n");
        sb.append("    initiator: ").append(this.toIndentedString(this.initiator)).append("\n");
        sb.append("    chanStatusFlags: ").append(this.toIndentedString(this.chanStatusFlags)).append("\n");
        sb.append("    localChanReserveSat: ").append(this.toIndentedString(this.localChanReserveSat)).append("\n");
        sb.append("    remoteChanReserveSat: ").append(this.toIndentedString(this.remoteChanReserveSat)).append("\n");
        sb.append("    staticRemoteKey: ").append(this.toIndentedString(this.staticRemoteKey)).append("\n");
        sb.append("    commitmentType: ").append(this.toIndentedString((Object)this.commitmentType)).append("\n");
        sb.append("    lifetime: ").append(this.toIndentedString(this.lifetime)).append("\n");
        sb.append("    uptime: ").append(this.toIndentedString(this.uptime)).append("\n");
        sb.append("    closeAddress: ").append(this.toIndentedString(this.closeAddress)).append("\n");
        sb.append("    pushAmountSat: ").append(this.toIndentedString(this.pushAmountSat)).append("\n");
        sb.append("    thawHeight: ").append(this.toIndentedString(this.thawHeight)).append("\n");
        sb.append("    localConstraints: ").append(this.toIndentedString(this.localConstraints)).append("\n");
        sb.append("    remoteConstraints: ").append(this.toIndentedString(this.remoteConstraints)).append("\n");
        sb.append("    aliasScids: ").append(this.toIndentedString(this.aliasScids)).append("\n");
        sb.append("    zeroConf: ").append(this.toIndentedString(this.zeroConf)).append("\n");
        sb.append("    zeroConfConfirmedScid: ").append(this.toIndentedString(this.zeroConfConfirmedScid)).append("\n");
        sb.append("    peerAlias: ").append(this.toIndentedString(this.peerAlias)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

