/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcChannelPoint;
import net.osslabz.lnd.dto.LnrpcKeyDescriptor;

public class LnrpcChanPointShim {
    public static final String SERIALIZED_NAME_AMT = "amt";
    @SerializedName(value="amt")
    private String amt;
    public static final String SERIALIZED_NAME_CHAN_POINT = "chan_point";
    @SerializedName(value="chan_point")
    private LnrpcChannelPoint chanPoint;
    public static final String SERIALIZED_NAME_LOCAL_KEY = "local_key";
    @SerializedName(value="local_key")
    private LnrpcKeyDescriptor localKey;
    public static final String SERIALIZED_NAME_REMOTE_KEY = "remote_key";
    @SerializedName(value="remote_key")
    private byte[] remoteKey;
    public static final String SERIALIZED_NAME_PENDING_CHAN_ID = "pending_chan_id";
    @SerializedName(value="pending_chan_id")
    private byte[] pendingChanId;
    public static final String SERIALIZED_NAME_THAW_HEIGHT = "thaw_height";
    @SerializedName(value="thaw_height")
    private Long thawHeight;

    public LnrpcChanPointShim amt(String amt) {
        this.amt = amt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size of the pre-crafted output to be used as the channel point for this channel funding.")
    public String getAmt() {
        return this.amt;
    }

    public void setAmt(String amt) {
        this.amt = amt;
    }

    public LnrpcChanPointShim chanPoint(LnrpcChannelPoint chanPoint) {
        this.chanPoint = chanPoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcChannelPoint getChanPoint() {
        return this.chanPoint;
    }

    public void setChanPoint(LnrpcChannelPoint chanPoint) {
        this.chanPoint = chanPoint;
    }

    public LnrpcChanPointShim localKey(LnrpcKeyDescriptor localKey) {
        this.localKey = localKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcKeyDescriptor getLocalKey() {
        return this.localKey;
    }

    public void setLocalKey(LnrpcKeyDescriptor localKey) {
        this.localKey = localKey;
    }

    public LnrpcChanPointShim remoteKey(byte[] remoteKey) {
        this.remoteKey = remoteKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the remote party to use when creating the multi-sig output.")
    public byte[] getRemoteKey() {
        return this.remoteKey;
    }

    public void setRemoteKey(byte[] remoteKey) {
        this.remoteKey = remoteKey;
    }

    public LnrpcChanPointShim pendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If non-zero, then this will be used as the pending channel ID on the wire protocol to initate the funding request. This is an optional field, and should only be set if the responder is already expecting a specific pending channel ID.")
    public byte[] getPendingChanId() {
        return this.pendingChanId;
    }

    public void setPendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
    }

    public LnrpcChanPointShim thawHeight(Long thawHeight) {
        this.thawHeight = thawHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This uint32 indicates if this channel is to be considered 'frozen'. A frozen channel does not allow a cooperative channel close by the initiator. The thaw_height is the height that this restriction stops applying to the channel. The height can be interpreted in two ways: as a relative height if the value is less than 500,000, or as an absolute height otherwise.")
    public Long getThawHeight() {
        return this.thawHeight;
    }

    public void setThawHeight(Long thawHeight) {
        this.thawHeight = thawHeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcChanPointShim lnrpcChanPointShim = (LnrpcChanPointShim)o;
        return Objects.equals(this.amt, lnrpcChanPointShim.amt) && Objects.equals(this.chanPoint, lnrpcChanPointShim.chanPoint) && Objects.equals(this.localKey, lnrpcChanPointShim.localKey) && Arrays.equals(this.remoteKey, lnrpcChanPointShim.remoteKey) && Arrays.equals(this.pendingChanId, lnrpcChanPointShim.pendingChanId) && Objects.equals(this.thawHeight, lnrpcChanPointShim.thawHeight);
    }

    public int hashCode() {
        return Objects.hash(this.amt, this.chanPoint, this.localKey, Arrays.hashCode(this.remoteKey), Arrays.hashCode(this.pendingChanId), this.thawHeight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcChanPointShim {\n");
        sb.append("    amt: ").append(this.toIndentedString(this.amt)).append("\n");
        sb.append("    chanPoint: ").append(this.toIndentedString(this.chanPoint)).append("\n");
        sb.append("    localKey: ").append(this.toIndentedString(this.localKey)).append("\n");
        sb.append("    remoteKey: ").append(this.toIndentedString(this.remoteKey)).append("\n");
        sb.append("    pendingChanId: ").append(this.toIndentedString(this.pendingChanId)).append("\n");
        sb.append("    thawHeight: ").append(this.toIndentedString(this.thawHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

