/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcBatchOpenChannel;

public class LnrpcBatchOpenChannelRequest {
    public static final String SERIALIZED_NAME_CHANNELS = "channels";
    @SerializedName(value="channels")
    private List<LnrpcBatchOpenChannel> channels = null;
    public static final String SERIALIZED_NAME_TARGET_CONF = "target_conf";
    @SerializedName(value="target_conf")
    private Integer targetConf;
    public static final String SERIALIZED_NAME_SAT_PER_VBYTE = "sat_per_vbyte";
    @SerializedName(value="sat_per_vbyte")
    private String satPerVbyte;
    public static final String SERIALIZED_NAME_MIN_CONFS = "min_confs";
    @SerializedName(value="min_confs")
    private Integer minConfs;
    public static final String SERIALIZED_NAME_SPEND_UNCONFIRMED = "spend_unconfirmed";
    @SerializedName(value="spend_unconfirmed")
    private Boolean spendUnconfirmed;
    public static final String SERIALIZED_NAME_LABEL = "label";
    @SerializedName(value="label")
    private String label;

    public LnrpcBatchOpenChannelRequest channels(List<LnrpcBatchOpenChannel> channels) {
        this.channels = channels;
        return this;
    }

    public LnrpcBatchOpenChannelRequest addChannelsItem(LnrpcBatchOpenChannel channelsItem) {
        if (this.channels == null) {
            this.channels = new ArrayList<LnrpcBatchOpenChannel>();
        }
        this.channels.add(channelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of channels to open.")
    public List<LnrpcBatchOpenChannel> getChannels() {
        return this.channels;
    }

    public void setChannels(List<LnrpcBatchOpenChannel> channels) {
        this.channels = channels;
    }

    public LnrpcBatchOpenChannelRequest targetConf(Integer targetConf) {
        this.targetConf = targetConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target number of blocks that the funding transaction should be confirmed by.")
    public Integer getTargetConf() {
        return this.targetConf;
    }

    public void setTargetConf(Integer targetConf) {
        this.targetConf = targetConf;
    }

    public LnrpcBatchOpenChannelRequest satPerVbyte(String satPerVbyte) {
        this.satPerVbyte = satPerVbyte;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A manual fee rate set in sat/vByte that should be used when crafting the funding transaction.")
    public String getSatPerVbyte() {
        return this.satPerVbyte;
    }

    public void setSatPerVbyte(String satPerVbyte) {
        this.satPerVbyte = satPerVbyte;
    }

    public LnrpcBatchOpenChannelRequest minConfs(Integer minConfs) {
        this.minConfs = minConfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum number of confirmations each one of your outputs used for the funding transaction must satisfy.")
    public Integer getMinConfs() {
        return this.minConfs;
    }

    public void setMinConfs(Integer minConfs) {
        this.minConfs = minConfs;
    }

    public LnrpcBatchOpenChannelRequest spendUnconfirmed(Boolean spendUnconfirmed) {
        this.spendUnconfirmed = spendUnconfirmed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether unconfirmed outputs should be used as inputs for the funding transaction.")
    public Boolean getSpendUnconfirmed() {
        return this.spendUnconfirmed;
    }

    public void setSpendUnconfirmed(Boolean spendUnconfirmed) {
        this.spendUnconfirmed = spendUnconfirmed;
    }

    public LnrpcBatchOpenChannelRequest label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional label for the batch transaction, limited to 500 characters.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcBatchOpenChannelRequest lnrpcBatchOpenChannelRequest = (LnrpcBatchOpenChannelRequest)o;
        return Objects.equals(this.channels, lnrpcBatchOpenChannelRequest.channels) && Objects.equals(this.targetConf, lnrpcBatchOpenChannelRequest.targetConf) && Objects.equals(this.satPerVbyte, lnrpcBatchOpenChannelRequest.satPerVbyte) && Objects.equals(this.minConfs, lnrpcBatchOpenChannelRequest.minConfs) && Objects.equals(this.spendUnconfirmed, lnrpcBatchOpenChannelRequest.spendUnconfirmed) && Objects.equals(this.label, lnrpcBatchOpenChannelRequest.label);
    }

    public int hashCode() {
        return Objects.hash(this.channels, this.targetConf, this.satPerVbyte, this.minConfs, this.spendUnconfirmed, this.label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcBatchOpenChannelRequest {\n");
        sb.append("    channels: ").append(this.toIndentedString(this.channels)).append("\n");
        sb.append("    targetConf: ").append(this.toIndentedString(this.targetConf)).append("\n");
        sb.append("    satPerVbyte: ").append(this.toIndentedString(this.satPerVbyte)).append("\n");
        sb.append("    minConfs: ").append(this.toIndentedString(this.minConfs)).append("\n");
        sb.append("    spendUnconfirmed: ").append(this.toIndentedString(this.spendUnconfirmed)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

