/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcCommitmentType;

public class LnrpcBatchOpenChannel {
    public static final String SERIALIZED_NAME_NODE_PUBKEY = "node_pubkey";
    @SerializedName(value="node_pubkey")
    private byte[] nodePubkey;
    public static final String SERIALIZED_NAME_LOCAL_FUNDING_AMOUNT = "local_funding_amount";
    @SerializedName(value="local_funding_amount")
    private String localFundingAmount;
    public static final String SERIALIZED_NAME_PUSH_SAT = "push_sat";
    @SerializedName(value="push_sat")
    private String pushSat;
    public static final String SERIALIZED_NAME_PRIVATE = "private";
    @SerializedName(value="private")
    private Boolean _private;
    public static final String SERIALIZED_NAME_MIN_HTLC_MSAT = "min_htlc_msat";
    @SerializedName(value="min_htlc_msat")
    private String minHtlcMsat;
    public static final String SERIALIZED_NAME_REMOTE_CSV_DELAY = "remote_csv_delay";
    @SerializedName(value="remote_csv_delay")
    private Long remoteCsvDelay;
    public static final String SERIALIZED_NAME_CLOSE_ADDRESS = "close_address";
    @SerializedName(value="close_address")
    private String closeAddress;
    public static final String SERIALIZED_NAME_PENDING_CHAN_ID = "pending_chan_id";
    @SerializedName(value="pending_chan_id")
    private byte[] pendingChanId;
    public static final String SERIALIZED_NAME_COMMITMENT_TYPE = "commitment_type";
    @SerializedName(value="commitment_type")
    private LnrpcCommitmentType commitmentType = LnrpcCommitmentType.UNKNOWN_COMMITMENT_TYPE;

    public LnrpcBatchOpenChannel nodePubkey(byte[] nodePubkey) {
        this.nodePubkey = nodePubkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pubkey of the node to open a channel with. When using REST, this field must be encoded as base64.")
    public byte[] getNodePubkey() {
        return this.nodePubkey;
    }

    public void setNodePubkey(byte[] nodePubkey) {
        this.nodePubkey = nodePubkey;
    }

    public LnrpcBatchOpenChannel localFundingAmount(String localFundingAmount) {
        this.localFundingAmount = localFundingAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of satoshis the wallet should commit to the channel.")
    public String getLocalFundingAmount() {
        return this.localFundingAmount;
    }

    public void setLocalFundingAmount(String localFundingAmount) {
        this.localFundingAmount = localFundingAmount;
    }

    public LnrpcBatchOpenChannel pushSat(String pushSat) {
        this.pushSat = pushSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of satoshis to push to the remote side as part of the initial commitment state.")
    public String getPushSat() {
        return this.pushSat;
    }

    public void setPushSat(String pushSat) {
        this.pushSat = pushSat;
    }

    public LnrpcBatchOpenChannel _private(Boolean _private) {
        this._private = _private;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this channel should be private, not announced to the greater network.")
    public Boolean getPrivate() {
        return this._private;
    }

    public void setPrivate(Boolean _private) {
        this._private = _private;
    }

    public LnrpcBatchOpenChannel minHtlcMsat(String minHtlcMsat) {
        this.minHtlcMsat = minHtlcMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum value in millisatoshi we will require for incoming HTLCs on the channel.")
    public String getMinHtlcMsat() {
        return this.minHtlcMsat;
    }

    public void setMinHtlcMsat(String minHtlcMsat) {
        this.minHtlcMsat = minHtlcMsat;
    }

    public LnrpcBatchOpenChannel remoteCsvDelay(Long remoteCsvDelay) {
        this.remoteCsvDelay = remoteCsvDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The delay we require on the remote's commitment transaction. If this is not set, it will be scaled automatically with the channel size.")
    public Long getRemoteCsvDelay() {
        return this.remoteCsvDelay;
    }

    public void setRemoteCsvDelay(Long remoteCsvDelay) {
        this.remoteCsvDelay = remoteCsvDelay;
    }

    public LnrpcBatchOpenChannel closeAddress(String closeAddress) {
        this.closeAddress = closeAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Close address is an optional address which specifies the address to which funds should be paid out to upon cooperative close. This field may only be set if the peer supports the option upfront feature bit (call listpeers to check). The remote peer will only accept cooperative closes to this address if it is set.  Note: If this value is set on channel creation, you will *not* be able to cooperatively close out to a different address.")
    public String getCloseAddress() {
        return this.closeAddress;
    }

    public void setCloseAddress(String closeAddress) {
        this.closeAddress = closeAddress;
    }

    public LnrpcBatchOpenChannel pendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional, unique identifier of 32 random bytes that will be used as the pending channel ID to identify the channel while it is in the pre-pending state.")
    public byte[] getPendingChanId() {
        return this.pendingChanId;
    }

    public void setPendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
    }

    public LnrpcBatchOpenChannel commitmentType(LnrpcCommitmentType commitmentType) {
        this.commitmentType = commitmentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcCommitmentType getCommitmentType() {
        return this.commitmentType;
    }

    public void setCommitmentType(LnrpcCommitmentType commitmentType) {
        this.commitmentType = commitmentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcBatchOpenChannel lnrpcBatchOpenChannel = (LnrpcBatchOpenChannel)o;
        return Arrays.equals(this.nodePubkey, lnrpcBatchOpenChannel.nodePubkey) && Objects.equals(this.localFundingAmount, lnrpcBatchOpenChannel.localFundingAmount) && Objects.equals(this.pushSat, lnrpcBatchOpenChannel.pushSat) && Objects.equals(this._private, lnrpcBatchOpenChannel._private) && Objects.equals(this.minHtlcMsat, lnrpcBatchOpenChannel.minHtlcMsat) && Objects.equals(this.remoteCsvDelay, lnrpcBatchOpenChannel.remoteCsvDelay) && Objects.equals(this.closeAddress, lnrpcBatchOpenChannel.closeAddress) && Arrays.equals(this.pendingChanId, lnrpcBatchOpenChannel.pendingChanId) && Objects.equals((Object)this.commitmentType, (Object)lnrpcBatchOpenChannel.commitmentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.nodePubkey), this.localFundingAmount, this.pushSat, this._private, this.minHtlcMsat, this.remoteCsvDelay, this.closeAddress, Arrays.hashCode(this.pendingChanId), this.commitmentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcBatchOpenChannel {\n");
        sb.append("    nodePubkey: ").append(this.toIndentedString(this.nodePubkey)).append("\n");
        sb.append("    localFundingAmount: ").append(this.toIndentedString(this.localFundingAmount)).append("\n");
        sb.append("    pushSat: ").append(this.toIndentedString(this.pushSat)).append("\n");
        sb.append("    _private: ").append(this.toIndentedString(this._private)).append("\n");
        sb.append("    minHtlcMsat: ").append(this.toIndentedString(this.minHtlcMsat)).append("\n");
        sb.append("    remoteCsvDelay: ").append(this.toIndentedString(this.remoteCsvDelay)).append("\n");
        sb.append("    closeAddress: ").append(this.toIndentedString(this.closeAddress)).append("\n");
        sb.append("    pendingChanId: ").append(this.toIndentedString(this.pendingChanId)).append("\n");
        sb.append("    commitmentType: ").append(this.toIndentedString((Object)this.commitmentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

