/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcMacaroonPermission;

public class LnrpcBakeMacaroonRequest {
    public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
    @SerializedName(value="permissions")
    private List<LnrpcMacaroonPermission> permissions = null;
    public static final String SERIALIZED_NAME_ROOT_KEY_ID = "root_key_id";
    @SerializedName(value="root_key_id")
    private String rootKeyId;
    public static final String SERIALIZED_NAME_ALLOW_EXTERNAL_PERMISSIONS = "allow_external_permissions";
    @SerializedName(value="allow_external_permissions")
    private Boolean allowExternalPermissions;

    public LnrpcBakeMacaroonRequest permissions(List<LnrpcMacaroonPermission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public LnrpcBakeMacaroonRequest addPermissionsItem(LnrpcMacaroonPermission permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<LnrpcMacaroonPermission>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of permissions the new macaroon should grant.")
    public List<LnrpcMacaroonPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<LnrpcMacaroonPermission> permissions) {
        this.permissions = permissions;
    }

    public LnrpcBakeMacaroonRequest rootKeyId(String rootKeyId) {
        this.rootKeyId = rootKeyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The root key ID used to create the macaroon, must be a positive integer.")
    public String getRootKeyId() {
        return this.rootKeyId;
    }

    public void setRootKeyId(String rootKeyId) {
        this.rootKeyId = rootKeyId;
    }

    public LnrpcBakeMacaroonRequest allowExternalPermissions(Boolean allowExternalPermissions) {
        this.allowExternalPermissions = allowExternalPermissions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Informs the RPC on whether to allow external permissions that LND is not aware of.")
    public Boolean getAllowExternalPermissions() {
        return this.allowExternalPermissions;
    }

    public void setAllowExternalPermissions(Boolean allowExternalPermissions) {
        this.allowExternalPermissions = allowExternalPermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcBakeMacaroonRequest lnrpcBakeMacaroonRequest = (LnrpcBakeMacaroonRequest)o;
        return Objects.equals(this.permissions, lnrpcBakeMacaroonRequest.permissions) && Objects.equals(this.rootKeyId, lnrpcBakeMacaroonRequest.rootKeyId) && Objects.equals(this.allowExternalPermissions, lnrpcBakeMacaroonRequest.allowExternalPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.permissions, this.rootKeyId, this.allowExternalPermissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcBakeMacaroonRequest {\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    rootKeyId: ").append(this.toIndentedString(this.rootKeyId)).append("\n");
        sb.append("    allowExternalPermissions: ").append(this.toIndentedString(this.allowExternalPermissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

