/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LnrpcAliasMap {
    public static final String SERIALIZED_NAME_BASE_SCID = "base_scid";
    @SerializedName(value="base_scid")
    private String baseScid;
    public static final String SERIALIZED_NAME_ALIASES = "aliases";
    @SerializedName(value="aliases")
    private List<String> aliases = null;

    public LnrpcAliasMap baseScid(String baseScid) {
        this.baseScid = baseScid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For non-zero-conf channels, this is the confirmed SCID. Otherwise, this is the first assigned \"base\" alias.")
    public String getBaseScid() {
        return this.baseScid;
    }

    public void setBaseScid(String baseScid) {
        this.baseScid = baseScid;
    }

    public LnrpcAliasMap aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public LnrpcAliasMap addAliasesItem(String aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The set of all aliases stored for the base SCID.")
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcAliasMap lnrpcAliasMap = (LnrpcAliasMap)o;
        return Objects.equals(this.baseScid, lnrpcAliasMap.baseScid) && Objects.equals(this.aliases, lnrpcAliasMap.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.baseScid, this.aliases);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcAliasMap {\n");
        sb.append("    baseScid: ").append(this.toIndentedString(this.baseScid)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

