/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

@ApiModel(description="Details specific to AMP HTLCs.")
public class LnrpcAMP {
    public static final String SERIALIZED_NAME_ROOT_SHARE = "root_share";
    @SerializedName(value="root_share")
    private byte[] rootShare;
    public static final String SERIALIZED_NAME_SET_ID = "set_id";
    @SerializedName(value="set_id")
    private byte[] setId;
    public static final String SERIALIZED_NAME_CHILD_INDEX = "child_index";
    @SerializedName(value="child_index")
    private Long childIndex;
    public static final String SERIALIZED_NAME_HASH = "hash";
    @SerializedName(value="hash")
    private byte[] hash;
    public static final String SERIALIZED_NAME_PREIMAGE = "preimage";
    @SerializedName(value="preimage")
    private byte[] preimage;

    public LnrpcAMP rootShare(byte[] rootShare) {
        this.rootShare = rootShare;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An n-of-n secret share of the root seed from which child payment hashes and preimages are derived.")
    public byte[] getRootShare() {
        return this.rootShare;
    }

    public void setRootShare(byte[] rootShare) {
        this.rootShare = rootShare;
    }

    public LnrpcAMP setId(byte[] setId) {
        this.setId = setId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An identifier for the HTLC set that this HTLC belongs to.")
    public byte[] getSetId() {
        return this.setId;
    }

    public void setSetId(byte[] setId) {
        this.setId = setId;
    }

    public LnrpcAMP childIndex(Long childIndex) {
        this.childIndex = childIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A nonce used to randomize the child preimage and child hash from a given root_share.")
    public Long getChildIndex() {
        return this.childIndex;
    }

    public void setChildIndex(Long childIndex) {
        this.childIndex = childIndex;
    }

    public LnrpcAMP hash(byte[] hash) {
        this.hash = hash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment hash of the AMP HTLC.")
    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public LnrpcAMP preimage(byte[] preimage) {
        this.preimage = preimage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The preimage used to settle this AMP htlc. This field will only be populated if the invoice is in InvoiceState_ACCEPTED or InvoiceState_SETTLED.")
    public byte[] getPreimage() {
        return this.preimage;
    }

    public void setPreimage(byte[] preimage) {
        this.preimage = preimage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcAMP lnrpcAMP = (LnrpcAMP)o;
        return Arrays.equals(this.rootShare, lnrpcAMP.rootShare) && Arrays.equals(this.setId, lnrpcAMP.setId) && Objects.equals(this.childIndex, lnrpcAMP.childIndex) && Arrays.equals(this.hash, lnrpcAMP.hash) && Arrays.equals(this.preimage, lnrpcAMP.preimage);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.rootShare), Arrays.hashCode(this.setId), this.childIndex, Arrays.hashCode(this.hash), Arrays.hashCode(this.preimage));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcAMP {\n");
        sb.append("    rootShare: ").append(this.toIndentedString(this.rootShare)).append("\n");
        sb.append("    setId: ").append(this.toIndentedString(this.setId)).append("\n");
        sb.append("    childIndex: ").append(this.toIndentedString(this.childIndex)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    preimage: ").append(this.toIndentedString(this.preimage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

