/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcEdgeLocator;
import net.osslabz.lnd.dto.LnrpcFeatureBit;
import net.osslabz.lnd.dto.LnrpcFeeLimit;
import net.osslabz.lnd.dto.LnrpcNodePair;
import net.osslabz.lnd.dto.LnrpcRouteHint;

public class InlineObject {
    public static final String SERIALIZED_NAME_AMT_MSAT = "amt_msat";
    @SerializedName(value="amt_msat")
    private String amtMsat;
    public static final String SERIALIZED_NAME_FINAL_CLTV_DELTA = "final_cltv_delta";
    @SerializedName(value="final_cltv_delta")
    private Integer finalCltvDelta;
    public static final String SERIALIZED_NAME_FEE_LIMIT = "fee_limit";
    @SerializedName(value="fee_limit")
    private LnrpcFeeLimit feeLimit;
    public static final String SERIALIZED_NAME_IGNORED_NODES = "ignored_nodes";
    @SerializedName(value="ignored_nodes")
    private List<byte[]> ignoredNodes = null;
    public static final String SERIALIZED_NAME_IGNORED_EDGES = "ignored_edges";
    @SerializedName(value="ignored_edges")
    private List<LnrpcEdgeLocator> ignoredEdges = null;
    public static final String SERIALIZED_NAME_SOURCE_PUB_KEY = "source_pub_key";
    @SerializedName(value="source_pub_key")
    private String sourcePubKey;
    public static final String SERIALIZED_NAME_USE_MISSION_CONTROL = "use_mission_control";
    @SerializedName(value="use_mission_control")
    private Boolean useMissionControl;
    public static final String SERIALIZED_NAME_IGNORED_PAIRS = "ignored_pairs";
    @SerializedName(value="ignored_pairs")
    private List<LnrpcNodePair> ignoredPairs = null;
    public static final String SERIALIZED_NAME_CLTV_LIMIT = "cltv_limit";
    @SerializedName(value="cltv_limit")
    private Long cltvLimit;
    public static final String SERIALIZED_NAME_DEST_CUSTOM_RECORDS = "dest_custom_records";
    @SerializedName(value="dest_custom_records")
    private Map<String, byte[]> destCustomRecords = null;
    public static final String SERIALIZED_NAME_OUTGOING_CHAN_ID = "outgoing_chan_id";
    @SerializedName(value="outgoing_chan_id")
    private String outgoingChanId;
    public static final String SERIALIZED_NAME_LAST_HOP_PUBKEY = "last_hop_pubkey";
    @SerializedName(value="last_hop_pubkey")
    private byte[] lastHopPubkey;
    public static final String SERIALIZED_NAME_ROUTE_HINTS = "route_hints";
    @SerializedName(value="route_hints")
    private List<LnrpcRouteHint> routeHints = null;
    public static final String SERIALIZED_NAME_DEST_FEATURES = "dest_features";
    @SerializedName(value="dest_features")
    private List<LnrpcFeatureBit> destFeatures = null;
    public static final String SERIALIZED_NAME_TIME_PREF = "time_pref";
    @SerializedName(value="time_pref")
    private Double timePref;

    public InlineObject amtMsat(String amtMsat) {
        this.amtMsat = amtMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to send expressed in millisatoshis.  The fields amt and amt_msat are mutually exclusive.")
    public String getAmtMsat() {
        return this.amtMsat;
    }

    public void setAmtMsat(String amtMsat) {
        this.amtMsat = amtMsat;
    }

    public InlineObject finalCltvDelta(Integer finalCltvDelta) {
        this.finalCltvDelta = finalCltvDelta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional CLTV delta from the current height that should be used for the timelock of the final hop. Note that unlike SendPayment, QueryRoutes does not add any additional block padding on top of final_ctlv_delta. This padding of a few blocks needs to be added manually or otherwise failures may happen when a block comes in while the payment is in flight.")
    public Integer getFinalCltvDelta() {
        return this.finalCltvDelta;
    }

    public void setFinalCltvDelta(Integer finalCltvDelta) {
        this.finalCltvDelta = finalCltvDelta;
    }

    public InlineObject feeLimit(LnrpcFeeLimit feeLimit) {
        this.feeLimit = feeLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcFeeLimit getFeeLimit() {
        return this.feeLimit;
    }

    public void setFeeLimit(LnrpcFeeLimit feeLimit) {
        this.feeLimit = feeLimit;
    }

    public InlineObject ignoredNodes(List<byte[]> ignoredNodes) {
        this.ignoredNodes = ignoredNodes;
        return this;
    }

    public InlineObject addIgnoredNodesItem(byte[] ignoredNodesItem) {
        if (this.ignoredNodes == null) {
            this.ignoredNodes = new ArrayList<byte[]>();
        }
        this.ignoredNodes.add(ignoredNodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of nodes to ignore during path finding. When using REST, these fields must be encoded as base64.")
    public List<byte[]> getIgnoredNodes() {
        return this.ignoredNodes;
    }

    public void setIgnoredNodes(List<byte[]> ignoredNodes) {
        this.ignoredNodes = ignoredNodes;
    }

    public InlineObject ignoredEdges(List<LnrpcEdgeLocator> ignoredEdges) {
        this.ignoredEdges = ignoredEdges;
        return this;
    }

    public InlineObject addIgnoredEdgesItem(LnrpcEdgeLocator ignoredEdgesItem) {
        if (this.ignoredEdges == null) {
            this.ignoredEdges = new ArrayList<LnrpcEdgeLocator>();
        }
        this.ignoredEdges.add(ignoredEdgesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. A list of edges to ignore during path finding.")
    public List<LnrpcEdgeLocator> getIgnoredEdges() {
        return this.ignoredEdges;
    }

    public void setIgnoredEdges(List<LnrpcEdgeLocator> ignoredEdges) {
        this.ignoredEdges = ignoredEdges;
    }

    public InlineObject sourcePubKey(String sourcePubKey) {
        this.sourcePubKey = sourcePubKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source node where the request route should originated from. If empty, self is assumed.")
    public String getSourcePubKey() {
        return this.sourcePubKey;
    }

    public void setSourcePubKey(String sourcePubKey) {
        this.sourcePubKey = sourcePubKey;
    }

    public InlineObject useMissionControl(Boolean useMissionControl) {
        this.useMissionControl = useMissionControl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to true, edge probabilities from mission control will be used to get the optimal route.")
    public Boolean getUseMissionControl() {
        return this.useMissionControl;
    }

    public void setUseMissionControl(Boolean useMissionControl) {
        this.useMissionControl = useMissionControl;
    }

    public InlineObject ignoredPairs(List<LnrpcNodePair> ignoredPairs) {
        this.ignoredPairs = ignoredPairs;
        return this;
    }

    public InlineObject addIgnoredPairsItem(LnrpcNodePair ignoredPairsItem) {
        if (this.ignoredPairs == null) {
            this.ignoredPairs = new ArrayList<LnrpcNodePair>();
        }
        this.ignoredPairs.add(ignoredPairsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of directed node pairs that will be ignored during path finding.")
    public List<LnrpcNodePair> getIgnoredPairs() {
        return this.ignoredPairs;
    }

    public void setIgnoredPairs(List<LnrpcNodePair> ignoredPairs) {
        this.ignoredPairs = ignoredPairs;
    }

    public InlineObject cltvLimit(Long cltvLimit) {
        this.cltvLimit = cltvLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional maximum total time lock for the route. If the source is empty or ourselves, this should not exceed lnd's `--max-cltv-expiry` setting. If zero, then the value of `--max-cltv-expiry` is used as the limit.")
    public Long getCltvLimit() {
        return this.cltvLimit;
    }

    public void setCltvLimit(Long cltvLimit) {
        this.cltvLimit = cltvLimit;
    }

    public InlineObject destCustomRecords(Map<String, byte[]> destCustomRecords) {
        this.destCustomRecords = destCustomRecords;
        return this;
    }

    public InlineObject putDestCustomRecordsItem(String key, byte[] destCustomRecordsItem) {
        if (this.destCustomRecords == null) {
            this.destCustomRecords = new HashMap<String, byte[]>();
        }
        this.destCustomRecords.put(key, destCustomRecordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional field that can be used to pass an arbitrary set of TLV records to a peer which understands the new records. This can be used to pass application specific data during the payment attempt. If the destination does not support the specified records, an error will be returned. Record types are required to be in the custom range >= 65536. When using REST, the values must be encoded as base64.")
    public Map<String, byte[]> getDestCustomRecords() {
        return this.destCustomRecords;
    }

    public void setDestCustomRecords(Map<String, byte[]> destCustomRecords) {
        this.destCustomRecords = destCustomRecords;
    }

    public InlineObject outgoingChanId(String outgoingChanId) {
        this.outgoingChanId = outgoingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The channel id of the channel that must be taken to the first hop. If zero, any channel may be used.")
    public String getOutgoingChanId() {
        return this.outgoingChanId;
    }

    public void setOutgoingChanId(String outgoingChanId) {
        this.outgoingChanId = outgoingChanId;
    }

    public InlineObject lastHopPubkey(byte[] lastHopPubkey) {
        this.lastHopPubkey = lastHopPubkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pubkey of the last hop of the route. If empty, any hop may be used.")
    public byte[] getLastHopPubkey() {
        return this.lastHopPubkey;
    }

    public void setLastHopPubkey(byte[] lastHopPubkey) {
        this.lastHopPubkey = lastHopPubkey;
    }

    public InlineObject routeHints(List<LnrpcRouteHint> routeHints) {
        this.routeHints = routeHints;
        return this;
    }

    public InlineObject addRouteHintsItem(LnrpcRouteHint routeHintsItem) {
        if (this.routeHints == null) {
            this.routeHints = new ArrayList<LnrpcRouteHint>();
        }
        this.routeHints.add(routeHintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional route hints to reach the destination through private channels.")
    public List<LnrpcRouteHint> getRouteHints() {
        return this.routeHints;
    }

    public void setRouteHints(List<LnrpcRouteHint> routeHints) {
        this.routeHints = routeHints;
    }

    public InlineObject destFeatures(List<LnrpcFeatureBit> destFeatures) {
        this.destFeatures = destFeatures;
        return this;
    }

    public InlineObject addDestFeaturesItem(LnrpcFeatureBit destFeaturesItem) {
        if (this.destFeatures == null) {
            this.destFeatures = new ArrayList<LnrpcFeatureBit>();
        }
        this.destFeatures.add(destFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Features assumed to be supported by the final node. All transitive feature dependencies must also be set properly. For a given feature bit pair, either optional or remote may be set, but not both. If this field is nil or empty, the router will try to load destination features from the graph as a fallback.")
    public List<LnrpcFeatureBit> getDestFeatures() {
        return this.destFeatures;
    }

    public void setDestFeatures(List<LnrpcFeatureBit> destFeatures) {
        this.destFeatures = destFeatures;
    }

    public InlineObject timePref(Double timePref) {
        this.timePref = timePref;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time preference for this payment. Set to -1 to optimize for fees only, to 1 to optimize for reliability only or a value inbetween for a mix.")
    public Double getTimePref() {
        return this.timePref;
    }

    public void setTimePref(Double timePref) {
        this.timePref = timePref;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineObject inlineObject = (InlineObject)o;
        return Objects.equals(this.amtMsat, inlineObject.amtMsat) && Objects.equals(this.finalCltvDelta, inlineObject.finalCltvDelta) && Objects.equals(this.feeLimit, inlineObject.feeLimit) && Objects.equals(this.ignoredNodes, inlineObject.ignoredNodes) && Objects.equals(this.ignoredEdges, inlineObject.ignoredEdges) && Objects.equals(this.sourcePubKey, inlineObject.sourcePubKey) && Objects.equals(this.useMissionControl, inlineObject.useMissionControl) && Objects.equals(this.ignoredPairs, inlineObject.ignoredPairs) && Objects.equals(this.cltvLimit, inlineObject.cltvLimit) && Objects.equals(this.destCustomRecords, inlineObject.destCustomRecords) && Objects.equals(this.outgoingChanId, inlineObject.outgoingChanId) && Arrays.equals(this.lastHopPubkey, inlineObject.lastHopPubkey) && Objects.equals(this.routeHints, inlineObject.routeHints) && Objects.equals(this.destFeatures, inlineObject.destFeatures) && Objects.equals(this.timePref, inlineObject.timePref);
    }

    public int hashCode() {
        return Objects.hash(this.amtMsat, this.finalCltvDelta, this.feeLimit, this.ignoredNodes, this.ignoredEdges, this.sourcePubKey, this.useMissionControl, this.ignoredPairs, this.cltvLimit, this.destCustomRecords, this.outgoingChanId, Arrays.hashCode(this.lastHopPubkey), this.routeHints, this.destFeatures, this.timePref);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineObject {\n");
        sb.append("    amtMsat: ").append(this.toIndentedString(this.amtMsat)).append("\n");
        sb.append("    finalCltvDelta: ").append(this.toIndentedString(this.finalCltvDelta)).append("\n");
        sb.append("    feeLimit: ").append(this.toIndentedString(this.feeLimit)).append("\n");
        sb.append("    ignoredNodes: ").append(this.toIndentedString(this.ignoredNodes)).append("\n");
        sb.append("    ignoredEdges: ").append(this.toIndentedString(this.ignoredEdges)).append("\n");
        sb.append("    sourcePubKey: ").append(this.toIndentedString(this.sourcePubKey)).append("\n");
        sb.append("    useMissionControl: ").append(this.toIndentedString(this.useMissionControl)).append("\n");
        sb.append("    ignoredPairs: ").append(this.toIndentedString(this.ignoredPairs)).append("\n");
        sb.append("    cltvLimit: ").append(this.toIndentedString(this.cltvLimit)).append("\n");
        sb.append("    destCustomRecords: ").append(this.toIndentedString(this.destCustomRecords)).append("\n");
        sb.append("    outgoingChanId: ").append(this.toIndentedString(this.outgoingChanId)).append("\n");
        sb.append("    lastHopPubkey: ").append(this.toIndentedString(this.lastHopPubkey)).append("\n");
        sb.append("    routeHints: ").append(this.toIndentedString(this.routeHints)).append("\n");
        sb.append("    destFeatures: ").append(this.toIndentedString(this.destFeatures)).append("\n");
        sb.append("    timePref: ").append(this.toIndentedString(this.timePref)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

