/*
 * lightning.proto
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: version not set
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.osslabz.lnd.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.osslabz.lnd.dto.LnrpcHop;

/**
 * A path through the channel graph which runs over one or more channels in succession. This struct carries all the information required to craft the Sphinx onion packet, and send the payment along the first hop in the path. A route is only selected as valid if all the channels have sufficient capacity to carry the initial payment amount after fees are accounted for.
 */
@ApiModel(description = "A path through the channel graph which runs over one or more channels in succession. This struct carries all the information required to craft the Sphinx onion packet, and send the payment along the first hop in the path. A route is only selected as valid if all the channels have sufficient capacity to carry the initial payment amount after fees are accounted for.")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-07T12:03:34.958542131Z[Etc/UTC]")
public class LnrpcRoute {
  public static final String SERIALIZED_NAME_TOTAL_TIME_LOCK = "total_time_lock";
  @SerializedName(SERIALIZED_NAME_TOTAL_TIME_LOCK)
  private Long totalTimeLock;

  public static final String SERIALIZED_NAME_TOTAL_FEES = "total_fees";
  @SerializedName(SERIALIZED_NAME_TOTAL_FEES)
  private String totalFees;

  public static final String SERIALIZED_NAME_TOTAL_AMT = "total_amt";
  @SerializedName(SERIALIZED_NAME_TOTAL_AMT)
  private String totalAmt;

  public static final String SERIALIZED_NAME_HOPS = "hops";
  @SerializedName(SERIALIZED_NAME_HOPS)
  private List<LnrpcHop> hops = null;

  public static final String SERIALIZED_NAME_TOTAL_FEES_MSAT = "total_fees_msat";
  @SerializedName(SERIALIZED_NAME_TOTAL_FEES_MSAT)
  private String totalFeesMsat;

  public static final String SERIALIZED_NAME_TOTAL_AMT_MSAT = "total_amt_msat";
  @SerializedName(SERIALIZED_NAME_TOTAL_AMT_MSAT)
  private String totalAmtMsat;

  public LnrpcRoute() { 
  }

  public LnrpcRoute totalTimeLock(Long totalTimeLock) {
    
    this.totalTimeLock = totalTimeLock;
    return this;
  }

   /**
   * The cumulative (final) time lock across the entire route. This is the CLTV value that should be extended to the first hop in the route. All other hops will decrement the time-lock as advertised, leaving enough time for all hops to wait for or present the payment preimage to complete the payment.
   * @return totalTimeLock
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The cumulative (final) time lock across the entire route. This is the CLTV value that should be extended to the first hop in the route. All other hops will decrement the time-lock as advertised, leaving enough time for all hops to wait for or present the payment preimage to complete the payment.")

  public Long getTotalTimeLock() {
    return totalTimeLock;
  }


  public void setTotalTimeLock(Long totalTimeLock) {
    this.totalTimeLock = totalTimeLock;
  }


  public LnrpcRoute totalFees(String totalFees) {
    
    this.totalFees = totalFees;
    return this;
  }

   /**
   * The sum of the fees paid at each hop within the final route. In the case of a one-hop payment, this value will be zero as we don&#39;t need to pay a fee to ourselves.
   * @return totalFees
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The sum of the fees paid at each hop within the final route. In the case of a one-hop payment, this value will be zero as we don't need to pay a fee to ourselves.")

  public String getTotalFees() {
    return totalFees;
  }


  public void setTotalFees(String totalFees) {
    this.totalFees = totalFees;
  }


  public LnrpcRoute totalAmt(String totalAmt) {
    
    this.totalAmt = totalAmt;
    return this;
  }

   /**
   * The total amount of funds required to complete a payment over this route. This value includes the cumulative fees at each hop. As a result, the HTLC extended to the first-hop in the route will need to have at least this many satoshis, otherwise the route will fail at an intermediate node due to an insufficient amount of fees.
   * @return totalAmt
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The total amount of funds required to complete a payment over this route. This value includes the cumulative fees at each hop. As a result, the HTLC extended to the first-hop in the route will need to have at least this many satoshis, otherwise the route will fail at an intermediate node due to an insufficient amount of fees.")

  public String getTotalAmt() {
    return totalAmt;
  }


  public void setTotalAmt(String totalAmt) {
    this.totalAmt = totalAmt;
  }


  public LnrpcRoute hops(List<LnrpcHop> hops) {
    
    this.hops = hops;
    return this;
  }

  public LnrpcRoute addHopsItem(LnrpcHop hopsItem) {
    if (this.hops == null) {
      this.hops = new ArrayList<>();
    }
    this.hops.add(hopsItem);
    return this;
  }

   /**
   * Contains details concerning the specific forwarding details at each hop.
   * @return hops
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Contains details concerning the specific forwarding details at each hop.")

  public List<LnrpcHop> getHops() {
    return hops;
  }


  public void setHops(List<LnrpcHop> hops) {
    this.hops = hops;
  }


  public LnrpcRoute totalFeesMsat(String totalFeesMsat) {
    
    this.totalFeesMsat = totalFeesMsat;
    return this;
  }

   /**
   * The total fees in millisatoshis.
   * @return totalFeesMsat
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The total fees in millisatoshis.")

  public String getTotalFeesMsat() {
    return totalFeesMsat;
  }


  public void setTotalFeesMsat(String totalFeesMsat) {
    this.totalFeesMsat = totalFeesMsat;
  }


  public LnrpcRoute totalAmtMsat(String totalAmtMsat) {
    
    this.totalAmtMsat = totalAmtMsat;
    return this;
  }

   /**
   * The total amount in millisatoshis.
   * @return totalAmtMsat
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The total amount in millisatoshis.")

  public String getTotalAmtMsat() {
    return totalAmtMsat;
  }


  public void setTotalAmtMsat(String totalAmtMsat) {
    this.totalAmtMsat = totalAmtMsat;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LnrpcRoute lnrpcRoute = (LnrpcRoute) o;
    return Objects.equals(this.totalTimeLock, lnrpcRoute.totalTimeLock) &&
        Objects.equals(this.totalFees, lnrpcRoute.totalFees) &&
        Objects.equals(this.totalAmt, lnrpcRoute.totalAmt) &&
        Objects.equals(this.hops, lnrpcRoute.hops) &&
        Objects.equals(this.totalFeesMsat, lnrpcRoute.totalFeesMsat) &&
        Objects.equals(this.totalAmtMsat, lnrpcRoute.totalAmtMsat);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalTimeLock, totalFees, totalAmt, hops, totalFeesMsat, totalAmtMsat);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LnrpcRoute {\n");
    sb.append("    totalTimeLock: ").append(toIndentedString(totalTimeLock)).append("\n");
    sb.append("    totalFees: ").append(toIndentedString(totalFees)).append("\n");
    sb.append("    totalAmt: ").append(toIndentedString(totalAmt)).append("\n");
    sb.append("    hops: ").append(toIndentedString(hops)).append("\n");
    sb.append("    totalFeesMsat: ").append(toIndentedString(totalFeesMsat)).append("\n");
    sb.append("    totalAmtMsat: ").append(toIndentedString(totalAmtMsat)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

