/*
 * invoicesrpc/invoices.proto
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: version not set
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.osslabz.lnd.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osslabz.lnd.dto.InvoiceInvoiceState;
import net.osslabz.lnd.dto.LnrpcAMPInvoiceState;
import net.osslabz.lnd.dto.LnrpcFeature;
import net.osslabz.lnd.dto.LnrpcInvoiceHTLC;
import net.osslabz.lnd.dto.LnrpcRouteHint;

/**
 * LnrpcInvoice
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-07T12:03:38.664532692Z[Etc/UTC]")
public class LnrpcInvoice {
  public static final String SERIALIZED_NAME_MEMO = "memo";
  @SerializedName(SERIALIZED_NAME_MEMO)
  private String memo;

  public static final String SERIALIZED_NAME_R_PREIMAGE = "r_preimage";
  @SerializedName(SERIALIZED_NAME_R_PREIMAGE)
  private byte[] rPreimage;

  public static final String SERIALIZED_NAME_R_HASH = "r_hash";
  @SerializedName(SERIALIZED_NAME_R_HASH)
  private byte[] rHash;

  public static final String SERIALIZED_NAME_VALUE = "value";
  @SerializedName(SERIALIZED_NAME_VALUE)
  private String value;

  public static final String SERIALIZED_NAME_VALUE_MSAT = "value_msat";
  @SerializedName(SERIALIZED_NAME_VALUE_MSAT)
  private String valueMsat;

  public static final String SERIALIZED_NAME_SETTLED = "settled";
  @SerializedName(SERIALIZED_NAME_SETTLED)
  private Boolean settled;

  public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
  @SerializedName(SERIALIZED_NAME_CREATION_DATE)
  private String creationDate;

  public static final String SERIALIZED_NAME_SETTLE_DATE = "settle_date";
  @SerializedName(SERIALIZED_NAME_SETTLE_DATE)
  private String settleDate;

  public static final String SERIALIZED_NAME_PAYMENT_REQUEST = "payment_request";
  @SerializedName(SERIALIZED_NAME_PAYMENT_REQUEST)
  private String paymentRequest;

  public static final String SERIALIZED_NAME_DESCRIPTION_HASH = "description_hash";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION_HASH)
  private byte[] descriptionHash;

  public static final String SERIALIZED_NAME_EXPIRY = "expiry";
  @SerializedName(SERIALIZED_NAME_EXPIRY)
  private String expiry;

  public static final String SERIALIZED_NAME_FALLBACK_ADDR = "fallback_addr";
  @SerializedName(SERIALIZED_NAME_FALLBACK_ADDR)
  private String fallbackAddr;

  public static final String SERIALIZED_NAME_CLTV_EXPIRY = "cltv_expiry";
  @SerializedName(SERIALIZED_NAME_CLTV_EXPIRY)
  private String cltvExpiry;

  public static final String SERIALIZED_NAME_ROUTE_HINTS = "route_hints";
  @SerializedName(SERIALIZED_NAME_ROUTE_HINTS)
  private List<LnrpcRouteHint> routeHints = null;

  public static final String SERIALIZED_NAME_PRIVATE = "private";
  @SerializedName(SERIALIZED_NAME_PRIVATE)
  private Boolean _private;

  public static final String SERIALIZED_NAME_ADD_INDEX = "add_index";
  @SerializedName(SERIALIZED_NAME_ADD_INDEX)
  private String addIndex;

  public static final String SERIALIZED_NAME_SETTLE_INDEX = "settle_index";
  @SerializedName(SERIALIZED_NAME_SETTLE_INDEX)
  private String settleIndex;

  public static final String SERIALIZED_NAME_AMT_PAID = "amt_paid";
  @SerializedName(SERIALIZED_NAME_AMT_PAID)
  private String amtPaid;

  public static final String SERIALIZED_NAME_AMT_PAID_SAT = "amt_paid_sat";
  @SerializedName(SERIALIZED_NAME_AMT_PAID_SAT)
  private String amtPaidSat;

  public static final String SERIALIZED_NAME_AMT_PAID_MSAT = "amt_paid_msat";
  @SerializedName(SERIALIZED_NAME_AMT_PAID_MSAT)
  private String amtPaidMsat;

  public static final String SERIALIZED_NAME_STATE = "state";
  @SerializedName(SERIALIZED_NAME_STATE)
  private InvoiceInvoiceState state = InvoiceInvoiceState.OPEN;

  public static final String SERIALIZED_NAME_HTLCS = "htlcs";
  @SerializedName(SERIALIZED_NAME_HTLCS)
  private List<LnrpcInvoiceHTLC> htlcs = null;

  public static final String SERIALIZED_NAME_FEATURES = "features";
  @SerializedName(SERIALIZED_NAME_FEATURES)
  private Map<String, LnrpcFeature> features = null;

  public static final String SERIALIZED_NAME_IS_KEYSEND = "is_keysend";
  @SerializedName(SERIALIZED_NAME_IS_KEYSEND)
  private Boolean isKeysend;

  public static final String SERIALIZED_NAME_PAYMENT_ADDR = "payment_addr";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ADDR)
  private byte[] paymentAddr;

  public static final String SERIALIZED_NAME_IS_AMP = "is_amp";
  @SerializedName(SERIALIZED_NAME_IS_AMP)
  private Boolean isAmp;

  public static final String SERIALIZED_NAME_AMP_INVOICE_STATE = "amp_invoice_state";
  @SerializedName(SERIALIZED_NAME_AMP_INVOICE_STATE)
  private Map<String, LnrpcAMPInvoiceState> ampInvoiceState = null;

  public LnrpcInvoice() { 
  }

  public LnrpcInvoice memo(String memo) {
    
    this.memo = memo;
    return this;
  }

   /**
   * An optional memo to attach along with the invoice. Used for record keeping purposes for the invoice&#39;s creator, and will also be set in the description field of the encoded payment request if the description_hash field is not being used.
   * @return memo
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "An optional memo to attach along with the invoice. Used for record keeping purposes for the invoice's creator, and will also be set in the description field of the encoded payment request if the description_hash field is not being used.")

  public String getMemo() {
    return memo;
  }


  public void setMemo(String memo) {
    this.memo = memo;
  }


  public LnrpcInvoice rPreimage(byte[] rPreimage) {
    
    this.rPreimage = rPreimage;
    return this;
  }

   /**
   * The hex-encoded preimage (32 byte) which will allow settling an incoming HTLC payable to this preimage. When using REST, this field must be encoded as base64.
   * @return rPreimage
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The hex-encoded preimage (32 byte) which will allow settling an incoming HTLC payable to this preimage. When using REST, this field must be encoded as base64.")

  public byte[] getrPreimage() {
    return rPreimage;
  }


  public void setrPreimage(byte[] rPreimage) {
    this.rPreimage = rPreimage;
  }


  public LnrpcInvoice rHash(byte[] rHash) {
    
    this.rHash = rHash;
    return this;
  }

   /**
   * The hash of the preimage. When using REST, this field must be encoded as base64. Note: Output only, don&#39;t specify for creating an invoice.
   * @return rHash
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The hash of the preimage. When using REST, this field must be encoded as base64. Note: Output only, don't specify for creating an invoice.")

  public byte[] getrHash() {
    return rHash;
  }


  public void setrHash(byte[] rHash) {
    this.rHash = rHash;
  }


  public LnrpcInvoice value(String value) {
    
    this.value = value;
    return this;
  }

   /**
   * The fields value and value_msat are mutually exclusive.
   * @return value
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The fields value and value_msat are mutually exclusive.")

  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }


  public LnrpcInvoice valueMsat(String valueMsat) {
    
    this.valueMsat = valueMsat;
    return this;
  }

   /**
   * The fields value and value_msat are mutually exclusive.
   * @return valueMsat
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The fields value and value_msat are mutually exclusive.")

  public String getValueMsat() {
    return valueMsat;
  }


  public void setValueMsat(String valueMsat) {
    this.valueMsat = valueMsat;
  }


  public LnrpcInvoice settled(Boolean settled) {
    
    this.settled = settled;
    return this;
  }

   /**
   * Whether this invoice has been fulfilled.  The field is deprecated. Use the state field instead (compare to SETTLED).
   * @return settled
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Whether this invoice has been fulfilled.  The field is deprecated. Use the state field instead (compare to SETTLED).")

  public Boolean getSettled() {
    return settled;
  }


  public void setSettled(Boolean settled) {
    this.settled = settled;
  }


  public LnrpcInvoice creationDate(String creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * When this invoice was created. Measured in seconds since the unix epoch. Note: Output only, don&#39;t specify for creating an invoice.
   * @return creationDate
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "When this invoice was created. Measured in seconds since the unix epoch. Note: Output only, don't specify for creating an invoice.")

  public String getCreationDate() {
    return creationDate;
  }


  public void setCreationDate(String creationDate) {
    this.creationDate = creationDate;
  }


  public LnrpcInvoice settleDate(String settleDate) {
    
    this.settleDate = settleDate;
    return this;
  }

   /**
   * When this invoice was settled. Measured in seconds since the unix epoch. Note: Output only, don&#39;t specify for creating an invoice.
   * @return settleDate
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "When this invoice was settled. Measured in seconds since the unix epoch. Note: Output only, don't specify for creating an invoice.")

  public String getSettleDate() {
    return settleDate;
  }


  public void setSettleDate(String settleDate) {
    this.settleDate = settleDate;
  }


  public LnrpcInvoice paymentRequest(String paymentRequest) {
    
    this.paymentRequest = paymentRequest;
    return this;
  }

   /**
   * A bare-bones invoice for a payment within the Lightning Network. With the details of the invoice, the sender has all the data necessary to send a payment to the recipient. Note: Output only, don&#39;t specify for creating an invoice.
   * @return paymentRequest
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "A bare-bones invoice for a payment within the Lightning Network. With the details of the invoice, the sender has all the data necessary to send a payment to the recipient. Note: Output only, don't specify for creating an invoice.")

  public String getPaymentRequest() {
    return paymentRequest;
  }


  public void setPaymentRequest(String paymentRequest) {
    this.paymentRequest = paymentRequest;
  }


  public LnrpcInvoice descriptionHash(byte[] descriptionHash) {
    
    this.descriptionHash = descriptionHash;
    return this;
  }

   /**
   * Hash (SHA-256) of a description of the payment. Used if the description of payment (memo) is too long to naturally fit within the description field of an encoded payment request. When using REST, this field must be encoded as base64.
   * @return descriptionHash
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Hash (SHA-256) of a description of the payment. Used if the description of payment (memo) is too long to naturally fit within the description field of an encoded payment request. When using REST, this field must be encoded as base64.")

  public byte[] getDescriptionHash() {
    return descriptionHash;
  }


  public void setDescriptionHash(byte[] descriptionHash) {
    this.descriptionHash = descriptionHash;
  }


  public LnrpcInvoice expiry(String expiry) {
    
    this.expiry = expiry;
    return this;
  }

   /**
   * Payment request expiry time in seconds. Default is 86400 (24 hours).
   * @return expiry
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Payment request expiry time in seconds. Default is 86400 (24 hours).")

  public String getExpiry() {
    return expiry;
  }


  public void setExpiry(String expiry) {
    this.expiry = expiry;
  }


  public LnrpcInvoice fallbackAddr(String fallbackAddr) {
    
    this.fallbackAddr = fallbackAddr;
    return this;
  }

   /**
   * Fallback on-chain address.
   * @return fallbackAddr
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Fallback on-chain address.")

  public String getFallbackAddr() {
    return fallbackAddr;
  }


  public void setFallbackAddr(String fallbackAddr) {
    this.fallbackAddr = fallbackAddr;
  }


  public LnrpcInvoice cltvExpiry(String cltvExpiry) {
    
    this.cltvExpiry = cltvExpiry;
    return this;
  }

   /**
   * Delta to use for the time-lock of the CLTV extended to the final hop.
   * @return cltvExpiry
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Delta to use for the time-lock of the CLTV extended to the final hop.")

  public String getCltvExpiry() {
    return cltvExpiry;
  }


  public void setCltvExpiry(String cltvExpiry) {
    this.cltvExpiry = cltvExpiry;
  }


  public LnrpcInvoice routeHints(List<LnrpcRouteHint> routeHints) {
    
    this.routeHints = routeHints;
    return this;
  }

  public LnrpcInvoice addRouteHintsItem(LnrpcRouteHint routeHintsItem) {
    if (this.routeHints == null) {
      this.routeHints = new ArrayList<>();
    }
    this.routeHints.add(routeHintsItem);
    return this;
  }

   /**
   * Route hints that can each be individually used to assist in reaching the invoice&#39;s destination.
   * @return routeHints
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Route hints that can each be individually used to assist in reaching the invoice's destination.")

  public List<LnrpcRouteHint> getRouteHints() {
    return routeHints;
  }


  public void setRouteHints(List<LnrpcRouteHint> routeHints) {
    this.routeHints = routeHints;
  }


  public LnrpcInvoice _private(Boolean _private) {
    
    this._private = _private;
    return this;
  }

   /**
   * Whether this invoice should include routing hints for private channels. Note: When enabled, if value and value_msat are zero, a large number of hints with these channels can be included, which might not be desirable.
   * @return _private
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Whether this invoice should include routing hints for private channels. Note: When enabled, if value and value_msat are zero, a large number of hints with these channels can be included, which might not be desirable.")

  public Boolean getPrivate() {
    return _private;
  }


  public void setPrivate(Boolean _private) {
    this._private = _private;
  }


  public LnrpcInvoice addIndex(String addIndex) {
    
    this.addIndex = addIndex;
    return this;
  }

   /**
   * The \&quot;add\&quot; index of this invoice. Each newly created invoice will increment this index making it monotonically increasing. Callers to the SubscribeInvoices call can use this to instantly get notified of all added invoices with an add_index greater than this one. Note: Output only, don&#39;t specify for creating an invoice.
   * @return addIndex
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The \"add\" index of this invoice. Each newly created invoice will increment this index making it monotonically increasing. Callers to the SubscribeInvoices call can use this to instantly get notified of all added invoices with an add_index greater than this one. Note: Output only, don't specify for creating an invoice.")

  public String getAddIndex() {
    return addIndex;
  }


  public void setAddIndex(String addIndex) {
    this.addIndex = addIndex;
  }


  public LnrpcInvoice settleIndex(String settleIndex) {
    
    this.settleIndex = settleIndex;
    return this;
  }

   /**
   * The \&quot;settle\&quot; index of this invoice. Each newly settled invoice will increment this index making it monotonically increasing. Callers to the SubscribeInvoices call can use this to instantly get notified of all settled invoices with an settle_index greater than this one. Note: Output only, don&#39;t specify for creating an invoice.
   * @return settleIndex
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The \"settle\" index of this invoice. Each newly settled invoice will increment this index making it monotonically increasing. Callers to the SubscribeInvoices call can use this to instantly get notified of all settled invoices with an settle_index greater than this one. Note: Output only, don't specify for creating an invoice.")

  public String getSettleIndex() {
    return settleIndex;
  }


  public void setSettleIndex(String settleIndex) {
    this.settleIndex = settleIndex;
  }


  public LnrpcInvoice amtPaid(String amtPaid) {
    
    this.amtPaid = amtPaid;
    return this;
  }

   /**
   * Deprecated, use amt_paid_sat or amt_paid_msat.
   * @return amtPaid
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Deprecated, use amt_paid_sat or amt_paid_msat.")

  public String getAmtPaid() {
    return amtPaid;
  }


  public void setAmtPaid(String amtPaid) {
    this.amtPaid = amtPaid;
  }


  public LnrpcInvoice amtPaidSat(String amtPaidSat) {
    
    this.amtPaidSat = amtPaidSat;
    return this;
  }

   /**
   * The amount that was accepted for this invoice, in satoshis. This will ONLY be set if this invoice has been settled. We provide this field as if the invoice was created with a zero value, then we need to record what amount was ultimately accepted. Additionally, it&#39;s possible that the sender paid MORE that was specified in the original invoice. So we&#39;ll record that here as well. Note: Output only, don&#39;t specify for creating an invoice.
   * @return amtPaidSat
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The amount that was accepted for this invoice, in satoshis. This will ONLY be set if this invoice has been settled. We provide this field as if the invoice was created with a zero value, then we need to record what amount was ultimately accepted. Additionally, it's possible that the sender paid MORE that was specified in the original invoice. So we'll record that here as well. Note: Output only, don't specify for creating an invoice.")

  public String getAmtPaidSat() {
    return amtPaidSat;
  }


  public void setAmtPaidSat(String amtPaidSat) {
    this.amtPaidSat = amtPaidSat;
  }


  public LnrpcInvoice amtPaidMsat(String amtPaidMsat) {
    
    this.amtPaidMsat = amtPaidMsat;
    return this;
  }

   /**
   * The amount that was accepted for this invoice, in millisatoshis. This will ONLY be set if this invoice has been settled. We provide this field as if the invoice was created with a zero value, then we need to record what amount was ultimately accepted. Additionally, it&#39;s possible that the sender paid MORE that was specified in the original invoice. So we&#39;ll record that here as well. Note: Output only, don&#39;t specify for creating an invoice.
   * @return amtPaidMsat
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The amount that was accepted for this invoice, in millisatoshis. This will ONLY be set if this invoice has been settled. We provide this field as if the invoice was created with a zero value, then we need to record what amount was ultimately accepted. Additionally, it's possible that the sender paid MORE that was specified in the original invoice. So we'll record that here as well. Note: Output only, don't specify for creating an invoice.")

  public String getAmtPaidMsat() {
    return amtPaidMsat;
  }


  public void setAmtPaidMsat(String amtPaidMsat) {
    this.amtPaidMsat = amtPaidMsat;
  }


  public LnrpcInvoice state(InvoiceInvoiceState state) {
    
    this.state = state;
    return this;
  }

   /**
   * Get state
   * @return state
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "")

  public InvoiceInvoiceState getState() {
    return state;
  }


  public void setState(InvoiceInvoiceState state) {
    this.state = state;
  }


  public LnrpcInvoice htlcs(List<LnrpcInvoiceHTLC> htlcs) {
    
    this.htlcs = htlcs;
    return this;
  }

  public LnrpcInvoice addHtlcsItem(LnrpcInvoiceHTLC htlcsItem) {
    if (this.htlcs == null) {
      this.htlcs = new ArrayList<>();
    }
    this.htlcs.add(htlcsItem);
    return this;
  }

   /**
   * List of HTLCs paying to this invoice [EXPERIMENTAL]. Note: Output only, don&#39;t specify for creating an invoice.
   * @return htlcs
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "List of HTLCs paying to this invoice [EXPERIMENTAL]. Note: Output only, don't specify for creating an invoice.")

  public List<LnrpcInvoiceHTLC> getHtlcs() {
    return htlcs;
  }


  public void setHtlcs(List<LnrpcInvoiceHTLC> htlcs) {
    this.htlcs = htlcs;
  }


  public LnrpcInvoice features(Map<String, LnrpcFeature> features) {
    
    this.features = features;
    return this;
  }

  public LnrpcInvoice putFeaturesItem(String key, LnrpcFeature featuresItem) {
    if (this.features == null) {
      this.features = new HashMap<>();
    }
    this.features.put(key, featuresItem);
    return this;
  }

   /**
   * List of features advertised on the invoice. Note: Output only, don&#39;t specify for creating an invoice.
   * @return features
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "List of features advertised on the invoice. Note: Output only, don't specify for creating an invoice.")

  public Map<String, LnrpcFeature> getFeatures() {
    return features;
  }


  public void setFeatures(Map<String, LnrpcFeature> features) {
    this.features = features;
  }


  public LnrpcInvoice isKeysend(Boolean isKeysend) {
    
    this.isKeysend = isKeysend;
    return this;
  }

   /**
   * Indicates if this invoice was a spontaneous payment that arrived via keysend [EXPERIMENTAL]. Note: Output only, don&#39;t specify for creating an invoice.
   * @return isKeysend
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Indicates if this invoice was a spontaneous payment that arrived via keysend [EXPERIMENTAL]. Note: Output only, don't specify for creating an invoice.")

  public Boolean getIsKeysend() {
    return isKeysend;
  }


  public void setIsKeysend(Boolean isKeysend) {
    this.isKeysend = isKeysend;
  }


  public LnrpcInvoice paymentAddr(byte[] paymentAddr) {
    
    this.paymentAddr = paymentAddr;
    return this;
  }

   /**
   * The payment address of this invoice. This value will be used in MPP payments, and also for newer invoices that always require the MPP payload for added end-to-end security. Note: Output only, don&#39;t specify for creating an invoice.
   * @return paymentAddr
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The payment address of this invoice. This value will be used in MPP payments, and also for newer invoices that always require the MPP payload for added end-to-end security. Note: Output only, don't specify for creating an invoice.")

  public byte[] getPaymentAddr() {
    return paymentAddr;
  }


  public void setPaymentAddr(byte[] paymentAddr) {
    this.paymentAddr = paymentAddr;
  }


  public LnrpcInvoice isAmp(Boolean isAmp) {
    
    this.isAmp = isAmp;
    return this;
  }

   /**
   * Signals whether or not this is an AMP invoice.
   * @return isAmp
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Signals whether or not this is an AMP invoice.")

  public Boolean getIsAmp() {
    return isAmp;
  }


  public void setIsAmp(Boolean isAmp) {
    this.isAmp = isAmp;
  }


  public LnrpcInvoice ampInvoiceState(Map<String, LnrpcAMPInvoiceState> ampInvoiceState) {
    
    this.ampInvoiceState = ampInvoiceState;
    return this;
  }

  public LnrpcInvoice putAmpInvoiceStateItem(String key, LnrpcAMPInvoiceState ampInvoiceStateItem) {
    if (this.ampInvoiceState == null) {
      this.ampInvoiceState = new HashMap<>();
    }
    this.ampInvoiceState.put(key, ampInvoiceStateItem);
    return this;
  }

   /**
   * Maps a 32-byte hex-encoded set ID to the sub-invoice AMP state for the given set ID. This field is always populated for AMP invoices, and can be used along side LookupInvoice to obtain the HTLC information related to a given sub-invoice. Note: Output only, don&#39;t specify for creating an invoice.
   * @return ampInvoiceState
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Maps a 32-byte hex-encoded set ID to the sub-invoice AMP state for the given set ID. This field is always populated for AMP invoices, and can be used along side LookupInvoice to obtain the HTLC information related to a given sub-invoice. Note: Output only, don't specify for creating an invoice.")

  public Map<String, LnrpcAMPInvoiceState> getAmpInvoiceState() {
    return ampInvoiceState;
  }


  public void setAmpInvoiceState(Map<String, LnrpcAMPInvoiceState> ampInvoiceState) {
    this.ampInvoiceState = ampInvoiceState;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LnrpcInvoice lnrpcInvoice = (LnrpcInvoice) o;
    return Objects.equals(this.memo, lnrpcInvoice.memo) &&
        Arrays.equals(this.rPreimage, lnrpcInvoice.rPreimage) &&
        Arrays.equals(this.rHash, lnrpcInvoice.rHash) &&
        Objects.equals(this.value, lnrpcInvoice.value) &&
        Objects.equals(this.valueMsat, lnrpcInvoice.valueMsat) &&
        Objects.equals(this.settled, lnrpcInvoice.settled) &&
        Objects.equals(this.creationDate, lnrpcInvoice.creationDate) &&
        Objects.equals(this.settleDate, lnrpcInvoice.settleDate) &&
        Objects.equals(this.paymentRequest, lnrpcInvoice.paymentRequest) &&
        Arrays.equals(this.descriptionHash, lnrpcInvoice.descriptionHash) &&
        Objects.equals(this.expiry, lnrpcInvoice.expiry) &&
        Objects.equals(this.fallbackAddr, lnrpcInvoice.fallbackAddr) &&
        Objects.equals(this.cltvExpiry, lnrpcInvoice.cltvExpiry) &&
        Objects.equals(this.routeHints, lnrpcInvoice.routeHints) &&
        Objects.equals(this._private, lnrpcInvoice._private) &&
        Objects.equals(this.addIndex, lnrpcInvoice.addIndex) &&
        Objects.equals(this.settleIndex, lnrpcInvoice.settleIndex) &&
        Objects.equals(this.amtPaid, lnrpcInvoice.amtPaid) &&
        Objects.equals(this.amtPaidSat, lnrpcInvoice.amtPaidSat) &&
        Objects.equals(this.amtPaidMsat, lnrpcInvoice.amtPaidMsat) &&
        Objects.equals(this.state, lnrpcInvoice.state) &&
        Objects.equals(this.htlcs, lnrpcInvoice.htlcs) &&
        Objects.equals(this.features, lnrpcInvoice.features) &&
        Objects.equals(this.isKeysend, lnrpcInvoice.isKeysend) &&
        Arrays.equals(this.paymentAddr, lnrpcInvoice.paymentAddr) &&
        Objects.equals(this.isAmp, lnrpcInvoice.isAmp) &&
        Objects.equals(this.ampInvoiceState, lnrpcInvoice.ampInvoiceState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(memo, Arrays.hashCode(rPreimage), Arrays.hashCode(rHash), value, valueMsat, settled, creationDate, settleDate, paymentRequest, Arrays.hashCode(descriptionHash), expiry, fallbackAddr, cltvExpiry, routeHints, _private, addIndex, settleIndex, amtPaid, amtPaidSat, amtPaidMsat, state, htlcs, features, isKeysend, Arrays.hashCode(paymentAddr), isAmp, ampInvoiceState);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LnrpcInvoice {\n");
    sb.append("    memo: ").append(toIndentedString(memo)).append("\n");
    sb.append("    rPreimage: ").append(toIndentedString(rPreimage)).append("\n");
    sb.append("    rHash: ").append(toIndentedString(rHash)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    valueMsat: ").append(toIndentedString(valueMsat)).append("\n");
    sb.append("    settled: ").append(toIndentedString(settled)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    settleDate: ").append(toIndentedString(settleDate)).append("\n");
    sb.append("    paymentRequest: ").append(toIndentedString(paymentRequest)).append("\n");
    sb.append("    descriptionHash: ").append(toIndentedString(descriptionHash)).append("\n");
    sb.append("    expiry: ").append(toIndentedString(expiry)).append("\n");
    sb.append("    fallbackAddr: ").append(toIndentedString(fallbackAddr)).append("\n");
    sb.append("    cltvExpiry: ").append(toIndentedString(cltvExpiry)).append("\n");
    sb.append("    routeHints: ").append(toIndentedString(routeHints)).append("\n");
    sb.append("    _private: ").append(toIndentedString(_private)).append("\n");
    sb.append("    addIndex: ").append(toIndentedString(addIndex)).append("\n");
    sb.append("    settleIndex: ").append(toIndentedString(settleIndex)).append("\n");
    sb.append("    amtPaid: ").append(toIndentedString(amtPaid)).append("\n");
    sb.append("    amtPaidSat: ").append(toIndentedString(amtPaidSat)).append("\n");
    sb.append("    amtPaidMsat: ").append(toIndentedString(amtPaidMsat)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    htlcs: ").append(toIndentedString(htlcs)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    isKeysend: ").append(toIndentedString(isKeysend)).append("\n");
    sb.append("    paymentAddr: ").append(toIndentedString(paymentAddr)).append("\n");
    sb.append("    isAmp: ").append(toIndentedString(isAmp)).append("\n");
    sb.append("    ampInvoiceState: ").append(toIndentedString(ampInvoiceState)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

