/*
 * invoicesrpc/invoices.proto
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: version not set
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.osslabz.lnd.api;

import net.osslabz.lnd.ApiCallback;
import net.osslabz.lnd.ApiClient;
import net.osslabz.lnd.ApiException;
import net.osslabz.lnd.ApiResponse;
import net.osslabz.lnd.Configuration;
import net.osslabz.lnd.Pair;
import net.osslabz.lnd.ProgressRequestBody;
import net.osslabz.lnd.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.osslabz.lnd.dto.InvoicesrpcAddHoldInvoiceRequest;
import net.osslabz.lnd.dto.InvoicesrpcAddHoldInvoiceResp;
import net.osslabz.lnd.dto.InvoicesrpcCancelInvoiceMsg;
import net.osslabz.lnd.dto.InvoicesrpcSettleInvoiceMsg;
import net.osslabz.lnd.dto.LnrpcInvoice;
import net.osslabz.lnd.dto.RpcStatus;
import net.osslabz.lnd.dto.StreamResultOfLnrpcInvoice;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoicesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InvoicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InvoicesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for addHoldInvoice
     * @param body  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addHoldInvoiceCall(InvoicesrpcAddHoldInvoiceRequest body, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/v2/invoices/hodl";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addHoldInvoiceValidateBeforeCall(InvoicesrpcAddHoldInvoiceRequest body, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addHoldInvoice(Async)");
        }
        

        okhttp3.Call localVarCall = addHoldInvoiceCall(body, _callback);
        return localVarCall;

    }

    /**
     * AddHoldInvoice creates a hold invoice. It ties the invoice to the hash supplied in the request.
     * 
     * @param body  (required)
     * @return InvoicesrpcAddHoldInvoiceResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public InvoicesrpcAddHoldInvoiceResp addHoldInvoice(InvoicesrpcAddHoldInvoiceRequest body) throws ApiException {
        ApiResponse<InvoicesrpcAddHoldInvoiceResp> localVarResp = addHoldInvoiceWithHttpInfo(body);
        return localVarResp.getData();
    }

    /**
     * AddHoldInvoice creates a hold invoice. It ties the invoice to the hash supplied in the request.
     * 
     * @param body  (required)
     * @return ApiResponse&lt;InvoicesrpcAddHoldInvoiceResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InvoicesrpcAddHoldInvoiceResp> addHoldInvoiceWithHttpInfo(InvoicesrpcAddHoldInvoiceRequest body) throws ApiException {
        okhttp3.Call localVarCall = addHoldInvoiceValidateBeforeCall(body, null);
        Type localVarReturnType = new TypeToken<InvoicesrpcAddHoldInvoiceResp>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * AddHoldInvoice creates a hold invoice. It ties the invoice to the hash supplied in the request. (asynchronously)
     * 
     * @param body  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addHoldInvoiceAsync(InvoicesrpcAddHoldInvoiceRequest body, final ApiCallback<InvoicesrpcAddHoldInvoiceResp> _callback) throws ApiException {

        okhttp3.Call localVarCall = addHoldInvoiceValidateBeforeCall(body, _callback);
        Type localVarReturnType = new TypeToken<InvoicesrpcAddHoldInvoiceResp>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cancelInvoice
     * @param body  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelInvoiceCall(InvoicesrpcCancelInvoiceMsg body, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/v2/invoices/cancel";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelInvoiceValidateBeforeCall(InvoicesrpcCancelInvoiceMsg body, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling cancelInvoice(Async)");
        }
        

        okhttp3.Call localVarCall = cancelInvoiceCall(body, _callback);
        return localVarCall;

    }

    /**
     * CancelInvoice cancels a currently open invoice. If the invoice is already canceled, this call will succeed. If the invoice is already settled, it will fail.
     * 
     * @param body  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public Object cancelInvoice(InvoicesrpcCancelInvoiceMsg body) throws ApiException {
        ApiResponse<Object> localVarResp = cancelInvoiceWithHttpInfo(body);
        return localVarResp.getData();
    }

    /**
     * CancelInvoice cancels a currently open invoice. If the invoice is already canceled, this call will succeed. If the invoice is already settled, it will fail.
     * 
     * @param body  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> cancelInvoiceWithHttpInfo(InvoicesrpcCancelInvoiceMsg body) throws ApiException {
        okhttp3.Call localVarCall = cancelInvoiceValidateBeforeCall(body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * CancelInvoice cancels a currently open invoice. If the invoice is already canceled, this call will succeed. If the invoice is already settled, it will fail. (asynchronously)
     * 
     * @param body  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelInvoiceAsync(InvoicesrpcCancelInvoiceMsg body, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelInvoiceValidateBeforeCall(body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for lookupInvoiceV2
     * @param paymentHash When using REST, this field must be encoded as base64. (optional)
     * @param paymentAddr  (optional)
     * @param setId  (optional)
     * @param lookupModifier  - DEFAULT: The default look up modifier, no look up behavior is changed.  - HTLC_SET_ONLY: Indicates that when a look up is done based on a set_id, then only that set of HTLCs related to that set ID should be returned.  - HTLC_SET_BLANK: Indicates that when a look up is done using a payment_addr, then no HTLCs related to the payment_addr should be returned. This is useful when one wants to be able to obtain the set of associated setIDs with a given invoice, then look up the sub-invoices \&quot;projected\&quot; by that set ID. (optional, default to DEFAULT)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call lookupInvoiceV2Call(byte[] paymentHash, byte[] paymentAddr, byte[] setId, String lookupModifier, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/invoices/lookup";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (paymentHash != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("payment_hash", paymentHash));
        }

        if (paymentAddr != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("payment_addr", paymentAddr));
        }

        if (setId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("set_id", setId));
        }

        if (lookupModifier != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("lookup_modifier", lookupModifier));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call lookupInvoiceV2ValidateBeforeCall(byte[] paymentHash, byte[] paymentAddr, byte[] setId, String lookupModifier, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = lookupInvoiceV2Call(paymentHash, paymentAddr, setId, lookupModifier, _callback);
        return localVarCall;

    }

    /**
     * LookupInvoiceV2 attempts to look up at invoice. An invoice can be refrenced using either its payment hash, payment address, or set ID.
     * 
     * @param paymentHash When using REST, this field must be encoded as base64. (optional)
     * @param paymentAddr  (optional)
     * @param setId  (optional)
     * @param lookupModifier  - DEFAULT: The default look up modifier, no look up behavior is changed.  - HTLC_SET_ONLY: Indicates that when a look up is done based on a set_id, then only that set of HTLCs related to that set ID should be returned.  - HTLC_SET_BLANK: Indicates that when a look up is done using a payment_addr, then no HTLCs related to the payment_addr should be returned. This is useful when one wants to be able to obtain the set of associated setIDs with a given invoice, then look up the sub-invoices \&quot;projected\&quot; by that set ID. (optional, default to DEFAULT)
     * @return LnrpcInvoice
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public LnrpcInvoice lookupInvoiceV2(byte[] paymentHash, byte[] paymentAddr, byte[] setId, String lookupModifier) throws ApiException {
        ApiResponse<LnrpcInvoice> localVarResp = lookupInvoiceV2WithHttpInfo(paymentHash, paymentAddr, setId, lookupModifier);
        return localVarResp.getData();
    }

    /**
     * LookupInvoiceV2 attempts to look up at invoice. An invoice can be refrenced using either its payment hash, payment address, or set ID.
     * 
     * @param paymentHash When using REST, this field must be encoded as base64. (optional)
     * @param paymentAddr  (optional)
     * @param setId  (optional)
     * @param lookupModifier  - DEFAULT: The default look up modifier, no look up behavior is changed.  - HTLC_SET_ONLY: Indicates that when a look up is done based on a set_id, then only that set of HTLCs related to that set ID should be returned.  - HTLC_SET_BLANK: Indicates that when a look up is done using a payment_addr, then no HTLCs related to the payment_addr should be returned. This is useful when one wants to be able to obtain the set of associated setIDs with a given invoice, then look up the sub-invoices \&quot;projected\&quot; by that set ID. (optional, default to DEFAULT)
     * @return ApiResponse&lt;LnrpcInvoice&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<LnrpcInvoice> lookupInvoiceV2WithHttpInfo(byte[] paymentHash, byte[] paymentAddr, byte[] setId, String lookupModifier) throws ApiException {
        okhttp3.Call localVarCall = lookupInvoiceV2ValidateBeforeCall(paymentHash, paymentAddr, setId, lookupModifier, null);
        Type localVarReturnType = new TypeToken<LnrpcInvoice>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * LookupInvoiceV2 attempts to look up at invoice. An invoice can be refrenced using either its payment hash, payment address, or set ID. (asynchronously)
     * 
     * @param paymentHash When using REST, this field must be encoded as base64. (optional)
     * @param paymentAddr  (optional)
     * @param setId  (optional)
     * @param lookupModifier  - DEFAULT: The default look up modifier, no look up behavior is changed.  - HTLC_SET_ONLY: Indicates that when a look up is done based on a set_id, then only that set of HTLCs related to that set ID should be returned.  - HTLC_SET_BLANK: Indicates that when a look up is done using a payment_addr, then no HTLCs related to the payment_addr should be returned. This is useful when one wants to be able to obtain the set of associated setIDs with a given invoice, then look up the sub-invoices \&quot;projected\&quot; by that set ID. (optional, default to DEFAULT)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call lookupInvoiceV2Async(byte[] paymentHash, byte[] paymentAddr, byte[] setId, String lookupModifier, final ApiCallback<LnrpcInvoice> _callback) throws ApiException {

        okhttp3.Call localVarCall = lookupInvoiceV2ValidateBeforeCall(paymentHash, paymentAddr, setId, lookupModifier, _callback);
        Type localVarReturnType = new TypeToken<LnrpcInvoice>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for settleInvoice
     * @param body  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call settleInvoiceCall(InvoicesrpcSettleInvoiceMsg body, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/v2/invoices/settle";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call settleInvoiceValidateBeforeCall(InvoicesrpcSettleInvoiceMsg body, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling settleInvoice(Async)");
        }
        

        okhttp3.Call localVarCall = settleInvoiceCall(body, _callback);
        return localVarCall;

    }

    /**
     * SettleInvoice settles an accepted invoice. If the invoice is already settled, this call will succeed.
     * 
     * @param body  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public Object settleInvoice(InvoicesrpcSettleInvoiceMsg body) throws ApiException {
        ApiResponse<Object> localVarResp = settleInvoiceWithHttpInfo(body);
        return localVarResp.getData();
    }

    /**
     * SettleInvoice settles an accepted invoice. If the invoice is already settled, this call will succeed.
     * 
     * @param body  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> settleInvoiceWithHttpInfo(InvoicesrpcSettleInvoiceMsg body) throws ApiException {
        okhttp3.Call localVarCall = settleInvoiceValidateBeforeCall(body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SettleInvoice settles an accepted invoice. If the invoice is already settled, this call will succeed. (asynchronously)
     * 
     * @param body  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call settleInvoiceAsync(InvoicesrpcSettleInvoiceMsg body, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = settleInvoiceValidateBeforeCall(body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscribeSingleInvoice
     * @param rHash Hash corresponding to the (hold) invoice to subscribe to. When using REST, this field must be encoded as base64url. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response.(streaming responses) </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeSingleInvoiceCall(byte[] rHash, final ApiCallback _callback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/invoices/subscribe/{r_hash}"
            .replaceAll("\\{" + "r_hash" + "\\}", localVarApiClient.escapeString(rHash.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscribeSingleInvoiceValidateBeforeCall(byte[] rHash, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'rHash' is set
        if (rHash == null) {
            throw new ApiException("Missing the required parameter 'rHash' when calling subscribeSingleInvoice(Async)");
        }
        

        okhttp3.Call localVarCall = subscribeSingleInvoiceCall(rHash, _callback);
        return localVarCall;

    }

    /**
     * SubscribeSingleInvoice returns a uni-directional stream (server -&gt; client) to notify the client of state transitions of the specified invoice. Initially the current invoice state is always sent out.
     * 
     * @param rHash Hash corresponding to the (hold) invoice to subscribe to. When using REST, this field must be encoded as base64url. (required)
     * @return StreamResultOfLnrpcInvoice
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response.(streaming responses) </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public StreamResultOfLnrpcInvoice subscribeSingleInvoice(byte[] rHash) throws ApiException {
        ApiResponse<StreamResultOfLnrpcInvoice> localVarResp = subscribeSingleInvoiceWithHttpInfo(rHash);
        return localVarResp.getData();
    }

    /**
     * SubscribeSingleInvoice returns a uni-directional stream (server -&gt; client) to notify the client of state transitions of the specified invoice. Initially the current invoice state is always sent out.
     * 
     * @param rHash Hash corresponding to the (hold) invoice to subscribe to. When using REST, this field must be encoded as base64url. (required)
     * @return ApiResponse&lt;StreamResultOfLnrpcInvoice&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response.(streaming responses) </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StreamResultOfLnrpcInvoice> subscribeSingleInvoiceWithHttpInfo(byte[] rHash) throws ApiException {
        okhttp3.Call localVarCall = subscribeSingleInvoiceValidateBeforeCall(rHash, null);
        Type localVarReturnType = new TypeToken<StreamResultOfLnrpcInvoice>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SubscribeSingleInvoice returns a uni-directional stream (server -&gt; client) to notify the client of state transitions of the specified invoice. Initially the current invoice state is always sent out. (asynchronously)
     * 
     * @param rHash Hash corresponding to the (hold) invoice to subscribe to. When using REST, this field must be encoded as base64url. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response.(streaming responses) </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> An unexpected error response. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscribeSingleInvoiceAsync(byte[] rHash, final ApiCallback<StreamResultOfLnrpcInvoice> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscribeSingleInvoiceValidateBeforeCall(rHash, _callback);
        Type localVarReturnType = new TypeToken<StreamResultOfLnrpcInvoice>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
