/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.evmclient.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import net.osslabz.evmclient.dto.NetworkType;
import net.osslabz.evmclient.dto.PrimaryCoin;

public class Chain
implements Serializable {
    public static final Chain AVALANCHE_MAIN = new Chain("Avalanche Network", "AVAX", NetworkType.MAIN, 43114, "https://api.avax.network/ext/bc/C/rpc", " https://snowtrace.io/");
    public static final Chain ETHEREUM_MAIN = new Chain("Ethereum Network", "ETH", NetworkType.MAIN, 1, "https://cloudflare-eth.com/", " https://etherscan.io/");
    private final String name;
    private final NetworkType type;
    private int id;
    private final String rpcUrl;
    private final String explorerUrl;
    @JsonIgnore
    private final PrimaryCoin coin;

    Chain(String name, String symbol, NetworkType type, int id, String rpcUrl, String explorerUrl) {
        this.name = name;
        this.type = type;
        this.id = id;
        this.rpcUrl = rpcUrl;
        this.explorerUrl = explorerUrl;
        this.coin = new PrimaryCoin(symbol);
    }

    public String toString() {
        return this.getClass().getName() + "(name=" + this.name + ", type=" + this.type + ", id=" + this.id + ", coin=" + this.coin + ")";
    }

    public String getName() {
        return this.name;
    }

    public NetworkType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public String getRpcUrl() {
        return this.rpcUrl;
    }

    public String getExplorerUrl() {
        return this.explorerUrl;
    }

    public PrimaryCoin getCoin() {
        return this.coin;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chain)) {
            return false;
        }
        Chain other = (Chain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NetworkType this$type = this.getType();
        NetworkType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$rpcUrl = this.getRpcUrl();
        String other$rpcUrl = other.getRpcUrl();
        if (this$rpcUrl == null ? other$rpcUrl != null : !this$rpcUrl.equals(other$rpcUrl)) {
            return false;
        }
        String this$explorerUrl = this.getExplorerUrl();
        String other$explorerUrl = other.getExplorerUrl();
        if (this$explorerUrl == null ? other$explorerUrl != null : !this$explorerUrl.equals(other$explorerUrl)) {
            return false;
        }
        PrimaryCoin this$coin = this.getCoin();
        PrimaryCoin other$coin = other.getCoin();
        return !(this$coin == null ? other$coin != null : !this$coin.equals(other$coin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NetworkType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $rpcUrl = this.getRpcUrl();
        result = result * 59 + ($rpcUrl == null ? 43 : $rpcUrl.hashCode());
        String $explorerUrl = this.getExplorerUrl();
        result = result * 59 + ($explorerUrl == null ? 43 : $explorerUrl.hashCode());
        PrimaryCoin $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : $coin.hashCode());
        return result;
    }
}

