/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.evmclient;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCookieJar
implements CookieJar {
    private static final Logger log = LoggerFactory.getLogger(InMemoryCookieJar.class);
    private List<Cookie> cookies;

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        if (cookies == null) {
            log.debug("No cookies present (null), no cookies saved.");
        } else if (cookies.isEmpty()) {
            log.debug("No cookies present (empty list), no cookies saved.");
        } else {
            log.debug("{} cookies saved to memory.", (Object)cookies.size());
            if (this.cookies == null) {
                this.cookies = new ArrayList<Cookie>();
            }
            for (Cookie cookie : cookies) {
                if (this.cookies.contains(cookie)) continue;
                this.cookies.add(cookie);
            }
        }
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        if (this.cookies != null) {
            log.debug("Sending {} cookies from memory storage.", (Object)this.cookies.size());
            return this.cookies;
        }
        log.debug("No cookies available in memory, returning empty list.");
        return Collections.emptyList();
    }
}

