/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.evmclient;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ConnectException;
import java.time.Duration;
import java.util.Collections;
import net.osslabz.evmclient.EvmClientException;
import net.osslabz.evmclient.InMemoryCookieJar;
import net.osslabz.evmclient.dto.Chain;
import net.osslabz.evmclient.dto.CoinBalance;
import net.osslabz.evmclient.dto.Erc20Token;
import net.osslabz.evmclient.dto.Erc20TokenBalance;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.contracts.eip20.generated.ERC20;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.websocket.LongLivingWebSocketService;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class EvmClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(EvmClient.class);
    private final Chain chainInfo;
    private final Web3j web3j;

    public EvmClient(Chain chain) {
        this(chain, EvmClient.createWeb3Service(chain.getRpcUrl()));
    }

    public EvmClient(Chain chain, String url) {
        this(chain, EvmClient.createWeb3Service(url));
    }

    public EvmClient(Chain chain, Web3jService web3jService) {
        this.chainInfo = chain;
        this.web3j = Web3j.build((Web3jService)web3jService);
    }

    public static Web3jService createWeb3Service(String rpcUrlString) {
        try {
            String protocol;
            if (rpcUrlString == null) {
                throw new EvmClientException("Can't instantiate Web3jService because the provided RPC URL is null.");
            }
            int protocolEndIndex = rpcUrlString.indexOf("://");
            if (protocolEndIndex <= 1) {
                throw new EvmClientException("Can't instantiate Web3jService because the provided RPC URL '" + rpcUrlString + "' is invalid.");
            }
            switch (protocol = rpcUrlString.substring(0, protocolEndIndex)) {
                case "ws": 
                case "wss": {
                    LongLivingWebSocketService webSocketService = new LongLivingWebSocketService(rpcUrlString, false);
                    webSocketService.connect();
                    return webSocketService;
                }
                case "http": 
                case "https": {
                    HttpService httpService = new HttpService(rpcUrlString, EvmClient.createHttpClientWithCookieSupport());
                    return httpService;
                }
            }
            throw new EvmClientException("Unknown protocol '" + protocol + "' in provided RPC URL '" + rpcUrlString + "'.");
        }
        catch (ConnectException e) {
            throw new EvmClientException(e);
        }
    }

    private static OkHttpClient createHttpClientWithCookieSupport() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.cookieJar((CookieJar)new InMemoryCookieJar());
        builder.connectTimeout(Duration.ofSeconds(30L));
        builder.readTimeout(Duration.ofSeconds(60L));
        builder.writeTimeout(Duration.ofSeconds(15L));
        builder.pingInterval(Duration.ofSeconds(15L));
        builder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        builder.retryOnConnectionFailure(true);
        if (log.isTraceEnabled()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)log).trace(arg_0));
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)logging);
        }
        OkHttpClient okHttpClient = builder.build();
        return okHttpClient;
    }

    public Erc20Token getTokenInfo(String contractAddress) {
        ERC20 erc20 = this.loaErc20ContractWithReadOnlyDefaults(contractAddress);
        Erc20Token tokenInfo = this.getTokenInfo(erc20);
        return tokenInfo;
    }

    public CoinBalance getBalance(String address) {
        try {
            BigInteger balance = ((EthGetBalance)this.web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
            return new CoinBalance(this.chainInfo, balance);
        }
        catch (IOException e) {
            throw new EvmClientException(e);
        }
    }

    public Erc20TokenBalance getTokenBalance(String contractAddress, String address) {
        ERC20 erc20 = this.loaErc20ContractWithReadOnlyDefaults(contractAddress);
        Erc20Token tokenInfo = this.getTokenInfo(erc20);
        try {
            BigInteger balance = (BigInteger)erc20.balanceOf(address).send();
            return new Erc20TokenBalance(tokenInfo, balance);
        }
        catch (Exception e) {
            throw new EvmClientException(e);
        }
    }

    public Erc20TokenBalance getTokenBalance(Erc20Token tokenInfo, String address) {
        if (!this.chainInfo.equals(tokenInfo.getChain())) {
            throw new IllegalArgumentException("This instance of " + this.getClass().getName() + " is bound to chain " + this.chainInfo + ", the provided token is from chain " + tokenInfo.getChain() + ".");
        }
        try {
            ERC20 erc20 = this.loaErc20ContractWithReadOnlyDefaults(tokenInfo.getContractAddress());
            BigInteger balance = (BigInteger)erc20.balanceOf(address).send();
            return new Erc20TokenBalance(tokenInfo, balance);
        }
        catch (Exception e) {
            throw new EvmClientException(e);
        }
    }

    public ERC20 loaErc20ContractWithReadOnlyDefaults(String contractAddress) {
        ReadonlyTransactionManager readOnlyTransactionManager = new ReadonlyTransactionManager(this.web3j, null);
        ERC20 erc20 = ERC20.load((String)contractAddress, (Web3j)this.web3j, (TransactionManager)readOnlyTransactionManager, (ContractGasProvider)null);
        return erc20;
    }

    public BigInteger getLastBlockNumber() {
        try {
            return ((EthBlockNumber)this.web3j.ethBlockNumber().send()).getBlockNumber();
        }
        catch (IOException e) {
            throw new EvmClientException(e);
        }
    }

    public Erc20Token getTokenInfo(ERC20 erc20) {
        String contractAddress = erc20.getContractAddress();
        String name = null;
        String symbol = null;
        BigInteger decimals = null;
        BigInteger totalSupply = null;
        try {
            name = (String)erc20.name().send();
        }
        catch (Exception e) {
            log.warn("Couldn't fetch name for contract address {}.", (Object)contractAddress);
        }
        try {
            symbol = (String)erc20.symbol().send();
        }
        catch (Exception e) {
            log.warn("Couldn't fetch symbol for contract address {}.", (Object)contractAddress);
        }
        try {
            decimals = (BigInteger)erc20.decimals().send();
        }
        catch (Exception e) {
            log.warn("Couldn't fetch decimals for contract address{}.", (Object)contractAddress);
        }
        try {
            totalSupply = (BigInteger)erc20.totalSupply().send();
        }
        catch (Exception e) {
            log.warn("Couldn't fetch totalSupply for contract address {}.", (Object)contractAddress);
        }
        if (name == null && symbol == null && decimals == null && totalSupply == null) {
            throw new EvmClientException("Couldn't fetch any token info for " + contractAddress + ". Most likely not a valid ERC20 contract.");
        }
        Erc20Token tokenInfo = new Erc20Token(this.chainInfo, contractAddress, name, symbol, decimals, totalSupply);
        return tokenInfo;
    }

    public void shutdown() {
        this.web3j.shutdown();
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public Chain getChainInfo() {
        return this.chainInfo;
    }

    public Web3j getWeb3j() {
        return this.web3j;
    }
}

