/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.evm.abi.util;

import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class ByteUtil {
    public static String toHexString(byte[] data) {
        return data == null ? "" : Hex.toHexString((byte[])data);
    }

    public static BigInteger bytesToBigInteger(byte[] bb) {
        return bb == null || bb.length == 0 ? BigInteger.ZERO : new BigInteger(1, bb);
    }

    public static byte[] bigIntegerToBytes(BigInteger value) {
        if (value == null) {
            return null;
        }
        byte[] data = value.toByteArray();
        if (data.length != 1 && data[0] == 0) {
            byte[] tmp = new byte[data.length - 1];
            System.arraycopy(data, 1, tmp, 0, tmp.length);
            data = tmp;
        }
        return data;
    }

    public static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[numBytes];
        byte[] biBytes = b.toByteArray();
        int start = biBytes.length == numBytes + 1 ? 1 : 0;
        int length = Math.min(biBytes.length, numBytes);
        System.arraycopy(biBytes, start, bytes, numBytes - length, length);
        return bytes;
    }

    public static byte[] bigIntegerToBytesSigned(BigInteger b, int numBytes) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[numBytes];
        Arrays.fill(bytes, b.signum() < 0 ? (byte)-1 : 0);
        byte[] biBytes = b.toByteArray();
        int start = biBytes.length == numBytes + 1 ? 1 : 0;
        int length = Math.min(biBytes.length, numBytes);
        System.arraycopy(biBytes, start, bytes, numBytes - length, length);
        return bytes;
    }

    public static byte[] merge(byte[] ... arrays) {
        int count = 0;
        for (byte[] array : arrays) {
            count += array.length;
        }
        byte[] mergedArray = new byte[count];
        int start = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
        }
        return mergedArray;
    }
}

