/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.evm.abi.decoder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osslabz.evm.abi.util.ByteUtil;

public class DecodedFunctionCall {
    private String name;
    private Map<String, Param> params;

    public DecodedFunctionCall(String name, List<Param> params) {
        this.name = name;
        this.params = new LinkedHashMap<String, Param>();
        for (Param param : params) {
            this.params.put(param.getName().toLowerCase(), param);
        }
    }

    public Param getParam(String paramName) {
        return this.params.get(paramName.toLowerCase());
    }

    public Collection<Param> getParams() {
        return this.params.values();
    }

    public List<Param> getParamList() {
        return new ArrayList<Param>(this.getParams());
    }

    public int getSize() {
        return this.params.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParams(Map<String, Param> params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecodedFunctionCall)) {
            return false;
        }
        DecodedFunctionCall other = (DecodedFunctionCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Collection<Param> this$params = this.getParams();
        Collection<Param> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DecodedFunctionCall;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Collection<Param> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    public String toString() {
        return "DecodedFunctionCall(name=" + this.getName() + ", params=" + this.getParams() + ")";
    }

    public static class Param {
        private String name;
        private String type;
        private Object value;

        public Param(String name, String type, Object value) {
            this.name = name;
            this.type = type;
            if (value instanceof byte[]) {
                this.value = "0x" + ByteUtil.toHexString((byte[])value);
            } else if (value instanceof Object[]) {
                Object[] valueAsObjectArray = (Object[])value;
                this.value = new Object[valueAsObjectArray.length];
                for (int i = 0; i < valueAsObjectArray.length; ++i) {
                    Object o = valueAsObjectArray[i];
                    ((Object[])this.value)[i] = o instanceof byte[] ? "0x" + ByteUtil.toHexString((byte[])o) : o;
                }
            } else {
                this.value = value;
            }
        }

        public String toString() {
            String valueString = this.value == null ? "null" : (this.value.getClass().isArray() ? Arrays.toString((Object[])this.value) : this.value.toString());
            return this.getClass().getName() + "(name=" + this.name + ", type=" + this.getType() + ", value=" + valueString + ")";
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Param)) {
                return false;
            }
            Param other = (Param)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Param;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

