/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.crypto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import net.osslabz.crypto.CurrencyPair;
import net.osslabz.crypto.Exchange;

public record TradingAsset(Exchange exchange, CurrencyPair currencyPair) {
    public TradingAsset {
        Objects.requireNonNull(exchange, "exchange cannot be null");
        Objects.requireNonNull(currencyPair, "currencyPair cannot be null");
    }

    public TradingAsset(Exchange exchange, String baseCurrencyCode, String counterCurrencyCode) {
        this(exchange, new CurrencyPair(baseCurrencyCode, counterCurrencyCode));
    }

    public String baseCurrencyCode() {
        return this.currencyPair.baseCurrencyCode();
    }

    public String counterCurrencyCode() {
        return this.currencyPair.counterCurrencyCode();
    }

    @JsonIgnore
    public String getLabel() {
        return "%s-%s".formatted(new Object[]{this.exchange, this.currencyPair.getLabel()});
    }
}

