/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.crypto;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import lombok.Generated;
import net.osslabz.crypto.CryptoMathUtils;
import net.osslabz.crypto.CurrencyPair;
import net.osslabz.crypto.Exchange;
import net.osslabz.crypto.Interval;
import net.osslabz.crypto.OhlcAsset;
import net.osslabz.crypto.TradingAsset;

public class Ohlc {
    private OhlcAsset asset;
    private ZonedDateTime openTime;
    private ZonedDateTime closeTime;
    private BigDecimal openPrice;
    private BigDecimal highPrice;
    private BigDecimal lowPrice;
    private BigDecimal closePrice;
    private BigDecimal avgPrice;
    private BigDecimal quantity;
    private BigDecimal volume;
    private Long numTrades;
    private ZonedDateTime updateTime;

    public TradingAsset tradingAsset() {
        return this.asset.tradingAsset();
    }

    public Exchange exchange() {
        return this.asset.exchange();
    }

    public CurrencyPair currencyPair() {
        return this.asset.currencyPair();
    }

    public Interval interval() {
        return this.asset.interval();
    }

    public String baseCurrencyCode() {
        return this.currencyPair().baseCurrencyCode();
    }

    public String counterCurrencyCode() {
        return this.currencyPair().counterCurrencyCode();
    }

    public boolean isBullish() {
        return this.openPrice != null && this.closePrice != null && this.openPrice.compareTo(this.closePrice) < 0;
    }

    public boolean isBearish() {
        return this.openPrice != null && this.closePrice != null && this.openPrice.compareTo(this.closePrice) > 0;
    }

    public BigDecimal getPriceDiffAsPercentageOpenToClose() {
        return CryptoMathUtils.getPriceDiffAsPercentage(this.closePrice, this.openPrice);
    }

    @Generated
    protected Ohlc(OhlcBuilder<?, ?> b) {
        this.asset = b.asset;
        this.openTime = b.openTime;
        this.closeTime = b.closeTime;
        this.openPrice = b.openPrice;
        this.highPrice = b.highPrice;
        this.lowPrice = b.lowPrice;
        this.closePrice = b.closePrice;
        this.avgPrice = b.avgPrice;
        this.quantity = b.quantity;
        this.volume = b.volume;
        this.numTrades = b.numTrades;
        this.updateTime = b.updateTime;
    }

    @Generated
    public static OhlcBuilder<?, ?> builder() {
        return new OhlcBuilderImpl();
    }

    @Generated
    public OhlcBuilder<?, ?> toBuilder() {
        return new OhlcBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public OhlcAsset getAsset() {
        return this.asset;
    }

    @Generated
    public ZonedDateTime getOpenTime() {
        return this.openTime;
    }

    @Generated
    public ZonedDateTime getCloseTime() {
        return this.closeTime;
    }

    @Generated
    public BigDecimal getOpenPrice() {
        return this.openPrice;
    }

    @Generated
    public BigDecimal getHighPrice() {
        return this.highPrice;
    }

    @Generated
    public BigDecimal getLowPrice() {
        return this.lowPrice;
    }

    @Generated
    public BigDecimal getClosePrice() {
        return this.closePrice;
    }

    @Generated
    public BigDecimal getAvgPrice() {
        return this.avgPrice;
    }

    @Generated
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    @Generated
    public BigDecimal getVolume() {
        return this.volume;
    }

    @Generated
    public Long getNumTrades() {
        return this.numTrades;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setAsset(OhlcAsset asset) {
        this.asset = asset;
    }

    @Generated
    public void setOpenTime(ZonedDateTime openTime) {
        this.openTime = openTime;
    }

    @Generated
    public void setCloseTime(ZonedDateTime closeTime) {
        this.closeTime = closeTime;
    }

    @Generated
    public void setOpenPrice(BigDecimal openPrice) {
        this.openPrice = openPrice;
    }

    @Generated
    public void setHighPrice(BigDecimal highPrice) {
        this.highPrice = highPrice;
    }

    @Generated
    public void setLowPrice(BigDecimal lowPrice) {
        this.lowPrice = lowPrice;
    }

    @Generated
    public void setClosePrice(BigDecimal closePrice) {
        this.closePrice = closePrice;
    }

    @Generated
    public void setAvgPrice(BigDecimal avgPrice) {
        this.avgPrice = avgPrice;
    }

    @Generated
    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    @Generated
    public void setNumTrades(Long numTrades) {
        this.numTrades = numTrades;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public String toString() {
        return "Ohlc(asset=" + String.valueOf(this.getAsset()) + ", openTime=" + String.valueOf(this.getOpenTime()) + ", closeTime=" + String.valueOf(this.getCloseTime()) + ", openPrice=" + String.valueOf(this.getOpenPrice()) + ", highPrice=" + String.valueOf(this.getHighPrice()) + ", lowPrice=" + String.valueOf(this.getLowPrice()) + ", closePrice=" + String.valueOf(this.getClosePrice()) + ", avgPrice=" + String.valueOf(this.getAvgPrice()) + ", quantity=" + String.valueOf(this.getQuantity()) + ", volume=" + String.valueOf(this.getVolume()) + ", numTrades=" + this.getNumTrades() + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ")";
    }

    @Generated
    public Ohlc() {
    }

    @Generated
    public Ohlc(OhlcAsset asset, ZonedDateTime openTime, ZonedDateTime closeTime, BigDecimal openPrice, BigDecimal highPrice, BigDecimal lowPrice, BigDecimal closePrice, BigDecimal avgPrice, BigDecimal quantity, BigDecimal volume, Long numTrades, ZonedDateTime updateTime) {
        this.asset = asset;
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.openPrice = openPrice;
        this.highPrice = highPrice;
        this.lowPrice = lowPrice;
        this.closePrice = closePrice;
        this.avgPrice = avgPrice;
        this.quantity = quantity;
        this.volume = volume;
        this.numTrades = numTrades;
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ohlc)) {
            return false;
        }
        Ohlc other = (Ohlc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OhlcAsset this$asset = this.getAsset();
        OhlcAsset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        ZonedDateTime this$openTime = this.getOpenTime();
        ZonedDateTime other$openTime = other.getOpenTime();
        return !(this$openTime == null ? other$openTime != null : !((Object)this$openTime).equals(other$openTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Ohlc;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OhlcAsset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        ZonedDateTime $openTime = this.getOpenTime();
        result = result * 59 + ($openTime == null ? 43 : ((Object)$openTime).hashCode());
        return result;
    }

    @Generated
    public static abstract class OhlcBuilder<C extends Ohlc, B extends OhlcBuilder<C, B>> {
        @Generated
        private OhlcAsset asset;
        @Generated
        private ZonedDateTime openTime;
        @Generated
        private ZonedDateTime closeTime;
        @Generated
        private BigDecimal openPrice;
        @Generated
        private BigDecimal highPrice;
        @Generated
        private BigDecimal lowPrice;
        @Generated
        private BigDecimal closePrice;
        @Generated
        private BigDecimal avgPrice;
        @Generated
        private BigDecimal quantity;
        @Generated
        private BigDecimal volume;
        @Generated
        private Long numTrades;
        @Generated
        private ZonedDateTime updateTime;

        @Generated
        protected B $fillValuesFrom(C instance) {
            OhlcBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Ohlc instance, OhlcBuilder<?, ?> b) {
            b.asset(instance.asset);
            b.openTime(instance.openTime);
            b.closeTime(instance.closeTime);
            b.openPrice(instance.openPrice);
            b.highPrice(instance.highPrice);
            b.lowPrice(instance.lowPrice);
            b.closePrice(instance.closePrice);
            b.avgPrice(instance.avgPrice);
            b.quantity(instance.quantity);
            b.volume(instance.volume);
            b.numTrades(instance.numTrades);
            b.updateTime(instance.updateTime);
        }

        @Generated
        public B asset(OhlcAsset asset) {
            this.asset = asset;
            return this.self();
        }

        @Generated
        public B openTime(ZonedDateTime openTime) {
            this.openTime = openTime;
            return this.self();
        }

        @Generated
        public B closeTime(ZonedDateTime closeTime) {
            this.closeTime = closeTime;
            return this.self();
        }

        @Generated
        public B openPrice(BigDecimal openPrice) {
            this.openPrice = openPrice;
            return this.self();
        }

        @Generated
        public B highPrice(BigDecimal highPrice) {
            this.highPrice = highPrice;
            return this.self();
        }

        @Generated
        public B lowPrice(BigDecimal lowPrice) {
            this.lowPrice = lowPrice;
            return this.self();
        }

        @Generated
        public B closePrice(BigDecimal closePrice) {
            this.closePrice = closePrice;
            return this.self();
        }

        @Generated
        public B avgPrice(BigDecimal avgPrice) {
            this.avgPrice = avgPrice;
            return this.self();
        }

        @Generated
        public B quantity(BigDecimal quantity) {
            this.quantity = quantity;
            return this.self();
        }

        @Generated
        public B volume(BigDecimal volume) {
            this.volume = volume;
            return this.self();
        }

        @Generated
        public B numTrades(Long numTrades) {
            this.numTrades = numTrades;
            return this.self();
        }

        @Generated
        public B updateTime(ZonedDateTime updateTime) {
            this.updateTime = updateTime;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Ohlc.OhlcBuilder(asset=" + String.valueOf(this.asset) + ", openTime=" + String.valueOf(this.openTime) + ", closeTime=" + String.valueOf(this.closeTime) + ", openPrice=" + String.valueOf(this.openPrice) + ", highPrice=" + String.valueOf(this.highPrice) + ", lowPrice=" + String.valueOf(this.lowPrice) + ", closePrice=" + String.valueOf(this.closePrice) + ", avgPrice=" + String.valueOf(this.avgPrice) + ", quantity=" + String.valueOf(this.quantity) + ", volume=" + String.valueOf(this.volume) + ", numTrades=" + this.numTrades + ", updateTime=" + String.valueOf(this.updateTime) + ")";
        }
    }

    @Generated
    private static final class OhlcBuilderImpl
    extends OhlcBuilder<Ohlc, OhlcBuilderImpl> {
        @Generated
        private OhlcBuilderImpl() {
        }

        @Override
        @Generated
        protected OhlcBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Ohlc build() {
            return new Ohlc(this);
        }
    }
}

