/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.crypto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;

public enum Interval {
    PT1M(Duration.ofMinutes(1L)),
    PT5M(Duration.ofMinutes(5L)),
    PT15M(Duration.ofMinutes(15L)),
    PT1H(Duration.ofHours(1L)),
    PT12H(Duration.ofHours(12L)),
    PT24H(Duration.ofHours(24L));

    private final Duration duration;

    private Interval(Duration duration) {
        this.duration = duration;
    }

    @JsonIgnore
    public Duration getDuration() {
        return this.duration;
    }

    public static Interval ofDuration(Duration duration) {
        return Arrays.stream(Interval.values()).filter(i -> Objects.equals(duration, i.getDuration())).findAny().orElseThrow();
    }

    public static Interval ofMillis(Long millis) {
        return Arrays.stream(Interval.values()).filter(i -> i.getDuration().toMillis() == millis.longValue()).findAny().orElseThrow();
    }
}

