/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.crypto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import net.osslabz.crypto.CurrencyPair;
import net.osslabz.crypto.Exchange;
import net.osslabz.crypto.Interval;
import net.osslabz.crypto.TradingAsset;

public record OhlcAsset(TradingAsset tradingAsset, Interval interval) {
    public OhlcAsset {
        Objects.requireNonNull(tradingAsset, "tradingAsset cannot be null");
        Objects.requireNonNull(interval, "interval cannot be null");
    }

    public OhlcAsset(Exchange exchange, String baseCurrencyCode, String counterCurrencyCode, Interval interval) {
        this(new TradingAsset(exchange, new CurrencyPair(baseCurrencyCode, counterCurrencyCode)), interval);
    }

    public Exchange exchange() {
        return this.tradingAsset.exchange();
    }

    public CurrencyPair currencyPair() {
        return this.tradingAsset.currencyPair();
    }

    public String baseCurrencyCode() {
        return this.currencyPair().baseCurrencyCode();
    }

    public String counterCurrencyCode() {
        return this.currencyPair().counterCurrencyCode();
    }

    @JsonIgnore
    public String getLabel() {
        return "%s-%s".formatted(this.tradingAsset.getLabel(), this.interval.name());
    }
}

