/*
 * Decompiled with CFR 0.152.
 */
package com.litesoftwares.coingecko.impl;

import com.litesoftwares.coingecko.CoinGeckoApi;
import com.litesoftwares.coingecko.CoinGeckoApiClient;
import com.litesoftwares.coingecko.CoinGeckoApiService;
import com.litesoftwares.coingecko.domain.AssetPlatforms;
import com.litesoftwares.coingecko.domain.Coins.CoinFullData;
import com.litesoftwares.coingecko.domain.Coins.CoinHistoryById;
import com.litesoftwares.coingecko.domain.Coins.CoinList;
import com.litesoftwares.coingecko.domain.Coins.CoinMarkets;
import com.litesoftwares.coingecko.domain.Coins.CoinTickerById;
import com.litesoftwares.coingecko.domain.Coins.MarketChart;
import com.litesoftwares.coingecko.domain.Events.EventCountries;
import com.litesoftwares.coingecko.domain.Events.EventTypes;
import com.litesoftwares.coingecko.domain.Events.Events;
import com.litesoftwares.coingecko.domain.ExchangeRates.ExchangeRates;
import com.litesoftwares.coingecko.domain.Exchanges.ExchangeById;
import com.litesoftwares.coingecko.domain.Exchanges.Exchanges;
import com.litesoftwares.coingecko.domain.Exchanges.ExchangesList;
import com.litesoftwares.coingecko.domain.Exchanges.ExchangesTickersById;
import com.litesoftwares.coingecko.domain.Global.DecentralizedFinanceDefi;
import com.litesoftwares.coingecko.domain.Global.Global;
import com.litesoftwares.coingecko.domain.Ping;
import com.litesoftwares.coingecko.domain.Search.Search;
import com.litesoftwares.coingecko.domain.Search.Trending;
import com.litesoftwares.coingecko.domain.Status.StatusUpdates;
import java.util.List;
import java.util.Map;

public class CoinGeckoApiClientImpl
implements CoinGeckoApiClient {
    static final Long DEFAULT_CONNECTION_TIMEOUT = 10L;
    static final Long DEFAULT_READ_TIMEOUT = 10L;
    static final Long DEFAULT_WRITE_TIMEOUT = 10L;
    private CoinGeckoApiService coinGeckoApiService;
    private CoinGeckoApi coinGeckoApi = new CoinGeckoApi();

    public CoinGeckoApiClientImpl() {
        this(DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT, DEFAULT_WRITE_TIMEOUT);
    }

    public CoinGeckoApiClientImpl(Long connectionTimeoutSeconds, Long readTimeoutSeconds, Long writeTimeoutSeconds) {
        this.coinGeckoApiService = this.coinGeckoApi.createService(CoinGeckoApiService.class, connectionTimeoutSeconds, readTimeoutSeconds, writeTimeoutSeconds);
    }

    @Override
    public Ping ping() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.ping());
    }

    @Override
    public Map<String, Map<String, Double>> getPrice(String ids, String vsCurrencies) {
        return this.getPrice(ids, vsCurrencies, false, false, false, false);
    }

    @Override
    public Map<String, Map<String, Double>> getPrice(String ids, String vsCurrencies, boolean includeMarketCap, boolean include24hrVol, boolean include24hrChange, boolean includeLastUpdatedAt) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getPrice(ids, vsCurrencies, includeMarketCap, include24hrVol, include24hrChange, includeLastUpdatedAt));
    }

    @Override
    public Map<String, Map<String, Double>> getTokenPrice(String id, String contractAddress, String vsCurrencies) {
        return this.getTokenPrice(id, contractAddress, vsCurrencies, false, false, false, false);
    }

    @Override
    public Map<String, Map<String, Double>> getTokenPrice(String id, String contractAddress, String vsCurrencies, boolean includeMarketCap, boolean include24hrVol, boolean include24hrChange, boolean includeLastUpdatedAt) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getTokenPrice(id, contractAddress, vsCurrencies, includeMarketCap, include24hrVol, include24hrChange, includeLastUpdatedAt));
    }

    @Override
    public List<String> getSupportedVsCurrencies() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getSupportedVsCurrencies());
    }

    @Override
    public List<CoinList> getCoinList() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinList());
    }

    @Override
    public List<CoinMarkets> getCoinMarkets(String vsCurrency) {
        return this.getCoinMarkets(vsCurrency, null, null, null, null, false, null);
    }

    @Override
    public List<CoinMarkets> getCoinMarkets(String vsCurrency, String ids, String order, Integer perPage, Integer page, boolean sparkline, String priceChangePercentage) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinMarkets(vsCurrency, ids, order, perPage, page, sparkline, priceChangePercentage));
    }

    @Override
    public CoinFullData getCoinById(String id) {
        return this.getCoinById(id, true, true, true, true, true, false);
    }

    @Override
    public CoinFullData getCoinById(String id, boolean localization, boolean tickers, boolean marketData, boolean communityData, boolean developerData, boolean sparkline) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinById(id, localization, tickers, marketData, communityData, developerData, sparkline));
    }

    @Override
    public CoinTickerById getCoinTickerById(String id) {
        return this.getCoinTickerById(id, null, null, null);
    }

    @Override
    public CoinTickerById getCoinTickerById(String id, String exchangeIds, Integer page, String order) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinTickerById(id, exchangeIds, page, order));
    }

    @Override
    public CoinHistoryById getCoinHistoryById(String id, String date) {
        return this.getCoinHistoryById(id, date, true);
    }

    @Override
    public CoinHistoryById getCoinHistoryById(String id, String date, boolean localization) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinHistoryById(id, date, localization));
    }

    @Override
    public MarketChart getCoinMarketChartById(String id, String vsCurrency, Integer days) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinMarketChartById(id, vsCurrency, days));
    }

    @Override
    public MarketChart getCoinMarketChartById(String id, String vsCurrency, Integer days, String interval) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinMarketChartById(id, vsCurrency, days, interval));
    }

    @Override
    public MarketChart getCoinMarketChartRangeById(String id, String vsCurrency, String from, String to) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinMarketChartRangeById(id, vsCurrency, from, to));
    }

    @Override
    public List<List<String>> getCoinOHLC(String id, String vsCurrency, Integer days) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinOHLC(id, vsCurrency, days));
    }

    @Override
    public StatusUpdates getCoinStatusUpdateById(String id) {
        return this.getCoinStatusUpdateById(id, null, null);
    }

    @Override
    public StatusUpdates getCoinStatusUpdateById(String id, Integer perPage, Integer page) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinStatusUpdateById(id, perPage, page));
    }

    @Override
    public CoinFullData getCoinInfoByContractAddress(String id, String contractAddress) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getCoinInfoByContractAddress(id, contractAddress));
    }

    @Override
    public List<AssetPlatforms> getAssetPlatforms() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getAssetPlatforms());
    }

    @Override
    public List<Exchanges> getExchanges() {
        return this.getExchanges(100, 0);
    }

    @Override
    public List<Exchanges> getExchanges(int perPage, int page) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getExchanges(perPage, page));
    }

    @Override
    public List<ExchangesList> getExchangesList() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getExchangesList());
    }

    @Override
    public ExchangeById getExchangesById(String id) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getExchangesById(id));
    }

    @Override
    public ExchangesTickersById getExchangesTickersById(String id) {
        return this.getExchangesTickersById(id, null, null, null);
    }

    @Override
    public ExchangesTickersById getExchangesTickersById(String id, String coinIds, Integer page, String order) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getExchangesTickersById(id, coinIds, page, order));
    }

    @Override
    public StatusUpdates getExchangesStatusUpdatesById(String id) {
        return this.getExchangesStatusUpdatesById(id, null, null);
    }

    @Override
    public StatusUpdates getExchangesStatusUpdatesById(String id, Integer perPage, Integer page) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getExchangesStatusUpdatesById(id, perPage, page));
    }

    @Override
    public List<List<String>> getExchangesVolumeChart(String id, Integer days) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getExchangesVolumeChart(id, days));
    }

    @Override
    public StatusUpdates getStatusUpdates() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getStatusUpdates());
    }

    @Override
    public StatusUpdates getStatusUpdates(String category, String projectType, Integer perPage, Integer page) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getStatusUpdates(category, projectType, perPage, page));
    }

    @Override
    public Events getEvents() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getEvents());
    }

    @Override
    public Events getEvents(String countryCode, String type, Integer page, boolean upcomingEventsOnly, String fromDate, String toDate) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getEvents(countryCode, type, page, upcomingEventsOnly, fromDate, toDate));
    }

    @Override
    public EventCountries getEventsCountries() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getEventsCountries());
    }

    @Override
    public EventTypes getEventsTypes() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getEventsTypes());
    }

    @Override
    public ExchangeRates getExchangeRates() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getExchangeRates());
    }

    @Override
    public Trending getTrending() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getTrending());
    }

    @Override
    public Search getSearchResult(String query) {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getSearch(query));
    }

    @Override
    public Global getGlobal() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getGlobal());
    }

    @Override
    public DecentralizedFinanceDefi getDecentralizedFinanceDefi() {
        return this.coinGeckoApi.executeSync(this.coinGeckoApiService.getDecentralizedFinanceDefi());
    }

    @Override
    public void shutdown() {
        this.coinGeckoApi.shutdown();
    }
}

