/*
 * Decompiled with CFR 0.152.
 */
package com.litesoftwares.coingecko;

import com.litesoftwares.coingecko.domain.AssetPlatforms;
import com.litesoftwares.coingecko.domain.Coins.CoinFullData;
import com.litesoftwares.coingecko.domain.Coins.CoinHistoryById;
import com.litesoftwares.coingecko.domain.Coins.CoinList;
import com.litesoftwares.coingecko.domain.Coins.CoinMarkets;
import com.litesoftwares.coingecko.domain.Coins.CoinTickerById;
import com.litesoftwares.coingecko.domain.Coins.MarketChart;
import com.litesoftwares.coingecko.domain.Events.EventCountries;
import com.litesoftwares.coingecko.domain.Events.EventTypes;
import com.litesoftwares.coingecko.domain.Events.Events;
import com.litesoftwares.coingecko.domain.ExchangeRates.ExchangeRates;
import com.litesoftwares.coingecko.domain.Exchanges.ExchangeById;
import com.litesoftwares.coingecko.domain.Exchanges.Exchanges;
import com.litesoftwares.coingecko.domain.Exchanges.ExchangesList;
import com.litesoftwares.coingecko.domain.Exchanges.ExchangesTickersById;
import com.litesoftwares.coingecko.domain.Global.DecentralizedFinanceDefi;
import com.litesoftwares.coingecko.domain.Global.Global;
import com.litesoftwares.coingecko.domain.Ping;
import com.litesoftwares.coingecko.domain.Search.Search;
import com.litesoftwares.coingecko.domain.Search.Trending;
import com.litesoftwares.coingecko.domain.Status.StatusUpdates;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface CoinGeckoApiService {
    @GET(value="ping")
    public Call<Ping> ping();

    @GET(value="simple/price")
    public Call<Map<String, Map<String, Double>>> getPrice(@Query(value="ids") String var1, @Query(value="vs_currencies") String var2, @Query(value="include_market_cap") boolean var3, @Query(value="include_24hr_vol") boolean var4, @Query(value="include_24hr_change") boolean var5, @Query(value="include_last_updated_at") boolean var6);

    @GET(value="simple/token_price/{id}")
    public Call<Map<String, Map<String, Double>>> getTokenPrice(@Path(value="id") String var1, @Query(value="contract_addresses") String var2, @Query(value="vs_currencies") String var3, @Query(value="include_market_cap") boolean var4, @Query(value="include_24hr_vol") boolean var5, @Query(value="include_24hr_change") boolean var6, @Query(value="include_last_updated_at") boolean var7);

    @GET(value="simple/supported_vs_currencies")
    public Call<List<String>> getSupportedVsCurrencies();

    @GET(value="coins/list")
    public Call<List<CoinList>> getCoinList();

    @GET(value="coins/markets")
    public Call<List<CoinMarkets>> getCoinMarkets(@Query(value="vs_currency") String var1, @Query(value="ids") String var2, @Query(value="order") String var3, @Query(value="per_page") Integer var4, @Query(value="page") Integer var5, @Query(value="sparkline") boolean var6, @Query(value="price_change_percentage") String var7);

    @GET(value="coins/{id}")
    public Call<CoinFullData> getCoinById(@Path(value="id") String var1, @Query(value="localization") boolean var2, @Query(value="tickers") boolean var3, @Query(value="market_data") boolean var4, @Query(value="community_data") boolean var5, @Query(value="developer_data") boolean var6, @Query(value="sparkline") boolean var7);

    @GET(value="coins/{id}/tickers")
    public Call<CoinTickerById> getCoinTickerById(@Path(value="id") String var1, @Query(value="exchange_ids") String var2, @Query(value="page") Integer var3, @Query(value="order") String var4);

    @GET(value="coins/{id}/history")
    public Call<CoinHistoryById> getCoinHistoryById(@Path(value="id") String var1, @Query(value="date") String var2, @Query(value="localization") boolean var3);

    @GET(value="coins/{id}/market_chart")
    public Call<MarketChart> getCoinMarketChartById(@Path(value="id") String var1, @Query(value="vs_currency") String var2, @Query(value="days") Integer var3);

    @GET(value="coins/{id}/market_chart")
    public Call<MarketChart> getCoinMarketChartById(@Path(value="id") String var1, @Query(value="vs_currency") String var2, @Query(value="days") Integer var3, @Query(value="interval") String var4);

    @GET(value="coins/{id}/market_chart/range")
    public Call<MarketChart> getCoinMarketChartRangeById(@Path(value="id") String var1, @Query(value="vs_currency") String var2, @Query(value="from") String var3, @Query(value="to") String var4);

    @GET(value="coins/{id}/ohlc")
    public Call<List<List<String>>> getCoinOHLC(@Path(value="id") String var1, @Query(value="vs_currency") String var2, @Query(value="days") Integer var3);

    @GET(value="coins/{id}/status_updates")
    public Call<StatusUpdates> getCoinStatusUpdateById(@Path(value="id") String var1, @Query(value="per_page") Integer var2, @Query(value="page") Integer var3);

    @GET(value="coins/{id}/contract/{contract_address}")
    public Call<CoinFullData> getCoinInfoByContractAddress(@Path(value="id") String var1, @Path(value="contract_address") String var2);

    @GET(value="asset_platforms")
    public Call<List<AssetPlatforms>> getAssetPlatforms();

    @GET(value="exchanges")
    public Call<List<Exchanges>> getExchanges(@Query(value="per_page") int var1, @Query(value="page") int var2);

    @GET(value="exchanges/list")
    public Call<List<ExchangesList>> getExchangesList();

    @GET(value="exchanges/{id}")
    public Call<ExchangeById> getExchangesById(@Path(value="id") String var1);

    @GET(value="exchanges/{id}/tickers")
    public Call<ExchangesTickersById> getExchangesTickersById(@Path(value="id") String var1, @Query(value="coin_ids") String var2, @Query(value="page") Integer var3, @Query(value="order") String var4);

    @GET(value="exchanges/{id}/status_updates")
    public Call<StatusUpdates> getExchangesStatusUpdatesById(@Path(value="id") String var1, @Query(value="per_page") Integer var2, @Query(value="page") Integer var3);

    @GET(value="exchanges/{id}/volume_chart")
    public Call<List<List<String>>> getExchangesVolumeChart(@Path(value="id") String var1, @Query(value="days") Integer var2);

    @GET(value="status_updates")
    public Call<StatusUpdates> getStatusUpdates();

    @GET(value="status_updates")
    public Call<StatusUpdates> getStatusUpdates(@Query(value="category") String var1, @Query(value="project_type") String var2, @Query(value="per_page") Integer var3, @Query(value="page") Integer var4);

    @GET(value="events")
    public Call<Events> getEvents();

    @GET(value="events")
    public Call<Events> getEvents(@Query(value="country_code") String var1, @Query(value="type") String var2, @Query(value="page") Integer var3, @Query(value="upcoming_events_only") boolean var4, @Query(value="from_date") String var5, @Query(value="to_date") String var6);

    @GET(value="events/countries")
    public Call<EventCountries> getEventsCountries();

    @GET(value="events/types")
    public Call<EventTypes> getEventsTypes();

    @GET(value="exchange_rates")
    public Call<ExchangeRates> getExchangeRates();

    @GET(value="search/trending")
    public Call<Trending> getTrending();

    @GET(value="search")
    public Call<Search> getSearch(@Query(value="query") String var1);

    @GET(value="global")
    public Call<Global> getGlobal();

    @GET(value="global/decentralized_finance_defi")
    public Call<DecentralizedFinanceDefi> getDecentralizedFinanceDefi();
}

