/*
 * Decompiled with CFR 0.152.
 */
package com.litesoftwares.coingecko;

import com.litesoftwares.coingecko.CoinGeckoApiError;
import com.litesoftwares.coingecko.exception.CoinGeckoApiException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class CoinGeckoApi {
    private final String API_BASE_URL = "https://api.coingecko.com/api/v3/";
    private OkHttpClient okHttpClient = null;
    private Retrofit retrofit = null;

    public <S> S createService(Class<S> serviceClass, Long connectionTimeoutSeconds, Long readTimeoutSeconds, Long writeTimeoutSeconds) {
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(connectionTimeoutSeconds.longValue(), TimeUnit.SECONDS).readTimeout(readTimeoutSeconds.longValue(), TimeUnit.SECONDS).writeTimeout(writeTimeoutSeconds.longValue(), TimeUnit.SECONDS).build();
        this.retrofit = new Retrofit.Builder().baseUrl("https://api.coingecko.com/api/v3/").client(this.okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        return (S)this.retrofit.create(serviceClass);
    }

    public <T> T executeSync(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                Object object = response.body();
                return (T)object;
            }
            try {
                if (response.code() == 429) {
                    CoinGeckoApiError apiError = new CoinGeckoApiError();
                    apiError.setCode(1015);
                    apiError.setMessage("Rate limited");
                    throw new CoinGeckoApiException(apiError);
                }
                try {
                    CoinGeckoApiError apiError = this.getCoinGeckoApiError(response);
                    apiError.setCode(response.code());
                    throw new CoinGeckoApiException(apiError);
                }
                catch (IOException e) {
                    throw new CoinGeckoApiException(response.toString(), e);
                }
            }
            catch (IOException e) {
                throw new CoinGeckoApiException(e);
            }
        }
        finally {
            this.shutdown();
        }
    }

    public void shutdown() {
        if (this.okHttpClient != null) {
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
        }
    }

    private CoinGeckoApiError getCoinGeckoApiError(Response<?> response) throws IOException {
        return (CoinGeckoApiError)this.retrofit.responseBodyConverter(CoinGeckoApiError.class, new Annotation[0]).convert((Object)response.errorBody());
    }
}

