/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.maven.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.ossindex.common.VulnerabilityDescriptor;
import net.ossindex.maven.utils.DependencyAuditor;
import net.ossindex.maven.utils.MavenIdWrapper;
import net.ossindex.maven.utils.MavenPackageDescriptor;
import net.ossindex.maven.utils.OssIndexResultsWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Mojo(name="audit")
public class OssIndexMojo
extends AbstractMojo {
    private static List<MavenPackageDescriptor> results = new LinkedList<MavenPackageDescriptor>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="audit.ignore", defaultValue="")
    private String ignore;
    private Set<String> ignoreSet = new HashSet<String>();
    @Parameter(property="audit.failOnError", defaultValue="true")
    private String failOnError;
    @Parameter(property="audit.output", defaultValue="")
    private String output;
    @Parameter(property="audit.quiet", defaultValue="false")
    private String quiet;
    @Parameter(property="audit.warnOnIgnore", defaultValue="false")
    private String warnOnIgnore;
    private Set<File> outputFiles = new HashSet<File>();
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    private long start;
    private int failedPackages;
    private int failures;
    private int ignored;
    private int dependencies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] tokens;
        this.start = System.currentTimeMillis();
        List<Proxy> proxies = new LinkedList();
        if (this.settings != null && (proxies = this.settings.getProxies()) != null && proxies.size() > 0) {
            this.getLog().debug((CharSequence)"Using proxy");
        }
        MavenIdWrapper moduleId = new MavenIdWrapper();
        moduleId.setGroupId(this.project.getGroupId());
        moduleId.setArtifactId(this.project.getArtifactId());
        moduleId.setVersion(this.project.getVersion());
        if (this.ignore != null) {
            this.ignore = this.ignore.trim();
            if (!this.ignore.isEmpty()) {
                for (String token : tokens = this.ignore.split(",")) {
                    this.ignoreSet.add(token.trim());
                }
            }
        }
        if (this.output != null) {
            this.output = this.output.trim();
            if (!this.output.isEmpty()) {
                for (String token : tokens = this.output.split(",")) {
                    this.outputFiles.add(new File(token));
                }
            }
        }
        try (DependencyAuditor auditor = new DependencyAuditor(proxies);){
            if (!"true".equalsIgnoreCase(this.quiet)) {
                this.getLog().info((CharSequence)"OSS Index dependency audit");
            }
            int failures = 0;
            ArtifactFilter artifactFilter = null;
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, artifactFilter);
            List depNodes = rootNode.getChildren();
            for (DependencyNode dep : depNodes) {
                Artifact artifact = dep.getArtifact();
                auditor.add(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), dep);
            }
            Collection<MavenPackageDescriptor> results = auditor.run();
            for (MavenPackageDescriptor pkg : results) {
                MavenIdWrapper parentPkg;
                ++this.dependencies;
                pkg.setModule(moduleId);
                String idPkg = pkg.getMavenPackageId();
                String idVer = pkg.getMavenVersionId();
                if (!this.ignoreSet.contains(idPkg) && !this.ignoreSet.contains(idVer)) {
                    parentPkg = pkg.getParent();
                    int pkgFailures = this.report(parentPkg, pkg);
                    if (pkgFailures <= 0) continue;
                    ++this.failedPackages;
                    failures += pkgFailures;
                    this.failures += pkgFailures;
                    continue;
                }
                ++this.ignored;
                if (!"true".equalsIgnoreCase(this.warnOnIgnore)) continue;
                parentPkg = pkg.getParent();
                this.report(parentPkg, pkg, false);
            }
            OssIndexMojo.results.addAll(results);
            for (File file : this.outputFiles) {
                if (file.getName().endsWith(".txt")) {
                    this.exportTxt(file, OssIndexMojo.results);
                }
                if (file.getName().endsWith(".json")) {
                    this.exportJson(file, OssIndexMojo.results);
                }
                if (!file.getName().endsWith(".xml")) continue;
                this.exportXml(file, OssIndexMojo.results);
            }
        }
        if ("true".equalsIgnoreCase(this.quiet)) {
            this.logSummary();
        }
        if (this.failures > 0 && "true".equals(this.failOnError)) {
            throw new MojoFailureException(this.failures + " known vulnerabilities affecting project dependencies");
        }
    }

    private void logSummary() {
        StringBuilder sb = new StringBuilder();
        long end = System.currentTimeMillis();
        long diff = end - this.start;
        sb.append("Audited packages: ").append(this.dependencies);
        sb.append(", Ignored: ").append(this.ignored);
        sb.append(", Vulnerable: ").append(this.failedPackages);
        sb.append(" [").append(this.failures).append(" issues]");
        sb.append(", Time elapsed: ").append(diff).append(" ms");
        this.getLog().info((CharSequence)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTxt(File file, Collection<MavenPackageDescriptor> results) {
        MavenIdWrapper lastModule = null;
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(file));
            for (MavenPackageDescriptor pkg : results) {
                List<VulnerabilityDescriptor> vulnerabilities;
                MavenIdWrapper parentPkg = pkg.getParent();
                MavenIdWrapper module = pkg.getModule();
                String pkgId = pkg.getMavenVersionId();
                int total = pkg.getVulnerabilityTotal();
                if (!module.equals(lastModule)) {
                    out.println();
                    out.println("==============================================================");
                    out.println(module);
                    out.println("==============================================================");
                    lastModule = module;
                }
                if ((vulnerabilities = pkg.getVulnerabilities()) != null && !vulnerabilities.isEmpty()) {
                    int matches = pkg.getVulnerabilityMatches();
                    out.println();
                    out.println("--------------------------------------------------------------");
                    out.println(pkgId + "  [VULNERABLE]");
                    if (parentPkg != null) {
                        String parentId = parentPkg.getMavenVersionId();
                        out.println("  required by " + parentId);
                    }
                    out.println(total + " known vulnerabilities, " + matches + " affecting installed version");
                    out.println("");
                    for (VulnerabilityDescriptor vulnerability : vulnerabilities) {
                        out.println(vulnerability.getTitle());
                        out.println(vulnerability.getUriString());
                        out.println(vulnerability.getDescription());
                        out.println("");
                    }
                    out.println("--------------------------------------------------------------");
                    out.println();
                    continue;
                }
                if (total > 0) {
                    out.println(pkgId + ": " + total + " known vulnerabilities, 0 affecting installed version");
                    continue;
                }
                out.println(pkgId + ": No known vulnerabilities");
            }
        }
    }

    private void exportJson(File file, Collection<MavenPackageDescriptor> results) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        String json = gson.toJson(results);
        try {
            FileUtils.writeStringToFile((File)file, (String)json);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Cannot export to " + file + ": " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportXml(File file, Collection<MavenPackageDescriptor> results) {
        OssIndexResultsWrapper wrapper = new OssIndexResultsWrapper(results);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{OssIndexResultsWrapper.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)wrapper, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            this.getLog().warn((CharSequence)("Cannot export to " + file + ": " + e.getMessage()));
        }
        catch (JAXBException e) {
            this.getLog().debug((Throwable)e);
            this.getLog().warn((CharSequence)("Cannot export to " + file + ": " + e.getMessage()));
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Exception closing " + file + ": " + e.getMessage()));
                }
            }
        }
    }

    private int report(MavenIdWrapper parentPkg, MavenPackageDescriptor pkg) throws IOException {
        return this.report(parentPkg, pkg, true);
    }

    private int report(MavenIdWrapper parentPkg, MavenPackageDescriptor pkg, boolean logToError) throws IOException {
        int failures = 0;
        String pkgId = pkg.getMavenVersionId();
        int total = pkg.getVulnerabilityTotal();
        List<VulnerabilityDescriptor> vulnerabilities = pkg.getVulnerabilities();
        if (vulnerabilities != null && !vulnerabilities.isEmpty()) {
            int matches = pkg.getVulnerabilityMatches();
            if (logToError) {
                this.getLog().error((CharSequence)"");
                this.getLog().error((CharSequence)"--------------------------------------------------------------");
                this.getLog().error((CharSequence)(pkgId + "  [VULNERABLE]"));
            } else {
                this.getLog().warn((CharSequence)"");
                this.getLog().warn((CharSequence)"--------------------------------------------------------------");
                this.getLog().warn((CharSequence)(pkgId + "  [VULNERABLE]"));
            }
            if (parentPkg != null) {
                String parentId = parentPkg.getMavenVersionId();
                if (logToError) {
                    this.getLog().error((CharSequence)("  required by " + parentId));
                } else {
                    this.getLog().warn((CharSequence)("  required by " + parentId));
                }
            }
            if (logToError) {
                this.getLog().error((CharSequence)(total + " known vulnerabilities, " + matches + " affecting installed version"));
                this.getLog().error((CharSequence)"");
            } else {
                this.getLog().warn((CharSequence)(total + " known vulnerabilities, " + matches + " affecting installed version"));
                this.getLog().warn((CharSequence)"");
            }
            for (VulnerabilityDescriptor vulnerability : vulnerabilities) {
                if (logToError) {
                    this.getLog().error((CharSequence)vulnerability.getTitle());
                    this.getLog().error((CharSequence)vulnerability.getUriString());
                    this.getLog().error((CharSequence)vulnerability.getDescription());
                    this.getLog().error((CharSequence)"");
                    continue;
                }
                this.getLog().warn((CharSequence)vulnerability.getTitle());
                this.getLog().warn((CharSequence)vulnerability.getUriString());
                this.getLog().warn((CharSequence)vulnerability.getDescription());
                this.getLog().warn((CharSequence)"");
            }
            if (logToError) {
                this.getLog().error((CharSequence)"--------------------------------------------------------------");
                this.getLog().error((CharSequence)"");
            } else {
                this.getLog().warn((CharSequence)"--------------------------------------------------------------");
                this.getLog().warn((CharSequence)"");
            }
            failures += matches;
        } else if (!"true".equalsIgnoreCase(this.quiet)) {
            if (total > 0) {
                this.getLog().info((CharSequence)(pkgId + " - " + total + " known vulnerabilities, 0 affecting installed version"));
            } else {
                this.getLog().info((CharSequence)(pkgId + " - No known vulnerabilities"));
            }
        }
        return failures;
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
    }
}

