/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.maven.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ossindex.common.IPackageRequest;
import net.ossindex.common.OssIndexApi;
import net.ossindex.common.PackageDescriptor;
import net.ossindex.maven.utils.MavenIdWrapper;
import net.ossindex.maven.utils.MavenPackageDescriptor;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class DependencyAuditor {
    private Map<PackageDescriptor, PackageDescriptor> parents = new HashMap<PackageDescriptor, PackageDescriptor>();
    private IPackageRequest request = OssIndexApi.createPackageRequest();

    public void add(String groupId, String artifactId, String version, DependencyNode dep) {
        PackageDescriptor parent = this.request.add("maven", groupId, artifactId, version);
        this.parents.put(parent, null);
        this.addPackageDependencies(parent, groupId, artifactId, version, dep);
    }

    private List<PackageDescriptor> addPackageDependencies(PackageDescriptor parent, String groupId, String artifactId, String version, DependencyNode parentDep) {
        LinkedList<PackageDescriptor> packageDependency = new LinkedList<PackageDescriptor>();
        List children = parentDep.getChildren();
        if (children != null) {
            for (DependencyNode node : children) {
                CollectingDependencyNodeVisitor nlg = new CollectingDependencyNodeVisitor();
                node.accept((DependencyNodeVisitor)nlg);
                List deps = nlg.getNodes();
                for (DependencyNode dep : deps) {
                    Artifact artifact = dep.getArtifact();
                    PackageDescriptor pkgDep = new PackageDescriptor("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                    if (this.parents.containsKey(pkgDep)) continue;
                    pkgDep = this.request.add("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                    this.parents.put(pkgDep, parent);
                    packageDependency.add(pkgDep);
                }
            }
        }
        return packageDependency;
    }

    public Collection<MavenPackageDescriptor> run() throws IOException {
        LinkedList<MavenPackageDescriptor> results = new LinkedList<MavenPackageDescriptor>();
        Collection packages = this.request.run();
        for (PackageDescriptor pkg : packages) {
            PackageDescriptor parent;
            MavenPackageDescriptor mvnPkg = new MavenPackageDescriptor(pkg);
            if (this.parents.containsKey(pkg) && (parent = this.parents.get(pkg)) != null) {
                mvnPkg.setParent(new MavenIdWrapper(parent));
            }
            results.add(mvnPkg);
        }
        return results;
    }

    public void close() {
    }
}

