/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.maven.plugin;

import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.ossindex.common.resource.ScmResource;
import net.ossindex.common.resource.VulnerabilityResource;
import net.ossindex.common.utils.PackageDependency;
import net.ossindex.maven.utils.DependencyAuditor;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="audit")
public class OssIndexMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> projectRepos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try (DependencyAuditor auditor = new DependencyAuditor(this.repoSystem, this.repoSession);){
            this.getLog().info((CharSequence)"OSS Index dependency audit");
            int failures = 0;
            List deps = this.project.getDependencies();
            for (Dependency dep : deps) {
                try {
                    Collection<PackageDependency> auditedDependencies = auditor.auditArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
                    for (PackageDependency adep : auditedDependencies) {
                        failures += this.report(adep);
                    }
                }
                catch (SocketException e) {
                    this.getLog().error((CharSequence)e.getMessage());
                    break;
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Exception auditing dependency " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion()), (Throwable)e);
                }
            }
            if (failures > 0) {
                throw new MojoFailureException(failures + " known vulnerabilities affecting project dependencies");
            }
        }
    }

    private int report(PackageDependency adep) throws IOException {
        int failures = 0;
        String pkgId = adep.getId();
        ScmResource scm = adep.getScm();
        if (scm != null) {
            VulnerabilityResource[] vulnerabilities = scm.getVulnerabilities();
            if (vulnerabilities != null) {
                if (vulnerabilities.length > 0) {
                    LinkedList<VulnerabilityResource> myVulnerabilities = new LinkedList<VulnerabilityResource>();
                    for (VulnerabilityResource vulnerability : vulnerabilities) {
                        if (vulnerability.appliesTo(adep.getVersion())) {
                            myVulnerabilities.add(vulnerability);
                        }
                        URI uri = vulnerability.getUri();
                        String string = vulnerability.getDescription();
                    }
                    if (myVulnerabilities.isEmpty()) {
                        this.getLog().info((CharSequence)(pkgId + "  " + vulnerabilities.length + " known vulnerabilities, 0 affecting installed version"));
                    } else {
                        this.getLog().error((CharSequence)"");
                        this.getLog().error((CharSequence)"--------------------------------------------------------------");
                        this.getLog().error((CharSequence)(pkgId + "  [VULNERABLE]"));
                        this.getLog().error((CharSequence)(vulnerabilities.length + " known vulnerabilities, " + myVulnerabilities.size() + " affecting installed version"));
                        this.getLog().error((CharSequence)"");
                        for (VulnerabilityResource vulnerability : myVulnerabilities) {
                            this.getLog().error((CharSequence)vulnerability.getUri().toString());
                            this.getLog().error((CharSequence)vulnerability.getDescription());
                            this.getLog().error((CharSequence)"");
                        }
                        this.getLog().error((CharSequence)"--------------------------------------------------------------");
                        this.getLog().error((CharSequence)"");
                        failures += myVulnerabilities.size();
                    }
                } else {
                    this.getLog().info((CharSequence)(pkgId + "  No known vulnerabilities"));
                }
            } else {
                this.getLog().info((CharSequence)(pkgId + "  No known vulnerabilities"));
            }
        } else {
            this.getLog().info((CharSequence)(pkgId + "  Unknown source for package"));
        }
        return failures;
    }
}

