/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.maven.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.ossindex.common.IOssIndexCache;
import net.ossindex.common.ResourceFactory;
import net.ossindex.common.cache.MapDbCache;
import net.ossindex.common.resource.ArtifactResource;
import net.ossindex.common.resource.ScmResource;
import net.ossindex.common.utils.PackageDependency;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

public class DependencyAuditor {
    private RepositorySystem repoSystem;
    private RepositorySystemSession session;

    DependencyAuditor() {
        File root = this.getCacheDir();
        if (root != null) {
            ResourceFactory.getResourceFactory().setCache((IOssIndexCache)new MapDbCache(this.getCacheDir()));
        }
    }

    public DependencyAuditor(RepositorySystem repoSystem, RepositorySystemSession session) {
        File root = this.getCacheDir();
        if (root != null) {
            ResourceFactory.getResourceFactory().setCache((IOssIndexCache)new MapDbCache(this.getCacheDir()));
        }
        this.repoSystem = repoSystem;
        this.session = session;
    }

    private File getCacheDir() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File root = new File(tmp, "ossindex.cache");
        if (tmp.exists()) {
            if (!root.exists()) {
                root.mkdirs();
            }
            if (root.exists() && root.isDirectory()) {
                return root;
            }
        }
        return null;
    }

    public Collection<PackageDependency> auditArtifact(String groupId, String artifactId, String version) throws IOException {
        List<PackageDependency> deps = this.getPackageDependencies(groupId, artifactId, version);
        this.setDependencyInformation(deps.toArray(new PackageDependency[deps.size()]));
        return deps;
    }

    private List<PackageDependency> getPackageDependencies(String groupId, String artifactId, String version) {
        LinkedList<PackageDependency> packageDependency = new LinkedList<PackageDependency>();
        String aid = groupId + ":" + artifactId + ":";
        if (version != null) {
            aid = aid + version;
        }
        Dependency dependency = new Dependency((Artifact)new DefaultArtifact(aid), "compile");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        try {
            DependencyNode node = this.repoSystem.collectDependencies(this.session, collectRequest).getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            this.repoSystem.resolveDependencies(this.session, dependencyRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            List artifacts = nlg.getArtifacts(false);
            for (Artifact artifact : artifacts) {
                PackageDependency pkgDep = new PackageDependency("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                packageDependency.add(pkgDep);
            }
        }
        catch (DependencyCollectionException | DependencyResolutionException throwable) {
            // empty catch block
        }
        return packageDependency;
    }

    void setDependencyInformation(PackageDependency[] pkgs) throws IOException {
        ArtifactResource[] artifactMatches = ResourceFactory.getResourceFactory().findArtifactResources(pkgs);
        HashMap<String, ArtifactResource> matches = new HashMap<String, ArtifactResource>();
        for (ArtifactResource artifact : artifactMatches) {
            if (artifact == null) continue;
            String name = artifact.getPackageName();
            if (!matches.containsKey(name)) {
                matches.put(name, artifact);
                continue;
            }
            ArtifactResource ar = (ArtifactResource)matches.get(name);
            if (artifact.compareTo(ar) <= 0) continue;
            matches.put(name, artifact);
        }
        LinkedList<PackageDependency> packages = new LinkedList<PackageDependency>();
        LinkedList<Long> scmIds = new LinkedList<Long>();
        for (PackageDependency pkg : pkgs) {
            ArtifactResource artifact;
            long scmId;
            String pkgName = pkg.getName();
            if (!matches.containsKey(pkgName) || (scmId = (artifact = (ArtifactResource)matches.get(pkg.getName())).getScmId()) <= 0L) continue;
            pkg.setArtifact(artifact);
            packages.add(pkg);
            scmIds.add(artifact.getScmId());
        }
        Long[] tmp = scmIds.toArray(new Long[scmIds.size()]);
        ScmResource[] scmResources = ResourceFactory.getResourceFactory().findScmResources(ArrayUtils.toPrimitive((Long[])tmp));
        if (scmResources == null) {
            return;
        }
        for (int i = 0; i < packages.size(); ++i) {
            PackageDependency pkg;
            pkg = (PackageDependency)packages.get(i);
            pkg.setScm(scmResources[i]);
            if (pkg.equals((Object)pkgs[0])) continue;
            pkg.setParent(pkgs[0]);
        }
    }

    public void close() {
        ResourceFactory.getResourceFactory().closeCache();
    }
}

