/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.map.mutable.AbstractMutableMap;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.MapIterate;

public class MapAdapter<K, V>
extends AbstractMutableMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<K, V> delegate;

    protected MapAdapter(Map<K, V> newDelegate) {
        if (newDelegate == null) {
            throw new NullPointerException("MapAdapter may not wrap null");
        }
        this.delegate = newDelegate;
    }

    public static <K, V> MutableMap<K, V> adapt(Map<K, V> map2) {
        return map2 instanceof MutableMap ? (MutableMap)map2 : new MapAdapter<K, V>(map2);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public MutableMap<K, V> clone() {
        return UnifiedMap.newMap(this.delegate);
    }

    @Override
    public <K, V> MutableMap<K, V> newEmpty(int capacity) {
        return UnifiedMap.newMap(capacity);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<V> iterator() {
        return this.delegate.values().iterator();
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public MutableMap<K, V> newEmpty() {
        return UnifiedMap.newMap();
    }

    @Override
    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        MapIterate.forEachKeyValue(this.delegate, procedure);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        this.delegate.putAll(map2);
    }

    @Override
    public <E> MutableMap<K, V> collectKeysAndValues(Iterable<E> iterable, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> valueFunction) {
        Iterate.addToMap(iterable, keyFunction, valueFunction, this.delegate);
        return this;
    }

    @Override
    public V removeKey(K key) {
        return this.delegate.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public ImmutableMap<K, V> toImmutable() {
        return Maps.immutable.ofMap(this);
    }
}

