/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableCharObjectMapFactory;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.impl.factory.primitive.CharObjectMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectSingletonMap;

public enum ImmutableCharObjectMapFactoryImpl implements ImmutableCharObjectMapFactory
{
    INSTANCE;


    @Override
    public <V> ImmutableCharObjectMap<V> empty() {
        return ImmutableCharObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableCharObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableCharObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableCharObjectMap<V> of(char key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableCharObjectMap<V> with(char key, V value) {
        return new ImmutableCharObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableCharObjectMap<V> ofAll(CharObjectMap<? extends V> map2) {
        return this.withAll(map2);
    }

    @Override
    public <V> ImmutableCharObjectMap<V> withAll(CharObjectMap<? extends V> map2) {
        if (map2 instanceof ImmutableCharObjectMap) {
            return (ImmutableCharObjectMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            char[] array = new char[1];
            map2.forEachKey(each2 -> {
                array[0] = each2;
            });
            return new ImmutableCharObjectSingletonMap<V>(array[0], map2.get(array[0]));
        }
        return new ImmutableCharObjectHashMap<V>(map2);
    }

    @Override
    public <T, V> ImmutableCharObjectMap<V> from(Iterable<T> iterable, CharFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableCharObjectMap<V> map2 = CharObjectMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map2.toImmutable();
    }
}

