/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.bag.sorted;

import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.ImmutableBagIterable;
import org.eclipse.collections.api.bag.sorted.SortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.sortedbag.ImmutableSortedBagMultimap;
import org.eclipse.collections.api.partition.bag.sorted.PartitionImmutableSortedBag;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;

public interface ImmutableSortedBag<T>
extends ImmutableBagIterable<T>,
SortedBag<T> {
    @Override
    public ImmutableSortedBag<T> newWith(T var1);

    @Override
    public ImmutableSortedBag<T> newWithout(T var1);

    @Override
    public ImmutableSortedBag<T> newWithAll(Iterable<? extends T> var1);

    @Override
    public ImmutableSortedBag<T> newWithoutAll(Iterable<? extends T> var1);

    @Override
    public ImmutableSortedBag<T> selectByOccurrences(IntPredicate var1);

    @Override
    default public ImmutableSortedBag<T> selectDuplicates() {
        return this.selectByOccurrences(occurrences -> occurrences > 1);
    }

    @Override
    default public ImmutableSortedSet<T> selectUnique() {
        throw new UnsupportedOperationException("Adding default implementation so as to not break compatibility");
    }

    @Override
    public ImmutableSortedBag<T> tap(Procedure<? super T> var1);

    @Override
    public ImmutableSortedBag<T> select(Predicate<? super T> var1);

    @Override
    public <P> ImmutableSortedBag<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public ImmutableSortedBag<T> reject(Predicate<? super T> var1);

    @Override
    public <P> ImmutableSortedBag<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionImmutableSortedBag<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionImmutableSortedBag<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> ImmutableSortedBag<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> ImmutableList<V> collect(Function<? super T, ? extends V> var1);

    @Override
    default public <V> ImmutableList<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each2) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each2, n);
        });
    }

    @Override
    public ImmutableBooleanList collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public ImmutableByteList collectByte(ByteFunction<? super T> var1);

    @Override
    public ImmutableCharList collectChar(CharFunction<? super T> var1);

    @Override
    public ImmutableDoubleList collectDouble(DoubleFunction<? super T> var1);

    @Override
    public ImmutableFloatList collectFloat(FloatFunction<? super T> var1);

    @Override
    public ImmutableIntList collectInt(IntFunction<? super T> var1);

    @Override
    public ImmutableLongList collectLong(LongFunction<? super T> var1);

    @Override
    public ImmutableShortList collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> ImmutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> ImmutableList<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> ImmutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> ImmutableList<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each2) -> (Iterable)function.apply((Object)each2, (Object)parameter));
    }

    @Override
    public ImmutableSortedSet<T> distinct();

    @Override
    public ImmutableSortedBag<T> takeWhile(Predicate<? super T> var1);

    @Override
    public ImmutableSortedBag<T> dropWhile(Predicate<? super T> var1);

    @Override
    default public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.asLazy().collect((Function)function).toBag().toImmutable();
    }

    @Override
    default public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.asLazy().collectWith((Function2)function, (Object)parameter).toBag().toImmutable();
    }

    @Override
    public <V> ImmutableSortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> ImmutableSortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public <K, V> ImmutableMap<K, V> aggregateBy(Function<? super T, ? extends K> var1, Function0<? extends V> var2, Function2<? super V, ? super T, ? extends V> var3);

    @Override
    public <K, V> ImmutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> var1, Function0<? extends V> var2, Procedure2<? super V, ? super T> var3);

    @Override
    public <S> ImmutableList<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public ImmutableSortedSet<Pair<T, Integer>> zipWithIndex();

    @Override
    public MutableSortedMap<T, Integer> toMapOfItemToCount();

    @Override
    public ImmutableSortedBag<T> toReversed();

    @Override
    public ImmutableSortedBag<T> take(int var1);

    @Override
    public ImmutableSortedBag<T> drop(int var1);
}

