/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.print.PrintException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.TreeLayout;
import org.abego.treelayout.util.DefaultConfiguration;
import org.antlr.v4.runtime.misc.GraphicsSupport;
import org.antlr.v4.runtime.misc.JFileChooserConfirmOverwrite;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;
import org.antlr.v4.runtime.tree.gui.TreeLayoutAdaptor;
import org.antlr.v4.runtime.tree.gui.TreeTextProvider;

public class TreeViewer
extends JComponent {
    public static final Color LIGHT_RED = new Color(244, 213, 211);
    protected TreeTextProvider treeTextProvider;
    protected TreeLayout<Tree> treeLayout;
    protected List<Tree> highlightedNodes;
    protected String fontName = "Helvetica";
    protected int fontStyle = 0;
    protected int fontSize = 11;
    protected Font font = new Font(this.fontName, this.fontStyle, this.fontSize);
    protected double gapBetweenLevels = 17.0;
    protected double gapBetweenNodes = 7.0;
    protected int nodeWidthPadding = 2;
    protected int nodeHeightPadding = 0;
    protected int arcSize = 0;
    protected double scale = 1.0;
    protected Color boxColor = null;
    protected Color highlightedBoxColor = Color.lightGray;
    protected Color borderColor = null;
    protected Color textColor = Color.black;
    private boolean useCurvedEdges = false;

    public TreeViewer(List<String> ruleNames, Tree tree) {
        this.setRuleNames(ruleNames);
        if (tree != null) {
            this.setTree(tree);
        }
        this.setFont(this.font);
    }

    private void updatePreferredSize() {
        this.setPreferredSize(this.getScaledTreeSize());
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    public boolean getUseCurvedEdges() {
        return this.useCurvedEdges;
    }

    public void setUseCurvedEdges(boolean useCurvedEdges) {
        this.useCurvedEdges = useCurvedEdges;
    }

    protected void paintEdges(Graphics g2, Tree parent) {
        if (!this.getTree().isLeaf(parent)) {
            BasicStroke stroke = new BasicStroke(1.0f, 1, 1);
            ((Graphics2D)g2).setStroke(stroke);
            Rectangle2D.Double parentBounds = this.getBoundsOfNode(parent);
            double x1 = parentBounds.getCenterX();
            double y1 = parentBounds.getMaxY();
            for (Tree child : this.getTree().getChildren(parent)) {
                Rectangle2D.Double childBounds = this.getBoundsOfNode(child);
                double x2 = childBounds.getCenterX();
                double y2 = childBounds.getMinY();
                if (this.getUseCurvedEdges()) {
                    CubicCurve2D.Double c = new CubicCurve2D.Double();
                    double ctrlx1 = x1;
                    double ctrly1 = (y1 + y2) / 2.0;
                    double ctrlx2 = x2;
                    double ctrly2 = y1;
                    ((CubicCurve2D)c).setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
                    ((Graphics2D)g2).draw(c);
                } else {
                    g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                }
                this.paintEdges(g2, child);
            }
        }
    }

    protected void paintBox(Graphics g2, Tree tree) {
        Rectangle2D.Double box = this.getBoundsOfNode(tree);
        if (this.isHighlighted(tree) || this.boxColor != null || tree instanceof ErrorNode) {
            if (this.isHighlighted(tree)) {
                g2.setColor(this.highlightedBoxColor);
            } else if (tree instanceof ErrorNode) {
                g2.setColor(LIGHT_RED);
            } else {
                g2.setColor(this.boxColor);
            }
            g2.fillRoundRect((int)box.x, (int)box.y, (int)box.width - 1, (int)box.height - 1, this.arcSize, this.arcSize);
        }
        if (this.borderColor != null) {
            g2.setColor(this.borderColor);
            g2.drawRoundRect((int)box.x, (int)box.y, (int)box.width - 1, (int)box.height - 1, this.arcSize, this.arcSize);
        }
        g2.setColor(this.textColor);
        String s2 = this.getText(tree);
        String[] lines = s2.split("\n");
        FontMetrics m3 = this.getFontMetrics(this.font);
        int x = (int)box.x + this.arcSize / 2 + this.nodeWidthPadding;
        int y = (int)box.y + m3.getAscent() + m3.getLeading() + 1 + this.nodeHeightPadding;
        for (int i = 0; i < lines.length; ++i) {
            this.text(g2, lines[i], x, y);
            y += m3.getHeight();
        }
    }

    public void text(Graphics g2, String s2, int x, int y) {
        s2 = Utils.escapeWhitespace(s2, true);
        g2.drawString(s2, x, y);
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.treeLayout == null) {
            return;
        }
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paintEdges(g2, this.getTree().getRoot());
        for (Tree Tree2 : this.treeLayout.getNodeBounds().keySet()) {
            this.paintBox(g2, Tree2);
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        g2d.scale(this.scale, this.scale);
        return super.getComponentGraphics(g2d);
    }

    protected static JDialog showInDialog(final TreeViewer viewer) {
        final JDialog dialog = new JDialog();
        dialog.setTitle("Parse Tree Inspector");
        JPanel mainPane = new JPanel(new BorderLayout(5, 5));
        JPanel contentPane = new JPanel(new BorderLayout(0, 0));
        ((Component)contentPane).setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane(viewer);
        contentPane.add((Component)scrollPane, "Center");
        JPanel wrapper = new JPanel(new FlowLayout());
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 0));
        contentPane.add((Component)bottomPanel, "South");
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        wrapper.add(ok);
        JButton png = new JButton("png");
        png.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeViewer.generatePNGFile(viewer, dialog);
            }
        });
        wrapper.add(png);
        bottomPanel.add((Component)wrapper, "South");
        int sliderValue = (int)((viewer.getScale() - 1.0) * 1000.0);
        final JSlider scaleSlider = new JSlider(0, -999, 1000, sliderValue);
        scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int v = scaleSlider.getValue();
                viewer.setScale((double)v / 1000.0 + 1.0);
            }
        });
        bottomPanel.add((Component)scaleSlider, "Center");
        JPanel treePanel = new JPanel(new BorderLayout(5, 5));
        EmptyIcon empty = new EmptyIcon();
        UIManager.put("Tree.closedIcon", empty);
        UIManager.put("Tree.openIcon", empty);
        UIManager.put("Tree.leafIcon", empty);
        Tree parseTreeRoot = viewer.getTree().getRoot();
        TreeNodeWrapper nodeRoot = new TreeNodeWrapper(parseTreeRoot, viewer);
        TreeViewer.fillTree(nodeRoot, parseTreeRoot, viewer);
        JTree tree = new JTree(nodeRoot);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JTree selectedTree = (JTree)e.getSource();
                TreePath path = selectedTree.getSelectionPath();
                TreeNodeWrapper treeNode = (TreeNodeWrapper)path.getLastPathComponent();
                viewer.setTree((Tree)treeNode.getUserObject());
            }
        });
        treePanel.add(new JScrollPane(tree));
        JSplitPane splitPane = new JSplitPane(1, treePanel, contentPane);
        mainPane.add((Component)splitPane, "Center");
        dialog.setContentPane(mainPane);
        dialog.setDefaultCloseOperation(2);
        dialog.setPreferredSize(new Dimension(600, 500));
        dialog.pack();
        splitPane.setDividerLocation(0.33);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        return dialog;
    }

    private static void generatePNGFile(TreeViewer viewer, JDialog dialog) {
        BufferedImage bi = new BufferedImage(viewer.getSize().width, viewer.getSize().height, 2);
        Graphics2D g2 = bi.createGraphics();
        viewer.paint(g2);
        g2.dispose();
        try {
            File suggestedFile = TreeViewer.generateNonExistingPngFile();
            JFileChooserConfirmOverwrite fileChooser = new JFileChooserConfirmOverwrite();
            fileChooser.setCurrentDirectory(suggestedFile.getParentFile());
            fileChooser.setSelectedFile(suggestedFile);
            FileFilter pngFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isFile()) {
                        return pathname.getName().toLowerCase().endsWith(".png");
                    }
                    return true;
                }

                @Override
                public String getDescription() {
                    return "PNG Files (*.png)";
                }
            };
            fileChooser.addChoosableFileFilter(pngFilter);
            fileChooser.setFileFilter(pngFilter);
            int returnValue = fileChooser.showSaveDialog(dialog);
            if (returnValue == 0) {
                File pngFile = fileChooser.getSelectedFile();
                ImageIO.write((RenderedImage)bi, "png", pngFile);
                try {
                    Desktop.getDesktop().open(pngFile.getParentFile());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(dialog, "Saved PNG to: " + pngFile.getAbsolutePath());
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(dialog, "Could not export to PNG: " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    private static File generateNonExistingPngFile() {
        String parent = ".";
        String name = "antlr4_parse_tree";
        String extension = ".png";
        File pngFile = new File(".", "antlr4_parse_tree.png");
        int counter = 1;
        while (pngFile.exists()) {
            pngFile = new File(".", "antlr4_parse_tree_" + counter + ".png");
            ++counter;
        }
        return pngFile;
    }

    private static void fillTree(TreeNodeWrapper node, Tree tree, TreeViewer viewer) {
        if (tree == null) {
            return;
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree childTree = tree.getChild(i);
            TreeNodeWrapper childNode = new TreeNodeWrapper(childTree, viewer);
            node.add(childNode);
            TreeViewer.fillTree(childNode, childTree, viewer);
        }
    }

    private Dimension getScaledTreeSize() {
        Dimension scaledTreeSize = this.treeLayout.getBounds().getBounds().getSize();
        scaledTreeSize = new Dimension((int)((double)scaledTreeSize.width * this.scale), (int)((double)scaledTreeSize.height * this.scale));
        return scaledTreeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<JDialog> open() {
        final TreeViewer viewer = this;
        viewer.setScale(1.5);
        Callable<JDialog> callable = new Callable<JDialog>(){
            JDialog result;

            @Override
            public JDialog call() throws Exception {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result = TreeViewer.showInDialog(viewer);
                    }
                });
                return this.result;
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<JDialog> future = executor.submit(callable);
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    public void save(String fileName) throws IOException, PrintException {
        JDialog dialog = new JDialog();
        Container contentPane = dialog.getContentPane();
        ((JComponent)contentPane).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add(this);
        contentPane.setBackground(Color.white);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.dispose();
        GraphicsSupport.saveImage(this, fileName);
    }

    protected Rectangle2D.Double getBoundsOfNode(Tree node) {
        return this.treeLayout.getNodeBounds().get(node);
    }

    protected String getText(Tree tree) {
        String s2 = this.treeTextProvider.getText(tree);
        s2 = Utils.escapeWhitespace(s2, true);
        return s2;
    }

    public TreeTextProvider getTreeTextProvider() {
        return this.treeTextProvider;
    }

    public void setTreeTextProvider(TreeTextProvider treeTextProvider) {
        this.treeTextProvider = treeTextProvider;
    }

    public void setFontSize(int sz) {
        this.fontSize = sz;
        this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
    }

    public void setFontName(String name) {
        this.fontName = name;
        this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
    }

    public void addHighlightedNodes(Collection<Tree> nodes) {
        this.highlightedNodes = new ArrayList<Tree>();
        this.highlightedNodes.addAll(nodes);
    }

    public void removeHighlightedNodes(Collection<Tree> nodes) {
        if (this.highlightedNodes != null) {
            for (Tree t : nodes) {
                int i = this.getHighlightedNodeIndex(t);
                if (i < 0) continue;
                this.highlightedNodes.remove(i);
            }
        }
    }

    protected boolean isHighlighted(Tree node) {
        return this.getHighlightedNodeIndex(node) >= 0;
    }

    protected int getHighlightedNodeIndex(Tree node) {
        if (this.highlightedNodes == null) {
            return -1;
        }
        for (int i = 0; i < this.highlightedNodes.size(); ++i) {
            Tree t = this.highlightedNodes.get(i);
            if (t != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    public int getArcSize() {
        return this.arcSize;
    }

    public void setArcSize(int arcSize) {
        this.arcSize = arcSize;
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public void setBoxColor(Color boxColor) {
        this.boxColor = boxColor;
    }

    public Color getHighlightedBoxColor() {
        return this.highlightedBoxColor;
    }

    public void setHighlightedBoxColor(Color highlightedBoxColor) {
        this.highlightedBoxColor = highlightedBoxColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    protected TreeForTreeLayout<Tree> getTree() {
        return this.treeLayout.getTree();
    }

    public void setTree(Tree root) {
        if (root != null) {
            boolean useIdentity = true;
            this.treeLayout = new TreeLayout<Tree>(new TreeLayoutAdaptor(root), new VariableExtentProvide(this), new DefaultConfiguration(this.gapBetweenLevels, this.gapBetweenNodes), useIdentity);
            this.updatePreferredSize();
        } else {
            this.treeLayout = null;
            this.repaint();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            scale = 1.0;
        }
        this.scale = scale;
        this.updatePreferredSize();
    }

    public void setRuleNames(List<String> ruleNames) {
        this.setTreeTextProvider(new DefaultTreeTextProvider(ruleNames));
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
        }
    }

    private static class TreeNodeWrapper
    extends DefaultMutableTreeNode {
        final TreeViewer viewer;

        TreeNodeWrapper(Tree tree, TreeViewer viewer) {
            super(tree);
            this.viewer = viewer;
        }

        @Override
        public String toString() {
            return this.viewer.getText((Tree)this.getUserObject());
        }
    }

    public static class VariableExtentProvide
    implements NodeExtentProvider<Tree> {
        TreeViewer viewer;

        public VariableExtentProvide(TreeViewer viewer) {
            this.viewer = viewer;
        }

        @Override
        public double getWidth(Tree tree) {
            FontMetrics fontMetrics = this.viewer.getFontMetrics(this.viewer.font);
            String s2 = this.viewer.getText(tree);
            int w = fontMetrics.stringWidth(s2) + this.viewer.nodeWidthPadding * 2;
            return w;
        }

        @Override
        public double getHeight(Tree tree) {
            FontMetrics fontMetrics = this.viewer.getFontMetrics(this.viewer.font);
            int h2 = fontMetrics.getHeight() + this.viewer.nodeHeightPadding * 2;
            String s2 = this.viewer.getText(tree);
            String[] lines = s2.split("\n");
            return h2 * lines.length;
        }
    }

    public static class DefaultTreeTextProvider
    implements TreeTextProvider {
        private final List<String> ruleNames;

        public DefaultTreeTextProvider(List<String> ruleNames) {
            this.ruleNames = ruleNames;
        }

        @Override
        public String getText(Tree node) {
            return String.valueOf(Trees.getNodeText(node, this.ruleNames));
        }
    }
}

