/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.impl.AbstractCommonRange;
import net.ossindex.version.impl.AndRange;

public class OrRange
extends AbstractCommonRange {
    private SortedSet<IVersionRange> ranges = new TreeSet<IVersionRange>();
    private String type;
    private boolean hasErrors = false;

    public OrRange(IVersionRange range1, IVersionRange range2) {
        this.ranges.add(range1);
        this.ranges.add(range2);
    }

    public OrRange(List<IVersionRange> results) {
        this.ranges.addAll(results);
    }

    @Override
    public boolean contains(IVersion version) {
        for (IVersionRange range : this.ranges) {
            if (!range.contains(version)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public IVersion getMinimum() {
        Iterator it = this.ranges.iterator();
        IVersionRange r1 = (IVersionRange)it.next();
        IVersion min2 = r1.getMinimum();
        while (it.hasNext()) {
            IVersionRange r2 = (IVersionRange)it.next();
            IVersion v2 = r2.getMinimum();
            int cmp = min2.compareTo(v2);
            if (cmp <= 0) continue;
            min2 = v2;
            return min2;
        }
        return min2;
    }

    @Override
    public IVersion getMaximum() {
        Iterator it = this.ranges.iterator();
        IVersionRange r1 = (IVersionRange)it.next();
        IVersion max2 = r1.getMaximum();
        while (it.hasNext()) {
            IVersionRange r2 = (IVersionRange)it.next();
            IVersion v2 = r2.getMinimum();
            int cmp = max2.compareTo(v2);
            if (cmp <= 0) continue;
            max2 = v2;
            return max2;
        }
        return max2;
    }

    public String getOperator() {
        return "|";
    }

    @Override
    public boolean intersects(IVersionRange yourRange) {
        for (IVersionRange range : this.ranges) {
            if (!range.intersects(yourRange)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IVersionRange getSimplifiedRange() {
        return this;
    }

    @Override
    public String getType() {
        if (this.type == null) {
            for (IVersionRange range : this.ranges) {
                this.type = range.getType();
                if (this.type == null) continue;
                break;
            }
        }
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setHasErrors(boolean b) {
        this.hasErrors = b;
    }

    @Override
    public boolean hasErrors() {
        if (this.hasErrors) {
            return true;
        }
        for (IVersionRange range : this.ranges) {
            if (!range.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator it = this.ranges.iterator();
        while (it.hasNext()) {
            IVersionRange range = (IVersionRange)it.next();
            if (!range.isDiscrete() && !range.isSimple()) {
                sb.append("(");
            }
            sb.append(range);
            if (!range.isDiscrete() && !range.isSimple()) {
                sb.append(")");
            }
            if (!it.hasNext()) continue;
            sb.append(" | ");
        }
        return sb.toString();
    }

    @Override
    public String toMavenString() {
        StringBuilder sb = new StringBuilder();
        Iterator it = this.ranges.iterator();
        while (it.hasNext()) {
            IVersionRange range = (IVersionRange)it.next();
            sb.append(range.toMavenString());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public OrRange add(IVersionRange range) {
        this.ranges.add(range);
        return this;
    }

    @Override
    public IVersionRange invert() {
        if (this.ranges.size() == 2) {
            IVersionRange irange1 = this.ranges.first().invert();
            IVersionRange irange2 = this.ranges.last().invert();
            return new AndRange(irange1, irange2);
        }
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.ranges.size();
    }

    public IVersionRange first() {
        return this.ranges.first();
    }

    public IVersionRange last() {
        return this.ranges.last();
    }
}

